/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.upload;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.data.NetworkHelper;
import com.fr.general.IOUtils;
import com.fr.general.http.HttpClient;
import com.fr.stable.StringUtils;
import com.fr.web.core.upload.SmartFile;
import com.fr.web.core.upload.SmartFiles;
import com.fr.web.core.upload.SmartRequest;
import com.fr.web.core.upload.SmartUploadException;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SmartUpload {
    protected byte[] m_binArray;
    protected HttpServletRequest m_request;
    protected HttpServletResponse m_response;
    protected ServletContext m_application;
    private int m_totalBytes = 0;
    private int m_currentIndex = 0;
    private int m_startData = 0;
    private int m_endData = 0;
    private String m_boundary = "";
    private long m_totalMaxFileSize = 0L;
    private long m_maxFileSize = 0L;
    private Vector m_deniedFilesList = new Vector();
    private Vector m_allowedFilesList = new Vector();
    private boolean m_denyPhysicalPath = false;
    private String m_contentDisposition = "";
    private static final int SPEC_HEADER_CHAR = 13;
    private static final int DATA_LEN = 128;
    private SmartFiles m_files = new SmartFiles();
    private SmartRequest m_formRequest = new SmartRequest();
    private String[] FileNames;

    public final void init(ServletConfig servletConfig) throws ServletException {
        this.m_application = servletConfig.getServletContext();
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.m_request = httpServletRequest;
        this.m_response = httpServletResponse;
    }

    public final void initialize(ServletConfig servletConfig, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.m_application = servletConfig.getServletContext();
        this.m_request = httpServletRequest;
        this.m_response = httpServletResponse;
    }

    public final void initialize(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.m_application = servletContext;
        this.m_request = httpServletRequest;
        this.m_response = httpServletResponse;
    }

    public void upload() throws ServletException, IOException, SmartUploadException {
        InputStream inputStream;
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        this.m_totalBytes = this.m_request.getContentLength();
        if (this.m_totalBytes < 0) {
            return;
        }
        if (WebUtils.getHTTPRequestParameter(this.m_request, "__redirect_from") != null) {
            inputStream = HttpClient.getInputStream(this.m_request);
            this.m_binArray = IOUtils.inputStream2Bytes(inputStream);
        } else {
            inputStream = NetworkHelper.getRequestInputStream(this.m_request);
            this.m_binArray = IOUtils.inputStream2Bytes(inputStream);
        }
        while (!bl2 && this.m_currentIndex < this.m_totalBytes) {
            if (this.m_binArray[this.m_currentIndex] == 13) {
                bl2 = true;
            } else {
                this.m_boundary = this.m_boundary + (char)this.m_binArray[this.m_currentIndex];
            }
            ++this.m_currentIndex;
        }
        if (this.m_currentIndex == 1) {
            return;
        }
        ++this.m_currentIndex;
        while (this.m_currentIndex < this.m_totalBytes) {
            l = this.iteratorData(string, string2, string3, string4, string5, string6, string7, l);
            if ((char)this.m_binArray[this.m_currentIndex + 1] == '-') break;
            this.m_currentIndex += 2;
        }
    }

    private long iteratorData(String string, String string2, String string3, String string4, String string5, String string6, String string7, long l) {
        String string8 = this.getDataHeader();
        this.m_currentIndex += 2;
        boolean bl = string8.indexOf("filename") > 0;
        String string9 = this.getDataFieldValue(string8, "name");
        if (bl) {
            string3 = this.getDataFieldValue(string8, "filename");
            string = this.getFileName(string3);
            string2 = this.getFileExt(string);
            string4 = this.getContentType(string8);
            string5 = this.getContentDisp(string8);
            string6 = this.getTypeMIME(string4);
            string7 = this.getSubTypeMIME(string4);
        }
        this.getDataSection();
        if (bl && string.length() > 0) {
            if (this.m_deniedFilesList.contains(string2)) {
                throw new SecurityException("The extension of the file is denied to be uploaded (1015).");
            }
            if (!this.m_allowedFilesList.isEmpty() && !this.m_allowedFilesList.contains(string2)) {
                throw new SecurityException("The extension of the file is not allowed to be uploaded (1010).");
            }
            if (this.m_maxFileSize > 0L && (long)(this.m_endData - this.m_startData + 1) > this.m_maxFileSize) {
                throw new SecurityException("Size exceeded for this file : " + string + " (1105).");
            }
            if (this.m_totalMaxFileSize > 0L && (l += (long)(this.m_endData - this.m_startData + 1)) > this.m_totalMaxFileSize) {
                throw new SecurityException("Total File Size exceeded (1110).");
            }
        }
        if (bl) {
            SmartFile smartFile = this.initSmartFile(string9, string, string2, string3, string4, string5, string6, string7);
            this.m_files.addFile(smartFile);
        } else {
            String string10 = new String(this.m_binArray, this.m_startData, this.m_endData - this.m_startData + 1);
            this.m_formRequest.putParameter(string9, string10);
        }
        return l;
    }

    private SmartFile initSmartFile(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        SmartFile smartFile = new SmartFile();
        smartFile.setParent(this);
        smartFile.setFieldName(string);
        smartFile.setFileName(string2);
        smartFile.setFileExt(string3);
        smartFile.setFilePathName(string4);
        smartFile.setIsMissing(string4.length() == 0);
        smartFile.setContentType(string5);
        smartFile.setContentDisp(string6);
        smartFile.setTypeMIME(string7);
        smartFile.setSubTypeMIME(string8);
        if (string5.indexOf("application/x-macbinary") > 0) {
            this.m_startData += 128;
        }
        smartFile.setSize(this.m_endData - this.m_startData + 1);
        smartFile.setStartData(this.m_startData);
        smartFile.setEndData(this.m_endData);
        return smartFile;
    }

    public int save(String string) throws ServletException, IOException, SmartUploadException {
        return this.save(string, 0);
    }

    public int save(String string, int n) throws ServletException, IOException, SmartUploadException {
        int n2 = 0;
        if (string == null) {
            string = this.m_application.getRealPath("/");
        }
        if (string.indexOf("/") != -1) {
            if (string.charAt(string.length() - 1) != '/') {
                string = string + "/";
            }
        } else if (string.charAt(string.length() - 1) != '\\') {
            string = string + "\\";
        }
        this.FileNames = new String[this.m_files.getCount()];
        for (int i = 0; i < this.m_files.getCount(); ++i) {
            if (this.m_files.getFile(i).isMissing()) continue;
            this.m_files.getFile(i).saveAs(string + this.m_files.getFile(i).getFileName(), n);
            this.FileNames[n2] = string + this.m_files.getFile(i).getFileName();
            ++n2;
        }
        return n2;
    }

    public String[] getFileNames() {
        String[] stringArray = new String[this.FileNames.length];
        System.arraycopy(this.FileNames, 0, stringArray, 0, this.FileNames.length);
        return stringArray;
    }

    public int getSize() {
        return this.m_totalBytes;
    }

    public byte getBinaryData(int n) {
        byte by;
        try {
            by = this.m_binArray[n];
        }
        catch (Exception exception) {
            throw new ArrayIndexOutOfBoundsException("Index out of range (1005).");
        }
        return by;
    }

    public SmartFiles getFiles() {
        return this.m_files;
    }

    public SmartRequest getRequest() {
        return this.m_formRequest;
    }

    public void downloadFile(String string) throws ServletException, IOException, SmartUploadException {
        this.downloadFile(string, null, null);
    }

    public void downloadFile(String string, String string2) throws ServletException, IOException, SmartUploadException, SmartUploadException {
        this.downloadFile(string, string2, null);
    }

    public void downloadFile(String string, String string2, String string3) throws ServletException, IOException, SmartUploadException {
        this.downloadFile(string, string2, string3, 65000);
    }

    public void downloadFile(String string, String string2, String string3, int n) throws ServletException, IOException, SmartUploadException {
        if (StringUtils.isEmpty(string)) {
            throw new IllegalArgumentException("File '" + string + "' not found (1040).");
        }
        if (!this.isVirtual(string) && this.m_denyPhysicalPath) {
            throw new SecurityException("Physical path is denied (1035).");
        }
        if (this.isVirtual(string)) {
            string = this.m_application.getRealPath(string);
        }
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = file.length();
        int n2 = 0;
        byte[] byArray = new byte[n];
        if (StringUtils.isEmpty(string2)) {
            string2 = "application/x-msdownload";
        }
        this.m_response.setContentType(string2);
        this.m_response.setContentLength((int)l);
        String string4 = this.m_contentDisposition = this.m_contentDisposition != null ? this.m_contentDisposition : "attachment;";
        if (StringUtils.isEmpty(string3)) {
            string3 = this.getFileName(string);
        }
        this.m_response.setHeader("Content-Disposition", this.m_contentDisposition + " filename=" + string3);
        while ((long)n2 < l) {
            int n3 = fileInputStream.read(byArray, 0, n);
            n2 += n3;
            this.m_response.getOutputStream().write(byArray, 0, n3);
        }
        fileInputStream.close();
    }

    public void downloadField(ResultSet resultSet, String string, String string2, String string3) throws ServletException, IOException, SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("The RecordSet cannot be null (1045).");
        }
        if (StringUtils.isEmpty(string)) {
            throw new IllegalArgumentException("The columnName cannot be empty (1055).");
        }
        byte[] byArray = resultSet.getBytes(string);
        if (StringUtils.isEmpty(string2)) {
            string2 = "application/x-msdownload";
        }
        this.m_response.setContentType(string2);
        this.m_response.setContentLength(byArray.length);
        String string4 = StringUtils.isEmpty(string3) ? "attachment;" : "attachment; filename=" + string3;
        this.m_response.setHeader("Content-Disposition", string4);
        this.m_response.getOutputStream().write(byArray, 0, byArray.length);
    }

    public void fieldToFile(ResultSet resultSet, String string, String string2) throws ServletException, IOException, SmartUploadException, SQLException {
        try {
            int n;
            if (this.m_application.getRealPath(string2) != null) {
                string2 = this.m_application.getRealPath(string2);
            }
            InputStream inputStream = resultSet.getBinaryStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            while ((n = inputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new SmartUploadException("Unable to save file from the DataBase (1020).");
        }
    }

    private String getDataFieldValue(String string, String string2) {
        String string3 = "";
        String string4 = "";
        int n = 0;
        string3 = string2 + "=" + '\"';
        n = string.indexOf(string3);
        if (n > 0) {
            int n2;
            int n3 = n2 = n + string3.length();
            string3 = "\"";
            int n4 = string.indexOf(string3, n2);
            if (n3 > 0 && n4 > 0) {
                string4 = string.substring(n3, n4);
            }
        }
        return string4;
    }

    private String getFileExt(String string) {
        int n = 0;
        int n2 = 0;
        if (string == null) {
            return null;
        }
        n = string.lastIndexOf(46) + 1;
        n2 = string.length();
        String string2 = string.substring(n, n2);
        if (string.lastIndexOf(46) > 0) {
            return string2;
        }
        return "";
    }

    private String getContentType(String string) {
        String string2 = "";
        String string3 = "";
        int n = 0;
        string2 = "Content-Type:";
        n = string.indexOf(string2) + string2.length();
        if (n != -1) {
            int n2 = string.length();
            string3 = string.substring(n, n2);
        }
        return string3;
    }

    private String getTypeMIME(String string) {
        int n = 0;
        n = string.indexOf("/");
        if (n != -1) {
            return string.substring(1, n);
        }
        return string;
    }

    private String getSubTypeMIME(String string) {
        int n = 0;
        n = string.indexOf("/") + 1;
        if (n != -1) {
            int n2 = string.length();
            return string.substring(n, n2);
        }
        return string;
    }

    private String getContentDisp(String string) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        n = string.indexOf(":") + 1;
        n2 = string.indexOf(";");
        string2 = string.substring(n, n2);
        return string2;
    }

    private void getDataSection() {
        int n = this.m_currentIndex;
        int n2 = 0;
        int n3 = this.m_boundary.length();
        this.m_startData = this.m_currentIndex;
        this.m_endData = 0;
        while (n < this.m_totalBytes) {
            if (this.m_binArray[n] == (byte)this.m_boundary.charAt(n2)) {
                if (n2 == n3 - 1) {
                    this.m_endData = n - n3 + 1 - 3;
                    break;
                }
                ++n;
                ++n2;
                continue;
            }
            ++n;
            n2 = 0;
        }
        this.m_currentIndex = this.m_endData + n3 + 3;
    }

    private String getDataHeader() {
        int n = this.m_currentIndex;
        int n2 = 0;
        boolean bl = false;
        while (!bl) {
            if (this.m_binArray[this.m_currentIndex] == 13 && this.m_binArray[this.m_currentIndex + 2] == 13) {
                bl = true;
                n2 = this.m_currentIndex - 1;
                this.m_currentIndex += 2;
                continue;
            }
            ++this.m_currentIndex;
        }
        String string = "";
        try {
            string = new String(this.m_binArray, n, n2 - n + 1, ConfigManager.getProviderInstance().getServerCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRContext.getLogger().error(unsupportedEncodingException.getMessage());
        }
        return string;
    }

    private String getFileName(String string) {
        int n = 0;
        n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1, string.length());
        }
        n = string.lastIndexOf(92);
        if (n != -1) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    public void setDeniedFilesList(String string) throws ServletException, IOException, SQLException {
        if (string != null) {
            String string2 = "";
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == ',') {
                    if (!this.m_deniedFilesList.contains(string2)) {
                        this.m_deniedFilesList.addElement(string2);
                    }
                    string2 = "";
                    continue;
                }
                string2 = string2 + string.charAt(i);
            }
            if (StringUtils.isNotEmpty(string2)) {
                this.m_deniedFilesList.addElement(string2);
            }
        } else {
            this.m_deniedFilesList = null;
        }
    }

    public void setAllowedFilesList(String string) {
        if (string != null) {
            String string2 = "";
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == ',') {
                    if (!this.m_allowedFilesList.contains(string2)) {
                        this.m_allowedFilesList.addElement(string2);
                    }
                    string2 = "";
                    continue;
                }
                string2 = string2 + string.charAt(i);
            }
            if (StringUtils.isNotEmpty(string2)) {
                this.m_allowedFilesList.addElement(string2);
            }
        } else {
            this.m_allowedFilesList = null;
        }
    }

    public void setDenyPhysicalPath(boolean bl) {
        this.m_denyPhysicalPath = bl;
    }

    public void setForcePhysicalPath(boolean bl) {
    }

    public void setContentDisposition(String string) {
        this.m_contentDisposition = string;
    }

    public void setTotalMaxFileSize(long l) {
        this.m_totalMaxFileSize = l;
    }

    public void setMaxFileSize(long l) {
        this.m_maxFileSize = l;
    }

    protected String getPhysicalPath(String string, int n) throws IOException {
        File file;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        string4 = System.getProperty("file.separator");
        if (StringUtils.isEmpty(string)) {
            throw new IllegalArgumentException("There is no specified destination file (1140).");
        }
        if (string.lastIndexOf("\\") >= 0) {
            string2 = string.substring(0, string.lastIndexOf("\\"));
            string3 = string.substring(string.lastIndexOf("\\") + 1);
        }
        if (string.lastIndexOf("/") >= 0) {
            string2 = string.substring(0, string.lastIndexOf("/"));
            string3 = string.substring(string.lastIndexOf("/") + 1);
        }
        if ((file = new File(string2 = string2.length() != 0 ? string2 : "/")).exists()) {
            bl = true;
        }
        if (n == 0) {
            return this.getPathCheckDeny(string2, string4, string3, string2, bl);
        }
        if (n == 1) {
            return this.getPathThrowDeny(string2, string4, string3, string2, bl);
        }
        if (n == 2) {
            if (bl) {
                if (this.m_denyPhysicalPath) {
                    throw new IllegalArgumentException("Physical path is denied (1125).");
                }
                return string;
            }
            if (this.isVirtual(string2)) {
                throw new IllegalArgumentException("The path is not a physical path.");
            }
            throw new IllegalArgumentException("This path does not exist (1135).");
        }
        return null;
    }

    private String getPathThrowDeny(String string, String string2, String string3, String string4, boolean bl) {
        if (this.isVirtual(string)) {
            string = (string = this.m_application.getRealPath(string)).endsWith(string2) ? string + string3 : string + string2 + string3;
            return string;
        }
        if (bl) {
            throw new IllegalArgumentException("The path is not a virtual path.");
        }
        throw new IllegalArgumentException("This path does not exist (1135).");
    }

    private String getPathCheckDeny(String string, String string2, String string3, String string4, boolean bl) {
        if (this.isVirtual(string)) {
            string = (string = this.m_application.getRealPath(string)).endsWith(string2) ? string + string3 : string + string2 + string3;
            return string;
        }
        if (bl) {
            if (this.m_denyPhysicalPath) {
                throw new IllegalArgumentException("Physical path is denied (1125).");
            }
            return string4;
        }
        throw new IllegalArgumentException("This path does not exist (1135).");
    }

    public void uploadInFile(String string) throws IOException, SmartUploadException {
        Object object;
        int n;
        int n2 = 0;
        if (string == null) {
            throw new IllegalArgumentException("There is no specified destination file (1025).");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("There is no specified destination file (1025).");
        }
        if (!this.isVirtual(string) && this.m_denyPhysicalPath) {
            throw new SecurityException("Physical path is denied (1035).");
        }
        n2 = this.m_request.getContentLength();
        this.m_binArray = new byte[n2];
        for (int i = 0; i < n2; i += n) {
            try {
                object = NetworkHelper.getRequestInputStream(this.m_request);
                n = ((InputStream)object).read(this.m_binArray, i, n2 - i);
                continue;
            }
            catch (Exception exception) {
                throw new SmartUploadException("Unable to upload.");
            }
        }
        if (this.isVirtual(string)) {
            string = this.m_application.getRealPath(string);
        }
        try {
            object = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            fileOutputStream.write(this.m_binArray);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new SmartUploadException("The Form cannot be saved in the specified file (1030).");
        }
    }

    private boolean isVirtual(String string) {
        if (this.m_application.getRealPath(string) != null) {
            File file = new File(this.m_application.getRealPath(string));
            return file.exists();
        }
        return false;
    }
}

