/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.utils;

import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickSelect<T> {
    private T[] array;
    private Comparator<? super T> comp;

    public int select(T[] TArray, Comparator<T> comparator, int n, int n2) {
        this.array = TArray;
        this.comp = comparator;
        return this.recursiveSelect(0, n2 - 1, n);
    }

    private int partition(int n, int n2, int n3) {
        T t = this.array[n3];
        this.swap(n2, n3);
        int n4 = n;
        for (int i = n; i < n2; ++i) {
            if (this.comp.compare(this.array[i], t) >= 0) continue;
            this.swap(n4, i);
            ++n4;
        }
        this.swap(n2, n4);
        return n4;
    }

    private int recursiveSelect(int n, int n2, int n3) {
        if (n == n2) {
            return n;
        }
        int n4 = this.medianOfThreePivot(n, n2);
        int n5 = this.partition(n, n2, n4);
        int n6 = n5 - n + 1;
        int n7 = n6 == n3 ? n5 : (n3 < n6 ? this.recursiveSelect(n, n5 - 1, n3) : this.recursiveSelect(n5 + 1, n2, n3 - n6));
        return n7;
    }

    private int medianOfThreePivot(int n, int n2) {
        T t = this.array[n];
        int n3 = (n + n2) / 2;
        T t2 = this.array[n3];
        T t3 = this.array[n2];
        if (this.comp.compare(t, t2) > 0) {
            if (this.comp.compare(t2, t3) > 0) {
                return n3;
            }
            if (this.comp.compare(t, t3) > 0) {
                return n2;
            }
            return n;
        }
        if (this.comp.compare(t, t3) > 0) {
            return n;
        }
        if (this.comp.compare(t2, t3) > 0) {
            return n2;
        }
        return n3;
    }

    private void swap(int n, int n2) {
        T t = this.array[n];
        this.array[n] = this.array[n2];
        this.array[n2] = t;
    }
}

