/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.IntArray;
import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import java.util.NoSuchElementException;

public class IntSet {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    private static final int EMPTY = 0;
    public int size;
    int[] keyTable;
    int capacity;
    int stashSize;
    boolean hasZeroValue;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private IntSetIterator iterator1;
    private IntSetIterator iterator2;

    public IntSet() {
        this(51, 0.8f);
    }

    public IntSet(int n) {
        this(n, 0.8f);
    }

    public IntSet(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n);
        }
        if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n);
        }
        this.capacity = n;
        if (f <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f);
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new int[this.capacity + this.stashCapacity];
    }

    public IntSet(IntSet intSet) {
        this((int)Math.floor((float)intSet.capacity * intSet.loadFactor), intSet.loadFactor);
        this.stashSize = intSet.stashSize;
        System.arraycopy(intSet.keyTable, 0, this.keyTable, 0, intSet.keyTable.length);
        this.size = intSet.size;
        this.hasZeroValue = intSet.hasZeroValue;
    }

    public boolean add(int n) {
        int n2;
        if (n == 0) {
            if (this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = true;
            ++this.size;
            return true;
        }
        int[] nArray = this.keyTable;
        int n3 = n & this.mask;
        int n4 = nArray[n3];
        if (n4 == n) {
            return false;
        }
        int n5 = this.hash2(n);
        int n6 = nArray[n5];
        if (n6 == n) {
            return false;
        }
        int n7 = this.hash3(n);
        int n8 = nArray[n7];
        if (n8 == n) {
            return false;
        }
        int n9 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n9; ++n2) {
            if (nArray[n2] != n) continue;
            return false;
        }
        if (n4 == 0) {
            nArray[n3] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return true;
        }
        if (n6 == 0) {
            nArray[n5] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return true;
        }
        if (n8 == 0) {
            nArray[n7] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return true;
        }
        this.push(n, n3, n4, n5, n6, n7, n8);
        return true;
    }

    public void addAll(IntArray intArray) {
        this.addAll(intArray, 0, intArray.size);
    }

    public void addAll(IntArray intArray, int n, int n2) {
        if (n + n2 > intArray.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + n + " + " + n2 + " <= " + intArray.size);
        }
        this.addAll(intArray.items, n, n2);
    }

    public void addAll(int ... nArray) {
        this.addAll(nArray, 0, nArray.length);
    }

    public void addAll(int[] nArray, int n, int n2) {
        int n3;
        this.ensureCapacity(n2);
        int n4 = n3 + n2;
        for (n3 = n; n3 < n4; ++n3) {
            this.add(nArray[n3]);
        }
    }

    public void addAll(IntSet intSet) {
        this.ensureCapacity(intSet.size);
        IntSetIterator intSetIterator = intSet.iterator();
        while (intSetIterator.hasNext) {
            this.add(intSetIterator.next());
        }
    }

    private void addResize(int n) {
        if (n == 0) {
            this.hasZeroValue = true;
            return;
        }
        int n2 = n & this.mask;
        int n3 = this.keyTable[n2];
        if (n3 == 0) {
            this.keyTable[n2] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n4 = this.hash2(n);
        int n5 = this.keyTable[n4];
        if (n5 == 0) {
            this.keyTable[n4] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n6 = this.hash3(n);
        int n7 = this.keyTable[n6];
        if (n7 == 0) {
            this.keyTable[n6] = n;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n, n2, n3, n4, n5, n6, n7);
    }

    private void push(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int[] nArray = this.keyTable;
        int n9 = this.mask;
        int n10 = 0;
        int n11 = this.pushIterations;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    n8 = n3;
                    nArray[n2] = n;
                    break;
                }
                case 1: {
                    n8 = n5;
                    nArray[n4] = n;
                    break;
                }
                default: {
                    n8 = n7;
                    nArray[n6] = n;
                }
            }
            n2 = n8 & n9;
            n3 = nArray[n2];
            if (n3 == 0) {
                nArray[n2] = n8;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n4 = this.hash2(n8);
            n5 = nArray[n4];
            if (n5 == 0) {
                nArray[n4] = n8;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n6 = this.hash3(n8);
            n7 = nArray[n6];
            if (n7 == 0) {
                nArray[n6] = n8;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n10 == n11) break;
            n = n8;
        }
        this.addStash(n8);
    }

    private void addStash(int n) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.add(n);
            return;
        }
        int n2 = this.capacity + this.stashSize;
        this.keyTable[n2] = n;
        ++this.stashSize;
        ++this.size;
    }

    public boolean remove(int n) {
        if (n == 0) {
            if (!this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = false;
            --this.size;
            return true;
        }
        int n2 = n & this.mask;
        if (this.keyTable[n2] == n) {
            this.keyTable[n2] = 0;
            --this.size;
            return true;
        }
        n2 = this.hash2(n);
        if (this.keyTable[n2] == n) {
            this.keyTable[n2] = 0;
            --this.size;
            return true;
        }
        n2 = this.hash3(n);
        if (this.keyTable[n2] == n) {
            this.keyTable[n2] = 0;
            --this.size;
            return true;
        }
        return this.removeStash(n);
    }

    boolean removeStash(int n) {
        int n2;
        int[] nArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (nArray[n2] != n) continue;
            this.removeStashIndex(n2);
            --this.size;
            return true;
        }
        return false;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            this.keyTable[n] = this.keyTable[n2];
        }
    }

    public void shrink(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n);
        }
        if (this.size > n) {
            n = this.size;
        }
        if (this.capacity <= n) {
            return;
        }
        n = MathUtils.nextPowerOfTwo(n);
        this.resize(n);
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(n);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        int[] nArray = this.keyTable;
        int n = this.capacity + this.stashSize;
        while (n-- > 0) {
            nArray[n] = 0;
        }
        this.size = 0;
        this.stashSize = 0;
        this.hasZeroValue = false;
    }

    public boolean contains(int n) {
        if (n == 0) {
            return this.hasZeroValue;
        }
        int n2 = n & this.mask;
        if (this.keyTable[n2] != n && this.keyTable[n2 = this.hash2(n)] != n && this.keyTable[n2 = this.hash3(n)] != n) {
            return this.containsKeyStash(n);
        }
        return true;
    }

    private boolean containsKeyStash(int n) {
        int n2;
        int[] nArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (nArray[n2] != n) continue;
            return true;
        }
        return false;
    }

    public int first() {
        if (this.hasZeroValue) {
            return 0;
        }
        int[] nArray = this.keyTable;
        int n = this.capacity + this.stashSize;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == 0) continue;
            return nArray[i];
        }
        throw new IllegalStateException("IntSet is empty.");
    }

    public void ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n2 / this.loadFactor)));
        }
    }

    private void resize(int n) {
        int n2 = this.capacity + this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(n) / 8);
        int[] nArray = this.keyTable;
        this.keyTable = new int[n + this.stashCapacity];
        int n3 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n3 > 0) {
            for (int i = 0; i < n2; ++i) {
                int n4 = nArray[i];
                if (n4 == 0) continue;
                this.addResize(n4);
            }
        }
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.capacity + this.stashSize;
        for (int i = 0; i < n2; ++i) {
            if (this.keyTable[i] == 0) continue;
            n += this.keyTable[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntSet)) {
            return false;
        }
        IntSet intSet = (IntSet)object;
        if (intSet.size != this.size) {
            return false;
        }
        if (intSet.hasZeroValue != this.hasZeroValue) {
            return false;
        }
        int n = this.capacity + this.stashSize;
        for (int i = 0; i < n; ++i) {
            if (this.keyTable[i] == 0 || intSet.contains(this.keyTable[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        int[] nArray = this.keyTable;
        int n2 = nArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0");
        } else {
            while (n2-- > 0) {
                n = nArray[n2];
                if (n == 0) continue;
                stringBuilder.append(n);
                break;
            }
        }
        while (n2-- > 0) {
            n = nArray[n2];
            if (n == 0) continue;
            stringBuilder.append(", ");
            stringBuilder.append(n);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public IntSetIterator iterator() {
        if (this.iterator1 == null) {
            this.iterator1 = new IntSetIterator(this);
            this.iterator2 = new IntSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public static IntSet with(int ... nArray) {
        IntSet intSet = new IntSet();
        intSet.addAll(nArray);
        return intSet;
    }

    public static class IntSetIterator {
        static final int INDEX_ILLEGAL = -2;
        static final int INDEX_ZERO = -1;
        public boolean hasNext;
        final IntSet set;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public IntSetIterator(IntSet intSet) {
            this.set = intSet;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.set.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        void findNextIndex() {
            this.hasNext = false;
            int[] nArray = this.set.keyTable;
            int n = this.set.capacity + this.set.stashSize;
            while (++this.nextIndex < n) {
                if (nArray[this.nextIndex] == 0) continue;
                this.hasNext = true;
                break;
            }
        }

        public void remove() {
            if (this.currentIndex == -1 && this.set.hasZeroValue) {
                this.set.hasZeroValue = false;
            } else {
                if (this.currentIndex < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                if (this.currentIndex >= this.set.capacity) {
                    this.set.removeStashIndex(this.currentIndex);
                    this.nextIndex = this.currentIndex - 1;
                    this.findNextIndex();
                } else {
                    this.set.keyTable[this.currentIndex] = 0;
                }
            }
            this.currentIndex = -2;
            --this.set.size;
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.nextIndex == -1 ? 0 : this.set.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return n;
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.set.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }
}

