/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class StringUtils {
    public static final String EMPTY = "";
    public static final String BLANK = " ";

    private StringUtils() {
    }

    public static String alwaysNotNull(String string) {
        return string == null ? EMPTY : string;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static boolean isBlank(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String cutStringStartWith(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        if (!string.startsWith(string2)) {
            return string;
        }
        return string.substring(string2.length());
    }

    public static String cutStringEndWith(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        if (!string.endsWith(string2)) {
            return string;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static boolean isNotBlank(String string) {
        return !StringUtils.isBlank(string);
    }

    public static String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static String trimToNull(String string) {
        String string2 = StringUtils.trim(string);
        return StringUtils.isEmpty(string2) ? null : string2;
    }

    public static String perfectStart(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string.startsWith(string2) ? string : string2 + string;
    }

    public static String perfectEnd(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string.endsWith(string2) ? string : string + string2;
    }

    public static String perfectSurround(String string, String string2) {
        if (string == null) {
            return string2;
        }
        string = string.endsWith(string2) ? string : string + string2;
        string = string.startsWith(string2) ? string : string2 + string;
        return string;
    }

    public static int getLength(String string) {
        return string == null ? 0 : string.length();
    }

    public static boolean equalsIgnore(String string, String string2, String string3) {
        return StringUtils.perfectStart(StringUtils.perfectEnd(string, string3), string3).equals(StringUtils.perfectStart(StringUtils.perfectEnd(string2, string3), string3));
    }

    public static boolean contains(String string, String string2) {
        return string != null && string.indexOf(string2) > -1;
    }

    public static StringTokenizer text2StringTokenizer(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\r') {
                if (i < n - 1 && string.charAt(i + 1) == '\n') {
                    stringTokenizer = new StringTokenizer(string, "\r\n");
                    break;
                }
                stringTokenizer = new StringTokenizer(string, "\r");
                break;
            }
            if (c == '\n') break;
        }
        return stringTokenizer;
    }

    public static String join(String string, String[] stringArray) {
        int n = stringArray.length;
        if (n == 0) {
            return EMPTY;
        }
        StringBuffer stringBuffer = new StringBuffer(n * stringArray[0].length()).append(stringArray[0]);
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(string).append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String parseVersion(String string) {
        string = string.replace('A', '0');
        string = string.replace('B', '1');
        string = string.replace('C', '2');
        string = string.replace('D', '3');
        string = string.replace('E', '4');
        string = string.replace('F', '5');
        string = string.replace('G', '6');
        string = string.replace('H', '7');
        string = string.replace('I', '8');
        string = string.replace('J', '9');
        return string;
    }

    public static boolean isArrayType(String string) {
        return string != null && (string.startsWith("[") && string.endsWith("]") || string.startsWith("[[") && string.endsWith("]]"));
    }

    public static String[][] stringToArray(String string) {
        if (StringUtils.isArrayType(string)) {
            if ((string = string.replaceAll("\"", EMPTY)).startsWith("[[") && string.endsWith("]]")) {
                String[] stringArray = string.substring(2, string.length() - 2).split("],\\[");
                String[][] stringArray2 = new String[stringArray.length][];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = stringArray[i].split(",");
                }
                return stringArray2;
            }
            String[][] stringArray = new String[][]{string.substring(1, string.length() - 1).split(",")};
            return stringArray;
        }
        String[] stringArray = string.split(";");
        String[][] stringArray3 = new String[stringArray.length][];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = stringArray[i].split(",");
        }
        return stringArray3;
    }

    public static String subStringByByteLength(String string, String string2, int n) throws UnsupportedEncodingException {
        if (StringUtils.isBlank(string) || n <= 0) {
            return EMPTY;
        }
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = cArray.length;
        for (int i = 0; i < cArray.length; ++i) {
            int n4 = String.valueOf(cArray[i]).getBytes(string2).length + n2;
            if (n4 > n) {
                n3 = i;
                break;
            }
            n2 = n4;
        }
        return String.valueOf(cArray, 0, n3);
    }
}

