/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.providers.dao;

import com.fr.data.core.DataCoreUtils;
import com.fr.data.impl.NameTableData;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.privilege.Authentication;
import com.fr.privilege.Authority;
import com.fr.privilege.providers.AbstractAuthenticationProvider;
import com.fr.privilege.providers.dao.PasswordValidator;
import com.fr.privilege.user.User;
import com.fr.privilege.user.UserDetails;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class DaoAuthenticationProvider
extends AbstractAuthenticationProvider {
    private static final long serialVersionUID = -2564032298178563645L;
    private UserConfig userConfig;
    private RoleConfig roleConfig;
    private PasswordValidator passwordValidator = PasswordValidator.EMPTY_PASSWORD_VALIDATOR;

    public UserConfig getUserConfig() {
        return this.userConfig;
    }

    public void setUserConfig(UserConfig userConfig) {
        this.userConfig = userConfig;
    }

    public RoleConfig getRoleConfig() {
        return this.roleConfig;
    }

    public void setRoleConfig(RoleConfig roleConfig) {
        this.roleConfig = roleConfig;
    }

    public PasswordValidator getPasswordValidator() {
        return this.passwordValidator;
    }

    public void setPasswordValidator(PasswordValidator passwordValidator) {
        this.passwordValidator = passwordValidator;
    }

    public int uType() {
        return 0;
    }

    public boolean authenticate(Authentication authentication) throws Exception {
        super.isRootManager(authentication);
        if (authentication == null) {
            throw new Exception(Inter.getLocText("Privilege-The_Authentication_Can_Not_Be_Null") + ".");
        }
        if (authentication.isAuthenticated()) {
            return true;
        }
        String string = authentication.getPrincipal().toString();
        String string2 = authentication.getCredentials().toString();
        User user = this.loadUserByUsername(string);
        if (user == null) {
            throw new Exception(Inter.getLocText("Privilege-Invalid_User_Or_Password") + ".");
        }
        String string3 = string;
        if (this.passwordValidator.shouldIgnoreUsername()) {
            string3 = "";
        }
        if (!this.passwordValidator.validatePassword(user.getPassword(), string2, string3)) {
            throw new Exception(Inter.getLocText("Privilege-Invalid_User_Or_Password") + ".");
        }
        authentication.setAuthenticated(true);
        authentication.setAuthorities(user.getAuthorities());
        return true;
    }

    public boolean isDetailAuthority() {
        return true;
    }

    public Authority[] listAuthorities() throws Exception {
        if (this.roleConfig == null) {
            return new Authority[0];
        }
        return this.roleConfig.listAuthorities();
    }

    private User loadUserByUsername(String string) throws Exception {
        if (this.userConfig == null) {
            throw new Exception(Inter.getLocText("Privilege-The_User_Config_Can_Not_Be_Null") + ".");
        }
        if (this.roleConfig == null) {
            FRLogger.getLogger().log(Level.INFO, "No username-rolename defined.");
        }
        try {
            String string2 = this.userConfig.getPasswordByUsername(string);
            boolean bl = string2 != null;
            Authority[] authorityArray = null;
            if (bl && this.roleConfig != null) {
                authorityArray = this.roleConfig.getAuthoritiesByUsername(string);
            }
            return bl ? new UserDetails(string, string2, authorityArray) : null;
        }
        catch (Exception exception) {
            throw new Exception(Inter.getLocText(new String[]{"Database", "Datasource-Connection_failed"}) + "!");
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("UserConfig".equals(string)) {
                this.userConfig = (UserConfig)GeneralXMLTools.readXMLable(xMLableReader);
            } else if ("RoleConfig".equals(string)) {
                this.roleConfig = (RoleConfig)GeneralXMLTools.readXMLable(xMLableReader);
            } else if ("PasswordValidator".equals(string)) {
                this.passwordValidator = (PasswordValidator)GeneralXMLTools.readXMLable(xMLableReader);
                if (this.passwordValidator == null) {
                    this.passwordValidator = PasswordValidator.EMPTY_PASSWORD_VALIDATOR;
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.userConfig != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.userConfig, "UserConfig");
        }
        if (this.roleConfig != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.roleConfig, "RoleConfig");
        }
        if (this.passwordValidator != null && this.passwordValidator != PasswordValidator.EMPTY_PASSWORD_VALIDATOR) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.passwordValidator, "PasswordValidator");
        }
    }

    public static class RoleConfig
    extends TDConfig {
        private static final long serialVersionUID = -3118897597761738397L;
        public static final String XML_TAG = "RoleConfig";
        private boolean listall = false;

        public RoleConfig() {
            this.authenticationAttr = "role";
        }

        public RoleConfig(String string, String string2, String string3) {
            super(string, string2, string3);
            this.authenticationAttr = "role";
        }

        public Object getContentFromDB(DataModel dataModel, String string) throws TableDataException {
            int[] nArray = DataCoreUtils.getColumnIndics(dataModel, new String[]{this.usernameField, this.authenticationField});
            ArrayList<Authority> arrayList = new ArrayList<Authority>();
            if (this.listall) {
                if (nArray[1] < 0) {
                    return null;
                }
                int n = dataModel.getRowCount();
                for (int i = 0; i < n; ++i) {
                    String string2;
                    Authority authority;
                    Object object = dataModel.getValueAt(i, nArray[1]);
                    if (object == null || arrayList.contains(authority = new Authority(string2 = object.toString()))) continue;
                    arrayList.add(authority);
                }
            } else {
                int n = dataModel.getRowCount();
                for (int i = 0; i < n; ++i) {
                    String string3;
                    Object object = dataModel.getValueAt(i, nArray[0]);
                    if (object == null || !ComparatorUtils.equals(string3 = object.toString(), string)) continue;
                    String string4 = dataModel.getValueAt(i, nArray[1]).toString();
                    arrayList.add(new Authority(string4));
                }
            }
            return arrayList;
        }

        public Authority[] getAuthoritiesByUsername(String string) throws Exception {
            this.listall = false;
            List list = (List)this.getContentByUsername(string);
            return list.toArray(new Authority[list.size()]);
        }

        public Authority[] listAuthorities() throws Exception {
            this.listall = true;
            List list = (List)this.getContentByUsername(null);
            return list.toArray(new Authority[list.size()]);
        }
    }

    public static class UserConfig
    extends TDConfig {
        private static final long serialVersionUID = 1364310276408263120L;
        public static final String XML_TAG = "UserConfig";

        public UserConfig() {
            this.authenticationAttr = "password";
        }

        public UserConfig(String string, String string2, String string3) {
            super(string, string2, string3);
            this.authenticationAttr = "password";
        }

        public Object getContentFromDB(DataModel dataModel, String string) throws TableDataException {
            int[] nArray = DataCoreUtils.getColumnIndics(dataModel, new String[]{this.usernameField, this.authenticationField});
            String string2 = null;
            int n = dataModel.getRowCount();
            for (int i = 0; i < n; ++i) {
                String string3 = dataModel.getValueAt(i, nArray[0]).toString();
                if (!ComparatorUtils.equals(string3, string)) continue;
                if (dataModel.getValueAt(i, nArray[1]) == null) {
                    string2 = "";
                    break;
                }
                string2 = dataModel.getValueAt(i, nArray[1]).toString();
                break;
            }
            return string2;
        }

        public String getPasswordByUsername(String string) throws Exception {
            return (String)this.getContentByUsername(string);
        }
    }

    private static abstract class TDConfig
    implements XMLable {
        public String tableDataName;
        public String usernameField;
        public String authenticationAttr;
        public String authenticationField;

        public TDConfig() {
        }

        public TDConfig(String string, String string2, String string3) {
            this.tableDataName = string;
            this.usernameField = string2;
            this.authenticationField = string3;
        }

        public String getAuthenticationField() {
            return this.authenticationField;
        }

        public void setAuthenticationField(String string) {
            this.authenticationField = string;
        }

        public Object getContentByUsername(String string) throws Exception {
            if (StringUtils.isBlank(this.tableDataName)) {
                throw new Exception("The tabledata can not be null.");
            }
            String string2 = this.tableDataName;
            NameTableData nameTableData = new NameTableData(string2);
            DataModel dataModel = nameTableData == null ? null : nameTableData.createDataModel(null);
            Object object = this.getContentFromDB(dataModel, string);
            try {
                dataModel.release();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
            return object;
        }

        public abstract Object getContentFromDB(DataModel var1, String var2) throws TableDataException;

        public void readXML(XMLableReader xMLableReader) {
            String string;
            if (xMLableReader.isAttr()) {
                this.tableDataName = xMLableReader.getAttrAsString("tabledata", null);
                this.usernameField = xMLableReader.getAttrAsString("username", null);
            }
            if (xMLableReader.isAttr()) {
                this.authenticationField = xMLableReader.getAttrAsString(this.authenticationAttr, null);
            }
            if (xMLableReader.isChildNode() && ((string = xMLableReader.getTagName()).equals("UserConfigAttr") || string.equals("RoleConfigAttr"))) {
                this.tableDataName = xMLableReader.getAttrAsString("tabledata", null);
                this.usernameField = xMLableReader.getAttrAsString("username", null);
                this.authenticationField = xMLableReader.getAttrAsString(this.authenticationAttr, null);
            }
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            if (StringUtils.isNotBlank(this.tableDataName)) {
                xMLPrintWriter.attr("tabledata", this.tableDataName);
            }
            if (StringUtils.isNotBlank(this.usernameField)) {
                xMLPrintWriter.attr("username", this.usernameField);
            }
            if (StringUtils.isNotBlank(this.authenticationField)) {
                xMLPrintWriter.attr(this.authenticationAttr, this.authenticationField);
            }
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

