/*
 * Decompiled with CFR 0.152.
 */
package com.fr.function;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.GraphHelper;
import com.fr.base.Utils;
import com.fr.performance.PerformanceManager;
import com.fr.script.AbstractFunction;
import com.fr.stable.ColumnRow;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.script.Function;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;

public class TOIMAGE
extends AbstractFunction {
    private static final int HUNDRED = 100;

    public Object run(Object[] objectArray) {
        if (objectArray.length < 1) {
            return Primitive.ERROR_NAME;
        }
        Object object = objectArray[0];
        boolean bl = true;
        if (objectArray.length > 1) {
            bl = Boolean.valueOf(Utils.objectToString(objectArray[1]));
        }
        if (object instanceof String) {
            try {
                Image image = this.readImageFromPath(object, bl);
                Object object2 = image;
                if (objectArray.length > 3) {
                    object2 = this.drawExtendImage(objectArray, image);
                }
                return object2;
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
        return Primitive.ERROR_NAME;
    }

    private void record(BufferedImage bufferedImage, boolean bl) {
        if (bufferedImage == null) {
            return;
        }
        long l = PerformanceManager.getMemoryEstimation().estimateImageMemory(bufferedImage);
        String string = this.getMark();
        PerformanceManager.getRecorder().recordToImageFun(string, l, bl);
    }

    private String getMark() {
        ColumnRow columnRow = this.getCalculator().getCurrentColumnRow();
        String string = columnRow != null ? columnRow.toString() : "TOIMAGE";
        return string;
    }

    private Image readImageFromPath(Object object, boolean bl) {
        String string;
        BufferedImage bufferedImage;
        String string2 = (String)object;
        if (string2.endsWith("/") || string2.endsWith("\\")) {
            object = string2.substring(0, ((String)object).length() - 1);
        }
        if ((bufferedImage = this.getBufferedImage(bl, string = ((String)object).trim())) == null && FRContext.getCurrentEnv() != null && StringUtils.isNotBlank((String)object)) {
            String string3 = StableUtils.pathJoin(new File(FRContext.getCurrentEnv().getPath()).getParent(), Utils.objectToString(object));
            bufferedImage = this.getBufferedImage(bl, string3);
        }
        return bufferedImage;
    }

    private BufferedImage getBufferedImage(boolean bl, String string) {
        BufferedImage bufferedImage = null;
        if (bl) {
            bufferedImage = BaseUtils.readCacheImage(string);
            if (bufferedImage != null) {
                this.record(bufferedImage, true);
                return bufferedImage;
            }
            bufferedImage = BaseUtils.readImageWithCache(string);
            this.record(bufferedImage, false);
            return bufferedImage;
        }
        bufferedImage = BaseUtils.readImage(string);
        this.record(bufferedImage, false);
        return bufferedImage;
    }

    private Object drawExtendImage(Object[] objectArray, Image image) {
        int n = 0;
        int n2 = 0;
        if (image == null) {
            return Primitive.NULL;
        }
        n2 = this.getRealSize(objectArray[2], image.getWidth(null));
        n = this.getRealSize(objectArray[3], image.getHeight(null));
        if (n != 0 && n2 != 0) {
            BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n2, n, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setPaint(Color.white);
            GraphHelper.paintImage(graphics2D, n2, n, image, 2, -1, 0, -1, -1);
            return bufferedImage;
        }
        return image;
    }

    private int getRealSize(Object object, int n) {
        String string = object.toString();
        int n2 = 0;
        if (string.indexOf("%") != -1) {
            string = string.substring(0, string.length() - 1);
            n2 = (int)((double)n * (Double.parseDouble(string) / 100.0));
        } else {
            n2 = Integer.parseInt(string);
        }
        return n2;
    }

    public Function.Type getType() {
        return OTHER;
    }

    public String getCN() {
        return "TOIMAGE(path):\u663e\u793a\u6307\u5b9a\u8def\u5f84\u4e0b\u7684\u56fe\u7247\u3002\u6b64\u5904\u9ed8\u8ba4\u5f00\u542f\u4e86\u56fe\u7247\u7f13\u5b58\u529f\u80fd\u4ee5\u52a0\u901f\u62a5\u8868\u7684\u751f\u6210.\n\u5982\u4e0d\u9700\u8981\u7f13\u5b58\uff0c\u8bf7\u5728\u53c2\u6570\u540e\u9762\u8ffd\u52a0\u503cFALSE\uff0c\u4f8b\u5982\uff1aTOIMAGE(\"D:/fr.png\",false).\n\u5982\u9700\u8981\u6307\u5b9a\u56fe\u7247\u5927\u5c0f,\u62c9\u4f38\u663e\u793a, \u5219\u9700\u8981\u6dfb\u52a0\u53c2\u6570,TOIMAGE(patch, true, width, height).\n\u793a\u4f8b:=toimage(\"d:/1.jpg\", true, \"50%\", 300), \u7b2c\u4e09\u4e2a\u53c2\u6570\u4e3a\u6307\u5b9a\u5bbd\u5ea6, \u7b2c\u56db\u4e2a\u53c2\u6570\u4e3a\u6307\u5b9a\u9ad8\u5ea6.\n\u5982\u679c\u53c2\u6570\u4e3a\u6574\u6570, \u5219\u76f4\u63a5\u5199\u6570\u5b57, \u5982\u679c\u4e3a\u767e\u5206\u6bd4, \u5219\u9700\u8981\u52a0\u4e0a\u5f15\u53f7, \u5982\"300%\"";
    }

    public String getEN() {
        return "TOIMAGE (path): display images under the specified path. Here enabled by default image cache to speed up report generation capabilities.\nIf no cache, appending the value of the parameter FALSE, for example:TOIMAGE(\"D:/fr.png\",false).\nIf you need to specify the image size, stretch, you need to add parameters: TOIMAGE(patch, true, width, height).\neg, =toimage(\"d:/1.jpg\", true, \"50\", 300), The third parameter to specify the width, the fourth parameter is the height specified.\nIf the parameter is an integer, write directly to digital, as a percentage, you need the quotation marks, such as \"300%\"";
    }
}

