/*
 * Decompiled with CFR 0.152.
 */
package com.fr.function;

import com.fr.general.FArray;
import com.fr.general.script.FunctionHelper;
import com.fr.script.AbstractFunction;
import com.fr.stable.script.Function;

public class SUMSQ
extends AbstractFunction {
    public Object run(Object[] objectArray) {
        double d = 0.0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            d += this.parseSQObject(objectArray[i]);
        }
        return FunctionHelper.asNumber(d);
    }

    private double parseSQObject(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue() * ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof FArray) {
            FArray fArray = (FArray)object;
            double d = 0.0;
            int n = fArray.length();
            for (int i = 0; i < n; ++i) {
                d += this.parseSQObject(fArray.elementAt(i));
            }
            return d;
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public Function.Type getType() {
        return MATH;
    }

    public String getCN() {
        return "SUMSQ(number1,number2, ...):\u8fd4\u56de\u6240\u6709\u53c2\u6570\u7684\u5e73\u65b9\u548c\u3002\nnumber1, number2, ...:\u4e3a 1 \u5230 30 \u4e2a\u9700\u8981\u6c42\u5e73\u65b9\u548c\u7684\u53c2\u6570\uff0c\u4e5f\u53ef\u4ee5\u4f7f\u7528\u6570\u7ec4\u6216\u5bf9\u6570\u7ec4\u7684\u5f15\u7528\u6765\u4ee3\u66ff\u4ee5\u9017\u53f7\u5206\u9694\u7684\u53c2\u6570\u3002\n\u793a\u4f8b:\nSUMSQ(3, 4) \u7b49\u4e8e 25\n";
    }

    public String getEN() {
        return "SUMSQ(number1,number2, ...): Returns the sum of the squares of the arguments.\nNumber1, number2, ... are 1 to 30 arguments for which you want the sum of the squares. You can also use a single array or a reference to an array instead of arguments separated by commas.\n\nExample:\n   SUMSQ(3, 4) = 25\n";
    }
}

