/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.util.function;

import com.fr.cache.list.IntList;
import com.fr.data.SingleRowNameSpace;
import com.fr.data.core.DataCoreUtils;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.parser.DatasetFunctionCall;
import com.fr.script.Calculator;
import com.fr.script.GroupResultSequenceNameSpace;
import com.fr.stable.InterpreterError;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.Node;
import java.util.Arrays;

public abstract class DataSetFunction {
    public Object resolveDatasetFunction(DatasetFunctionCall datasetFunctionCall) {
        String string = datasetFunctionCall.getFnName().toLowerCase();
        Object object = null;
        if ("select".equals(string)) {
            object = this.resolveFunction(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments(), 'S');
        } else if ("selectfirst".equals(string)) {
            object = this.resolveFunction(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments(), 'S');
        } else if ("group".equals(string)) {
            object = this.resolveFunction(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments(), 'G');
        } else if ("xselect".equals(string)) {
            object = this.resolveXFunction(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments(), 'S');
        } else if ("xselectfirst".equals(string)) {
            object = this.resolveFunction(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments(), 'S');
        } else if ("xgroup".equals(string)) {
            object = this.resolveXFunction(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments(), 'G');
        } else {
            if ("colcount".equals(string)) {
                return this.resolveColumnCount(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments());
            }
            if ("colname".equals(string)) {
                return this.resolveColumnName(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments());
            }
            if ("column".equals(string)) {
                object = this.resolveColumn(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments());
            } else {
                if ("value".equals(string)) {
                    return this.resolveValue(datasetFunctionCall.getSourceName(), datasetFunctionCall.getArguments());
                }
                FRLogger.getLogger().error("not supported function name: " + string);
                return null;
            }
        }
        if (object instanceof FArray) {
            FArray fArray = (FArray)object;
            if (string.endsWith("selectfirst")) {
                return fArray.length() > 0 ? fArray.elementAt(0) : null;
            }
            return fArray.length() == 1 ? fArray.elementAt(0) : fArray;
        }
        return object;
    }

    protected int[] fn_source_filter(Node node, int[] nArray, SingleRowNameSpace singleRowNameSpace, Calculator calculator) {
        if (node != null) {
            IntList intList = new IntList();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                singleRowNameSpace.setRowIndex(n);
                try {
                    if (!Boolean.TRUE.equals(calculator.evalValue(node))) continue;
                    intList.add(n);
                    continue;
                }
                catch (UtilEvalError utilEvalError) {
                    String string = "error happens at calculate formula\nformula expression is " + node + "\nerror message is " + utilEvalError.getMessage();
                    FRLogger.getLogger().error(string, utilEvalError);
                }
            }
            nArray = intList.toArray();
        }
        return nArray;
    }

    protected Object[] fn_cc_ex_result(Node node, int[] nArray, DataModel dataModel, SingleRowNameSpace singleRowNameSpace, Calculator calculator) {
        Object[] objectArray = new Object[nArray.length];
        String string = node.toString();
        int n = Integer.MIN_VALUE;
        n = this.col_name_2_col_index(dataModel, string);
        if (n >= -1) {
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[i] = DataCoreUtils.getTableDataValue(dataModel, nArray[i], n);
            }
            return objectArray;
        }
        try {
            string = calculator.evalValue(node).toString();
            n = this.col_name_2_col_index(dataModel, string);
            if (n >= -1) {
                for (int i = 0; i < nArray.length; ++i) {
                    objectArray[i] = DataCoreUtils.getTableDataValue(dataModel, nArray[i], n);
                }
                return objectArray;
            }
        }
        catch (UtilEvalError utilEvalError) {
        }
        catch (InterpreterError interpreterError) {
            // empty catch block
        }
        this.dealWithLeft(node, nArray, singleRowNameSpace, calculator, objectArray);
        return objectArray;
    }

    private void dealWithLeft(Node node, int[] nArray, SingleRowNameSpace singleRowNameSpace, Calculator calculator, Object[] objectArray) {
        GroupResultSequenceNameSpace groupResultSequenceNameSpace = new GroupResultSequenceNameSpace();
        calculator.pushNameSpace(groupResultSequenceNameSpace);
        for (int i = 0; i < nArray.length; ++i) {
            String string;
            int n = nArray[i];
            singleRowNameSpace.setRowIndex(n);
            try {
                objectArray[i] = calculator.evalValue(node);
                continue;
            }
            catch (UtilEvalError utilEvalError) {
                string = "error happens at calculate formula\nformula expression: \"" + node + "\"\nerror message: " + utilEvalError.getMessage();
                FRLogger.getLogger().error(string, utilEvalError);
                continue;
            }
            catch (InterpreterError interpreterError) {
                string = "\"" + node + "\" can not be resolved as a column\nformula expression: \"" + node + "\"\nerror message: " + interpreterError.getMessage();
                FRLogger.getLogger().error(string, interpreterError);
                String string2 = node.toString();
                Arrays.fill(objectArray, string2);
                break;
            }
        }
        calculator.removeNameSpace(groupResultSequenceNameSpace);
    }

    private static boolean isAllNum(String string) {
        if (StringUtils.isEmpty(string) || string.length() < 2) {
            return false;
        }
        if (string.charAt(0) != '#') {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (StableUtils.isNum(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected int col_name_2_col_index(DataModel dataModel, String string) {
        int n = Integer.MIN_VALUE;
        if (!DataSetFunction.isAllNum(string)) {
            try {
                n = dataModel.getColumnIndex(string);
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
            }
        } else {
            int n2 = Integer.parseInt(string.substring(1));
            try {
                if (n2 <= dataModel.getColumnCount() && n2 >= 0) {
                    n = n2 - 1;
                }
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
            }
        }
        return n;
    }

    public abstract Object resolveFunction(String var1, Node[] var2, char var3);

    public abstract Object resolveXFunction(String var1, Node[] var2, char var3);

    public abstract Object resolveColumnCount(String var1, Node[] var2);

    public abstract Object resolveColumnName(String var1, Node[] var2);

    public abstract Object resolveColumn(String var1, Node[] var2);

    public abstract Object resolveValue(String var1, Node[] var2);
}

