/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.dao;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Delete;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Update;
import com.fr.data.core.db.dml.Where;
import com.fr.data.dao.ClassArrayKey;
import com.fr.data.dao.CompatiableIDFCMapper;
import com.fr.data.dao.DAOBean;
import com.fr.data.dao.DAOException;
import com.fr.data.dao.DAOUtils;
import com.fr.data.dao.DaoMapperUtils;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.DatabaseAction;
import com.fr.data.dao.DirectRelationFCMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ForeignKeyFCMapper;
import com.fr.data.dao.JDBCDataAccessObjectOperator;
import com.fr.data.dao.JDBCDataAccessObjectTemplate;
import com.fr.data.dao.MapFVG;
import com.fr.data.dao.ObjectFVG;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.RelationFCMapper;
import com.fr.data.dao.RelationObject;
import com.fr.data.dao.ResultSetExtractor;
import com.fr.data.dao.SortInfo;
import com.fr.data.dao.UniqueViolationException;
import com.fr.data.dao.page.Page;
import com.fr.data.dao.page.PageConfiguration;
import com.fr.general.FRLogger;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCDAOSession
implements DataAccessObjectSession {
    private Connection conn = null;
    private JDBCDataAccessObjectOperator manager;
    private JDBCDataAccessObjectTemplate JDBCDataAccessObjectTemplate = null;
    private Dialect dialect = null;
    private DatabaseAction action;
    private boolean transaction = true;

    public JDBCDAOSession(JDBCDataAccessObjectOperator jDBCDataAccessObjectOperator) {
        this(jDBCDataAccessObjectOperator, DatabaseAction.NORMAL);
    }

    public JDBCDAOSession(JDBCDataAccessObjectOperator jDBCDataAccessObjectOperator, DatabaseAction databaseAction) {
        this.manager = jDBCDataAccessObjectOperator;
        this.action = databaseAction;
    }

    @Override
    public void beginTransaction() throws Exception {
        if (this.conn != null) {
            throw new DAOException("Session already started!");
        }
        this.conn = this.manager.createConnection();
        this.conn.setAutoCommit(false);
    }

    @Override
    public void commit() throws Exception {
        if (this.conn == null) {
            throw new DAOException("No transaction started!");
        }
        this.conn.commit();
    }

    @Override
    public void rollback() throws Exception {
        if (this.conn == null) {
            throw new DAOException("No transaction started!");
        }
        this.conn.rollback();
    }

    @Override
    public void closeTransaction() {
        DBUtils.closeConnection(this.conn);
        this.conn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        JDBCDAOSession jDBCDAOSession = this;
        synchronized (jDBCDAOSession) {
            super.finalize();
            DBUtils.closeConnection(this.conn);
            this.conn = null;
        }
    }

    protected Dialect getDialect() {
        if (this.dialect == null) {
            Connection connection = null;
            try {
                connection = this.manager.createConnection();
                Dialect dialect = this.dialect = DialectFactory.generateDialect(connection);
                return dialect;
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
            finally {
                if (connection != null) {
                    DBUtils.closeConnection(connection);
                }
            }
            return DialectFactory.getDefaultDialect();
        }
        return this.dialect;
    }

    private JDBCDataAccessObjectTemplate getJDBCTemplate() throws Exception {
        if (this.JDBCDataAccessObjectTemplate == null) {
            this.JDBCDataAccessObjectTemplate = new JDBCDataAccessObjectTemplate();
        }
        if (this.conn != null) {
            this.JDBCDataAccessObjectTemplate.setConn(this.conn);
            this.JDBCDataAccessObjectTemplate.setTransaction(true);
        } else {
            this.JDBCDataAccessObjectTemplate.setConn(this.manager.createConnection());
            this.JDBCDataAccessObjectTemplate.setTransaction(false);
        }
        if (!this.transaction) {
            this.JDBCDataAccessObjectTemplate.setTransaction(false);
        }
        this.JDBCDataAccessObjectTemplate.setDialect(this.getDialect());
        return this.JDBCDataAccessObjectTemplate;
    }

    @Override
    public void insert(Object object) throws DAOException {
        Class<?> clazz = object.getClass();
        this.manager.assertIsInMapping(clazz);
        try {
            boolean bl = this.manager.isOracleDatabaseConnection();
            Insert insert = DaoMapperUtils.createInsert(this.manager.getObjectMapper(clazz), new ObjectFVG(object), bl, this);
            this.getJDBCTemplate().execute(insert, true);
        }
        catch (SQLException sQLException) {
            Dialect dialect = this.getDialect();
            if (dialect.supportsUniqueViolationExceptionCheck() && !dialect.isUniqueViolationException(sQLException)) {
                throw new DAOException(sQLException);
            }
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    @Override
    public long save(Object object) throws DAOException {
        long l = this.saveData(object);
        if (l == 0L || this.manager.isTransferState()) {
            return l;
        }
        try {
            StableUtils.setPrivateFieldValue(object, "id", l);
            return l;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    @Override
    public long transfer(Object object) throws DAOException {
        return this.saveData(object);
    }

    private long saveData(Object object) {
        Class<?> clazz = object.getClass();
        this.manager.assertIsInMapping(clazz);
        Connection connection = null;
        try {
            connection = this.manager.createConnection();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        Serializable serializable = null;
        try {
            boolean bl = this.manager.isOracleDatabaseConnection();
            Insert insert = DaoMapperUtils.createInsert(this.manager.getObjectMapper(clazz), new ObjectFVG(object), bl, this);
            serializable = this.getJDBCTemplate().execute(insert, true);
        }
        catch (SQLException sQLException) {
            Dialect dialect = this.getDialect();
            if (dialect.supportsUniqueViolationExceptionCheck()) {
                if (dialect.isUniqueViolationException(sQLException)) {
                    long l = 0L;
                    return l;
                }
                throw new DAOException(sQLException);
            }
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        finally {
            DBUtils.closeConnection(connection);
        }
        if (serializable == null) {
            throw new DAOException("Unknown Error, can not get the identifier!");
        }
        return ((Number)serializable).longValue();
    }

    @Override
    public boolean saveOrUpdate(Object object) throws DAOException {
        long l = -1L;
        Class<?> clazz = object.getClass();
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper != null) {
            try {
                l = ((Number)StableUtils.getPrivateFieldValue(object, fieldColumnMapper.getFieldName())).longValue();
            }
            catch (Exception exception) {
                throw new DAOException(exception);
            }
        }
        if (l < 0L) {
            return this.save(object) >= 0L;
        }
        List<?> list = this.listByFieldValue(clazz, "id", l);
        if (!this.isCompatiableOldWay() && (list == null || list.isEmpty())) {
            return this.save(object) >= 0L;
        }
        return this.update(object);
    }

    private boolean isCompatiableOldWay() {
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        return extraClassManagerProvider != null && extraClassManagerProvider.getSingle("JDBCSaveUpdateProcessor") != null;
    }

    @Override
    public boolean update(Object object) throws DAOException {
        Class<?> clazz = object.getClass();
        this.manager.assertIsInMapping(clazz);
        try {
            Update update = DaoMapperUtils.createUpdate(object, this.manager.getObjectMapper(clazz), this);
            return this.getJDBCTemplate().executeUpdate(update) > 0;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    @Override
    public boolean updateRelation(Class clazz, RelationFCMapper relationFCMapper, long l, Map<Class, Object> map) throws DAOException {
        if (l < 0L || map == null || map.size() <= 0) {
            return false;
        }
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(clazz, relationFCMapper.getIndirectRelatedClass());
        this.manager.assertIsInMapping(classArrayKey);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(classArrayKey);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No Primary Key in " + classArrayKey.toString() + "'s Mapping info.");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map.size());
        for (Map.Entry<Class, Object> entry : map.entrySet()) {
            hashMap.put(DAOUtils.getClassNameWithOutPath(entry.getKey()), entry.getValue());
        }
        try {
            Update update = DaoMapperUtils.createUpdate(objectTableMapper, hashMap, fieldColumnMapper, l, this);
            return this.getJDBCTemplate().executeUpdate(update) > 0;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    @Override
    public boolean update(Class clazz, long l, Map<String, Object> map) throws DAOException {
        if (map == null || map.size() <= 0) {
            return false;
        }
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No Primary Key in " + clazz.getName() + "'s Mapping info.");
        }
        try {
            Update update = DaoMapperUtils.createUpdate(objectTableMapper, map, fieldColumnMapper, l, this);
            return this.getJDBCTemplate().executeUpdate(update) > 0;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    @Override
    public boolean update(Class clazz, Map<String, Object> map) throws DAOException {
        if (map == null || map.size() <= 0) {
            return false;
        }
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        try {
            Update update = DaoMapperUtils.createUpdate(objectTableMapper, map, null, null, this);
            return this.getJDBCTemplate().executeUpdate(update) > 0;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    @Override
    public Object load(final Class clazz, long l) throws DAOException {
        Object t;
        this.manager.assertIsInMapping(clazz);
        final ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No Primary Key in " + clazz.getName() + "'s Mapping info.");
        }
        try {
            Select select = DaoMapperUtils.createLoadSelect(fieldColumnMapper, l, objectTableMapper, this);
            t = this.getJDBCTemplate().executeQuery(select, new ResultSetExtractor(){

                public Object extractData(ResultSet resultSet) throws Exception {
                    if (resultSet.next()) {
                        return DaoMapperUtils.extractResultSet(resultSet, clazz, objectTableMapper, JDBCDAOSession.this);
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return t;
    }

    private <T> List<T> __list_by_sql__(final Class<? extends T> clazz, Select select) throws DAOException {
        List list;
        this.manager.assertIsInMapping(clazz);
        final ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        try {
            list = (List)this.getJDBCTemplate().executeQuery(select, new ResultSetExtractor<List<T>>(){

                @Override
                public List<T> extractData(ResultSet resultSet) throws Exception {
                    ArrayList arrayList = new ArrayList();
                    while (resultSet.next()) {
                        arrayList.add(DaoMapperUtils.extractResultSet(resultSet, clazz, objectTableMapper, JDBCDAOSession.this));
                    }
                    return arrayList;
                }
            });
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return list;
    }

    @Override
    public <T> List<T> listByFieldsAndSort(Class<T> clazz, String[] stringArray, Object[] objectArray, int[] nArray, String string, boolean bl) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        SortInfo sortInfo = new SortInfo();
        if (string != null) {
            sortInfo.addSortInfo(string, bl);
        }
        if (this.isNullGroup(stringArray, objectArray, nArray)) {
            return this.list(clazz, sortInfo);
        }
        if (!this.isValidGroup(stringArray, objectArray, nArray)) {
            return new ArrayList();
        }
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        Select select = DaoMapperUtils.createAllSelect(objectTableMapper, sortInfo);
        Where where = new Where();
        for (int i = 0; i < stringArray.length; ++i) {
            FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByFieldName(stringArray[i]);
            where.addColumn(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), nArray[i], objectArray[i]);
        }
        select.setWhere(where);
        return this.__list_by_sql__(clazz, select);
    }

    private boolean isNullGroup(String[] stringArray, Object[] objectArray, int[] nArray) {
        return stringArray == null || objectArray == null || nArray == null;
    }

    private boolean isValidGroup(String[] stringArray, Object[] objectArray, int[] nArray) {
        return stringArray.length == objectArray.length && stringArray.length == nArray.length;
    }

    @Override
    public List<Object> listFieldValue(Class clazz, String string) throws Exception {
        int n;
        this.manager.assertIsInMapping(clazz);
        if (string == null) {
            return new ArrayList<Object>();
        }
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        final FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        int n2 = -1;
        for (n = 0; n < fieldColumnMapperArray.length; ++n) {
            if (!string.equalsIgnoreCase(fieldColumnMapperArray[n].getColumnName())) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            return new ArrayList<Object>();
        }
        n = n2;
        String string2 = "SELECT " + string + " FROM " + this.getDialect().table2SQL(objectTableMapper.getTable());
        return this.getJDBCTemplate().query(string2, new ResultSetExtractor<List<Object>>(){

            @Override
            public List<Object> extractData(ResultSet resultSet) throws Exception {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (resultSet.next()) {
                    Object object = fieldColumnMapperArray[n].getType() == 12 ? resultSet.getString(fieldColumnMapperArray[n].getColumnName()) : resultSet.getObject(fieldColumnMapperArray[n].getColumnName());
                    if ((object = fieldColumnMapperArray[n].value2Field(object, JDBCDAOSession.this.manager.startSession())) != null) {
                        object = JDBCDAOSession.this.convertDBValueToFieldValue(object, fieldColumnMapperArray[n].getType());
                    }
                    arrayList.add(object);
                }
                return arrayList;
            }
        });
    }

    @Override
    public <T> List<T> listByFieldValue(Class<T> clazz, String string, Object object) throws DAOException {
        return this.listByFieldValue(clazz, string, object, 0);
    }

    @Override
    public <T> List<T> listByFieldValue(Class<T> clazz, String string, Object object, int n) throws DAOException {
        Select select;
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        try {
            select = DaoMapperUtils.createSelectByField(string, object, n, objectTableMapper, this, false);
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return this.__list_by_sql__(clazz, select);
    }

    @Override
    public <T> List<T> listByFieldValues(Class<T> clazz, Map<String, Object> map) throws DAOException {
        Select select;
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        try {
            select = DaoMapperUtils.createSelectAllByMoreInfo(objectTableMapper, map, this);
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return this.__list_by_sql__(clazz, select);
    }

    @Override
    public List<Object> listByFieldValues4MVFilter(final Class clazz, Map<String, Object> map) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        final ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        try {
            String string = DaoMapperUtils.createSelectSQLByListFiledValue(map, objectTableMapper, this.getDialect(), this);
            if (string == null) {
                return new ArrayList<Object>(2);
            }
            return this.getJDBCTemplate().query(string, new ResultSetExtractor<List<Object>>(){

                @Override
                public List<Object> extractData(ResultSet resultSet) throws Exception {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    while (resultSet.next()) {
                        arrayList.add(DaoMapperUtils.extractResultSet(resultSet, clazz, objectTableMapper, JDBCDAOSession.this));
                    }
                    return arrayList;
                }
            });
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    @Override
    public <T> List<T> list(Class<? extends T> clazz) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        return this.__list_by_sql__(clazz, DaoMapperUtils.createAllSelect(objectTableMapper, null));
    }

    @Override
    public <T> Page<T> list(Class<? extends T> clazz, PageConfiguration pageConfiguration) {
        return this.list(clazz, null, pageConfiguration);
    }

    @Override
    public <T> Page<T> list(Class<? extends T> clazz, SortInfo sortInfo, PageConfiguration pageConfiguration) {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        List<? extends T> list = this.__list_by_sql__(clazz, DaoMapperUtils.createPageSelect(objectTableMapper, sortInfo, pageConfiguration));
        int n = this.count(clazz);
        return this.getPage(pageConfiguration, list, n);
    }

    public int count(Class<?> clazz) {
        int n;
        this.manager.assertIsInMapping(clazz);
        Select select = DaoMapperUtils.createCountAllSelect(this.manager.getObjectMapper(clazz));
        try {
            n = this.getJDBCTemplate().executeQuery(select, new ResultSetExtractor<Integer>(){

                @Override
                public Integer extractData(ResultSet resultSet) throws Exception {
                    int n = 0;
                    if (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                    return n;
                }
            });
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return n;
    }

    private <T> Page<T> getPage(PageConfiguration pageConfiguration, List<T> list, int n) {
        if (!this.isPaged(pageConfiguration, list)) {
            list = this.manualPaging(pageConfiguration, list);
        }
        return new Page<T>(pageConfiguration, list, n);
    }

    private <T> List<T> manualPaging(PageConfiguration pageConfiguration, List<T> list) {
        int n = pageConfiguration.getStart();
        int n2 = pageConfiguration.getEnd() > list.size() ? list.size() : pageConfiguration.getEnd();
        return list.subList(n, n2);
    }

    private <T> boolean isPaged(PageConfiguration pageConfiguration, List<T> list) {
        long l = list.size();
        return l <= (long)pageConfiguration.getPageSize();
    }

    @Override
    public <T> List<T> list(Class<T> clazz, SortInfo sortInfo) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        return this.__list_by_sql__(clazz, DaoMapperUtils.createAllSelect(objectTableMapper, sortInfo));
    }

    @Override
    public Set<Object> listSetByRelationField(Class clazz, Object object, RelationFCMapper relationFCMapper, boolean bl) throws DAOException {
        if (clazz == null || object == null || relationFCMapper == null) {
            throw new DAOException("Arguments is null!");
        }
        if (relationFCMapper.isDirectRelated()) {
            return this.listSetByDirectRelationField(clazz, object, (DirectRelationFCMapper)relationFCMapper);
        }
        return this.listSetByIndirectRelationField(clazz, object, relationFCMapper, bl);
    }

    private Set<Object> listSetByDirectRelationField(Class clazz, Object object, DirectRelationFCMapper directRelationFCMapper) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        final Class clazz2 = directRelationFCMapper.getRelatedClass();
        this.manager.assertIsInMapping(clazz2);
        final ObjectTableMapper objectTableMapper2 = this.manager.getObjectMapper(clazz2);
        Set<Object> set = new HashSet<Object>();
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            return set;
        }
        try {
            Select select = DaoMapperUtils.createSelectByColumn(directRelationFCMapper.getRelatedColumnName(), object, 0, objectTableMapper2, this, false);
            set = this.getJDBCTemplate().executeQuery(select, new ResultSetExtractor<Set<Object>>(){

                @Override
                public Set<Object> extractData(ResultSet resultSet) throws Exception {
                    HashSet<Object> hashSet = new HashSet<Object>();
                    while (resultSet.next()) {
                        hashSet.add(DaoMapperUtils.extractResultSet(resultSet, clazz2, objectTableMapper2, JDBCDAOSession.this));
                    }
                    return hashSet;
                }
            });
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return set;
    }

    private Set<Object> listSetByIndirectRelationField(Class clazz, Object object, RelationFCMapper relationFCMapper, boolean bl) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(clazz, relationFCMapper.getIndirectRelatedClass());
        this.manager.assertIsInMapping(classArrayKey);
        ObjectTableMapper objectTableMapper2 = this.manager.getObjectMapper(classArrayKey);
        int n = objectTableMapper2.getFieldColumnMapperCount() - 2;
        HashSet<Object> hashSet = new HashSet<Object>();
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            return hashSet;
        }
        try {
            Select select = DaoMapperUtils.createSelectByColumn(DAOUtils.getClassNameWithOutPath(clazz) + "id", object, 0, objectTableMapper2, this, true);
            List<Long[]> list = this.makeIdResult(select, n);
            if (bl) {
                this.listSetByIndirectRelationFieldToObj(clazz, list, hashSet, n, objectTableMapper2, relationFCMapper);
            } else {
                FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper2.getFieldColumnMappers();
                ArrayList<Class> arrayList = new ArrayList<Class>(n);
                for (int i = 0; i < fieldColumnMapperArray.length; ++i) {
                    if (fieldColumnMapperArray[i].isPrimaryKey() || fieldColumnMapperArray[i].getFieldName().startsWith(DAOUtils.getClassNameWithOutPath(clazz))) continue;
                    arrayList.add(((ForeignKeyFCMapper)fieldColumnMapperArray[i]).getRelatedClass());
                }
                ClassArrayKey classArrayKey2 = ClassArrayKey.getInstance(relationFCMapper.getIndirectRelatedClass());
                int n2 = list.size();
                for (int i = 0; i < n2; ++i) {
                    Long[] longArray = list.get(i);
                    DAOBean[] dAOBeanArray = new DAOBean[n];
                    for (int j = 0; j < n; ++j) {
                        Class clazz2 = (Class)arrayList.get(j);
                        dAOBeanArray[j] = (DAOBean)clazz2.newInstance();
                        dAOBeanArray[j].setId(longArray[j + 1]);
                    }
                    RelationObject relationObject = RelationObject.getInstance(longArray[0], classArrayKey2, dAOBeanArray, bl);
                    hashSet.add(relationObject);
                }
            }
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return hashSet;
    }

    private List<Long[]> makeIdResult(Select select, final int n) throws Exception {
        return this.getJDBCTemplate().executeQuery(select, new ResultSetExtractor<List<Long[]>>(){

            @Override
            public List<Long[]> extractData(ResultSet resultSet) throws Exception {
                ArrayList<Long[]> arrayList = new ArrayList<Long[]>();
                while (resultSet.next()) {
                    Long[] longArray = new Long[n + 1];
                    for (int i = 0; i < n + 1; ++i) {
                        longArray[i] = resultSet.getLong(i + 1);
                    }
                    arrayList.add(longArray);
                }
                return arrayList;
            }
        });
    }

    private void listSetByIndirectRelationFieldToObj(Class clazz, List<Long[]> list, Set set, int n, ObjectTableMapper objectTableMapper, RelationFCMapper relationFCMapper) throws Exception {
        int mapArray;
        Set[] setArray = new Set[n];
        for (int i = 0; i < n; ++i) {
            setArray[i] = new HashSet();
        }
        FieldColumnMapper[] fieldColumnMapperArray = list.iterator();
        while (fieldColumnMapperArray.hasNext()) {
            Long[] object2;
            Long[] longArray = object2 = fieldColumnMapperArray.next();
            for (mapArray = 0; mapArray < n; ++mapArray) {
                setArray[mapArray].add(longArray[mapArray + 1]);
            }
        }
        fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        ArrayList<Class> arrayList = new ArrayList<Class>(n);
        for (mapArray = 0; mapArray < fieldColumnMapperArray.length; ++mapArray) {
            if (fieldColumnMapperArray[mapArray].isPrimaryKey() || fieldColumnMapperArray[mapArray].getFieldName().startsWith(DAOUtils.getClassNameWithOutPath(clazz))) continue;
            arrayList.add(((ForeignKeyFCMapper)fieldColumnMapperArray[mapArray]).getRelatedClass());
        }
        Map[] mapArray2 = new HashMap[n];
        this.makeValueMaps(mapArray2, n, setArray, arrayList);
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(relationFCMapper.getIndirectRelatedClass());
        int n2 = list.size();
        block4: for (int i = 0; i < n2; ++i) {
            Long[] longArray = list.get(i);
            DAOBean[] dAOBeanArray = new DAOBean[n];
            for (int j = 0; j < n; ++j) {
                dAOBeanArray[j] = (DAOBean)mapArray2[j].get(longArray[j + 1]);
                if (dAOBeanArray[j] == null) continue block4;
            }
            RelationObject relationObject = RelationObject.getInstance(longArray[0], classArrayKey, dAOBeanArray, true);
            set.add(relationObject);
        }
    }

    private void makeValueMaps(Map[] mapArray, int n, Set[] setArray, List list) throws Exception {
        for (int i = 0; i < n; ++i) {
            Long[] longArray = setArray[i].toArray(new Long[setArray[i].size()]);
            final Class clazz = (Class)list.get(i);
            this.manager.assertIsInMapping(clazz);
            final ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
            hashMap.put(objectTableMapper.getPrimaryKey().getFieldName(), longArray);
            String string = DaoMapperUtils.createSelectSQLByListFiledValue(hashMap, objectTableMapper, this.getDialect(), this);
            mapArray[i] = string != null ? (HashMap)this.getJDBCTemplate().query(string, new ResultSetExtractor(){

                public Object extractData(ResultSet resultSet) throws Exception {
                    HashMap hashMap = new HashMap();
                    while (resultSet.next()) {
                        hashMap.put(new Long(resultSet.getLong(1)), DaoMapperUtils.extractResultSet(resultSet, clazz, objectTableMapper, JDBCDAOSession.this));
                    }
                    return hashMap;
                }
            }) : new HashMap(2);
        }
    }

    @Override
    public void addRelation(Object object, Class clazz, Object object2, RelationFCMapper relationFCMapper) throws DAOException {
        this.addOrRemoveRelation(object, clazz, object2, relationFCMapper, true);
    }

    public List<RelationObject> getRelationByMap(Class clazz, RelationFCMapper relationFCMapper, Map map) throws DAOException {
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(clazz, relationFCMapper.getIndirectRelatedClass());
        this.manager.assertIsInMapping(classArrayKey);
        final ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(classArrayKey);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No Primary Key in " + classArrayKey.toString() + "'s Mapping info.");
        }
        try {
            Select select = DaoMapperUtils.createSelectAllByMoreInfo(objectTableMapper, map, this);
            return this.getJDBCTemplate().executeQuery(select, new ResultSetExtractor<List<RelationObject>>(){

                @Override
                public List<RelationObject> extractData(ResultSet resultSet) throws Exception {
                    ArrayList<RelationObject> arrayList = new ArrayList<RelationObject>();
                    while (resultSet.next()) {
                        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
                        long l = -1L;
                        DAOBean[] dAOBeanArray = new DAOBean[fieldColumnMapperArray.length - 1];
                        int n = 0;
                        for (int i = 0; i < fieldColumnMapperArray.length; ++i) {
                            if (fieldColumnMapperArray[i].isPrimaryKey()) {
                                l = resultSet.getLong(fieldColumnMapperArray[i].getColumnName());
                                continue;
                            }
                            ForeignKeyFCMapper foreignKeyFCMapper = (ForeignKeyFCMapper)fieldColumnMapperArray[i];
                            DAOBean dAOBean = (DAOBean)foreignKeyFCMapper.getRelatedClass().newInstance();
                            dAOBean.setId(resultSet.getLong(fieldColumnMapperArray[i].getColumnName()));
                            dAOBeanArray[n] = dAOBean;
                            ++n;
                        }
                        RelationObject relationObject = RelationObject.getInstance(dAOBeanArray);
                        relationObject.setId(l);
                        arrayList.add(relationObject);
                    }
                    return arrayList;
                }
            });
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    @Override
    public RelationObject getRelation(Class clazz, RelationFCMapper relationFCMapper, long l) throws DAOException {
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(clazz, relationFCMapper.getIndirectRelatedClass());
        this.manager.assertIsInMapping(classArrayKey);
        final ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(classArrayKey);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No Primary Key in " + classArrayKey.toString() + "'s Mapping info.");
        }
        try {
            Select select = DaoMapperUtils.createLoadSelect(fieldColumnMapper, new Long(l), objectTableMapper, this);
            RelationObject relationObject = (RelationObject)this.getJDBCTemplate().executeQuery(select, new ResultSetExtractor(){

                public Object extractData(ResultSet resultSet) throws Exception {
                    if (resultSet.next()) {
                        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
                        long l = -1L;
                        DAOBean[] dAOBeanArray = new DAOBean[fieldColumnMapperArray.length - 1];
                        int n = 0;
                        for (int i = 0; i < fieldColumnMapperArray.length; ++i) {
                            if (fieldColumnMapperArray[i].isPrimaryKey()) {
                                l = resultSet.getLong(fieldColumnMapperArray[i].getColumnName());
                                continue;
                            }
                            ForeignKeyFCMapper foreignKeyFCMapper = (ForeignKeyFCMapper)fieldColumnMapperArray[i];
                            DAOBean dAOBean = (DAOBean)foreignKeyFCMapper.getRelatedClass().newInstance();
                            dAOBean.setId(resultSet.getLong(fieldColumnMapperArray[i].getColumnName()));
                            dAOBeanArray[n] = dAOBean;
                            ++n;
                        }
                        RelationObject relationObject = RelationObject.getInstance(dAOBeanArray);
                        relationObject.setId(l);
                        return relationObject;
                    }
                    return null;
                }
            });
            return relationObject;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    @Override
    public boolean hasRelation(Object object, Class clazz, Object object2, RelationFCMapper relationFCMapper) throws DAOException {
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(clazz, relationFCMapper.getIndirectRelatedClass());
        this.manager.assertIsInMapping(classArrayKey);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(classArrayKey);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No Primary Key in " + classArrayKey.toString() + "'s Mapping info.");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(DAOUtils.getClassNameWithOutPath(clazz), object2);
        Object[] objectArray = relationFCMapper.getIndirectRelatedClass();
        if (!ArrayUtils.isEmpty(objectArray)) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object3;
                this.manager.assertIsInMapping((Class)objectArray[i]);
                if (objectArray.length > 1) {
                    object3 = ((RelationObject)object).getValue((Class)objectArray[i]);
                    if (((RelationObject)object).isToObj()) {
                        object3 = new Long(((DAOBean)object3).getId());
                    }
                } else {
                    this.manager.assertIsInMapping((Class)objectArray[i]);
                    ObjectTableMapper objectTableMapper2 = this.manager.getObjectMapper((Class)objectArray[i]);
                    FieldColumnMapper fieldColumnMapper2 = objectTableMapper2.getPrimaryKey();
                    if (fieldColumnMapper2 == null) {
                        throw new DAOException("No Primary Key in " + ((Class)objectArray[i]).getName() + "'s Mapping info.");
                    }
                    try {
                        object3 = StableUtils.getPrivateFieldValue(object, fieldColumnMapper2.getFieldName());
                    }
                    catch (Exception exception) {
                        throw new DAOException(exception);
                    }
                }
                hashMap.put(DAOUtils.getClassNameWithOutPath((Class)objectArray[i]), object3);
            }
        }
        return this.getResult(objectTableMapper, hashMap);
    }

    private boolean getResult(ObjectTableMapper objectTableMapper, Map map) {
        try {
            Select select = DaoMapperUtils.createSelectAllByMoreInfo(objectTableMapper, map, this);
            boolean bl = (Boolean)this.getJDBCTemplate().executeQuery(select, new ResultSetExtractor(){

                public Boolean extractData(ResultSet resultSet) throws Exception {
                    if (resultSet.next()) {
                        return true;
                    }
                    return false;
                }
            });
            return bl;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    @Override
    public boolean removeRelation(Class clazz, RelationFCMapper relationFCMapper, long l) throws DAOException {
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(clazz, relationFCMapper.getIndirectRelatedClass());
        this.manager.assertIsInMapping(classArrayKey);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(classArrayKey);
        boolean bl = false;
        try {
            Delete delete = DaoMapperUtils.createDeleteByPrimaryKey(l, objectTableMapper);
            bl = this.getJDBCTemplate().executeDelete(delete) > 0;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return bl;
    }

    @Override
    public void removeRelation(Object object, Class clazz, Object object2, RelationFCMapper relationFCMapper) throws DAOException {
        this.addOrRemoveRelation(object, clazz, object2, relationFCMapper, false);
    }

    private void addOrRemoveRelation(Object object, Class clazz, Object object2, RelationFCMapper relationFCMapper, boolean bl) throws DAOException {
        if (clazz == null || object2 == null || relationFCMapper == null) {
            throw new DAOException("Arguments is null!");
        }
        if (relationFCMapper.isDirectRelated()) {
            this.addOrRemoveDirectRelation(object, clazz, object2, (DirectRelationFCMapper)relationFCMapper, bl);
        } else {
            this.addOrRemoveIndirectRelation(object, clazz, object2, relationFCMapper, bl);
        }
    }

    private void addOrRemoveDirectRelation(Object object, Class clazz, Object object2, DirectRelationFCMapper directRelationFCMapper, boolean bl) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        Class clazz2 = directRelationFCMapper.getRelatedClass();
        this.manager.assertIsInMapping(clazz2);
        ObjectTableMapper objectTableMapper2 = this.manager.getObjectMapper(clazz2);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No Primary Key in " + clazz.getName() + "'s Mapping info.");
        }
        try {
            FieldColumnMapper fieldColumnMapper2 = objectTableMapper2.findFCMapperByColumnName(directRelationFCMapper.getRelatedColumnName());
            if (fieldColumnMapper2 == null || !fieldColumnMapper2.isForeignKey()) {
                throw new DAOException("No foreign Key(" + directRelationFCMapper.getRelatedColumnName() + ")in " + clazz2.getName() + "'s Mapping info.");
            }
            if (bl) {
                StableUtils.setPrivateFieldValue(object, fieldColumnMapper2.getFieldName(), object2);
                this.saveOrUpdate(object);
            } else {
                ForeignKeyFCMapper foreignKeyFCMapper = (ForeignKeyFCMapper)fieldColumnMapper2;
                if (foreignKeyFCMapper.isDelCascade() && foreignKeyFCMapper.getCascadeType() == 0) {
                    this.delete(object);
                } else {
                    StableUtils.setPrivateFieldValue(object, fieldColumnMapper2.getFieldName(), new Long(-1L));
                    this.saveOrUpdate(object);
                }
            }
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    private void addOrRemoveIndirectRelation(Object object, Class clazz, Object object2, RelationFCMapper relationFCMapper, boolean bl) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(clazz, relationFCMapper.getIndirectRelatedClass());
        this.manager.assertIsInMapping(classArrayKey);
        ObjectTableMapper objectTableMapper2 = this.manager.getObjectMapper(classArrayKey);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No Primary Key in " + clazz.getName() + "'s Mapping info.");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(DAOUtils.getClassNameWithOutPath(clazz), object2);
        Object[] objectArray = relationFCMapper.getIndirectRelatedClass();
        if (!ArrayUtils.isEmpty(objectArray)) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object3;
                this.manager.assertIsInMapping((Class)objectArray[i]);
                if (objectArray.length > 1) {
                    object3 = ((RelationObject)object).getValue((Class)objectArray[i]);
                    if (((RelationObject)object).isToObj()) {
                        object3 = new Long(((DAOBean)object3).getId());
                    }
                } else {
                    this.manager.assertIsInMapping((Class)objectArray[i]);
                    ObjectTableMapper objectTableMapper3 = this.manager.getObjectMapper((Class)objectArray[i]);
                    FieldColumnMapper fieldColumnMapper2 = objectTableMapper3.getPrimaryKey();
                    if (fieldColumnMapper2 == null) {
                        throw new DAOException("No Primary Key in " + ((Class)objectArray[i]).getName() + "'s Mapping info.");
                    }
                    try {
                        object3 = StableUtils.getPrivateFieldValue(object, fieldColumnMapper2.getFieldName());
                    }
                    catch (Exception exception) {
                        throw new DAOException(exception);
                    }
                }
                hashMap.put(DAOUtils.getClassNameWithOutPath((Class)objectArray[i]), object3);
            }
        } else {
            throw new DAOException("Error Mapping info : Null Related Classes for " + clazz.getName());
        }
        this.doAddOrRemoveIndirectRelation(bl, objectTableMapper2, hashMap, object);
    }

    private void doAddOrRemoveIndirectRelation(boolean bl, ObjectTableMapper objectTableMapper, Map map, Object object) throws DAOException {
        boolean bl2 = this.manager.isOracleDatabaseConnection();
        if (bl) {
            try {
                Insert insert = DaoMapperUtils.createInsert(objectTableMapper, new MapFVG(map), bl2, this);
                Serializable serializable = this.getJDBCTemplate().execute(insert, true);
                if (serializable == null) {
                    throw new DAOException("Unknown Error, can not get the identifier!");
                }
                long l = ((Number)serializable).longValue();
                StableUtils.setPrivateFieldValue(object, objectTableMapper.getPrimaryKey().getFieldName(), new Long(l));
            }
            catch (SQLException sQLException) {
                if (this.dialect.supportsUniqueViolationExceptionCheck()) {
                    if (this.dialect.isUniqueViolationException(sQLException)) {
                        throw new UniqueViolationException(sQLException);
                    }
                    throw new DAOException(sQLException);
                }
                throw new DAOException(sQLException);
            }
            catch (Exception exception) {
                throw new DAOException(exception);
            }
        }
        try {
            Delete delete = DaoMapperUtils.createDeleteByInfo(objectTableMapper, map, this);
            this.getJDBCTemplate().execute(delete);
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    @Override
    public boolean deleteByPrimaryKey(Class clazz, long l) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        boolean bl = false;
        try {
            Delete delete = DaoMapperUtils.createDeleteByPrimaryKey(l, objectTableMapper);
            bl = this.getJDBCTemplate().executeDelete(delete) > 0;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return bl;
    }

    @Override
    public boolean deleteByFields(Class clazz, Map<String, Object> map) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        try {
            Delete delete = DaoMapperUtils.createDeleteByInfo(objectTableMapper, map, this);
            return this.getJDBCTemplate().executeDelete(delete) > 0;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    @Override
    public void delete(Class clazz) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        try {
            Delete delete = DaoMapperUtils.createAllDelete(objectTableMapper);
            this.getJDBCTemplate().execute(delete);
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    @Override
    public void delete(Object object) throws DAOException {
        Class<?> clazz = object.getClass();
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        long l = -1L;
        if (fieldColumnMapper != null) {
            try {
                l = ((Number)StableUtils.getPrivateFieldValue(object, fieldColumnMapper.getFieldName())).longValue();
            }
            catch (Exception exception) {
                throw new DAOException(exception);
            }
        } else {
            throw new DAOException("No Primary Key in " + clazz.getName() + "'s Mapping info.");
        }
        if (l < 0L) {
            throw new DAOException("The object is not a persistent Object. Can not find a right id.");
        }
        try {
            FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
            for (int i = 0; i < fieldColumnMapperArray.length; ++i) {
                if (!(fieldColumnMapperArray[i] instanceof CompatiableIDFCMapper)) continue;
                Object object2 = StableUtils.getPrivateFieldValue(object, fieldColumnMapperArray[i].getFieldName());
                ((CompatiableIDFCMapper)fieldColumnMapperArray[i]).delete(object2, this);
            }
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        this.deleteByPrimaryKey(clazz, l);
    }

    @Override
    public void deleteAllRelation(Class clazz, Object object, RelationFCMapper relationFCMapper) throws DAOException {
        if (clazz == null || object == null || relationFCMapper == null) {
            throw new DAOException("Arguments is null!");
        }
        if (relationFCMapper.isDirectRelated()) {
            this.deleteAllDirectRelation(clazz, object, (DirectRelationFCMapper)relationFCMapper);
        } else {
            this.deleteAllIndirectRelation(clazz, object, relationFCMapper);
        }
    }

    private void deleteAllDirectRelation(Class clazz, Object object, DirectRelationFCMapper directRelationFCMapper) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        Class clazz2 = directRelationFCMapper.getRelatedClass();
        this.manager.assertIsInMapping(clazz2);
        ObjectTableMapper objectTableMapper2 = this.manager.getObjectMapper(clazz2);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No PrimaryKey in " + clazz.getName() + "'s mapping table.");
        }
        try {
            Delete delete = DaoMapperUtils.createDeleteByColumn(directRelationFCMapper.getRelatedColumnName(), object, objectTableMapper2, this);
            this.getJDBCTemplate().execute(delete);
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    private void deleteAllIndirectRelation(Class clazz, Object object, RelationFCMapper relationFCMapper) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(clazz, relationFCMapper.getIndirectRelatedClass());
        this.manager.assertIsInMapping(classArrayKey);
        ObjectTableMapper objectTableMapper2 = this.manager.getObjectMapper(classArrayKey);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No PrimaryKey in " + clazz.getName() + "'s mapping table.");
        }
        try {
            Delete delete = DaoMapperUtils.createDeleteByField(DAOUtils.getClassNameWithOutPath(clazz), object, objectTableMapper2, this);
            this.getJDBCTemplate().execute(delete);
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    @Override
    public Long getPrimaryKeyValue(Object object) throws DAOException {
        Class<?> clazz = object.getClass();
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper != null) {
            try {
                return (Long)StableUtils.getPrivateFieldValue(object, fieldColumnMapper.getFieldName());
            }
            catch (Exception exception) {
                throw new DAOException(exception);
            }
        }
        return null;
    }

    @Override
    public Object convertDBValueToFieldValue(Object object, int n) {
        Dialect dialect = this.getDialect();
        return dialect.parseValue(object, n);
    }

    @Override
    public JDBCDataAccessObjectOperator getManager() {
        return this.manager;
    }

    @Override
    public void setForeignKeyChecks(int n) {
        try {
            this.getJDBCTemplate().setForeignKeyChecks(n);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
    }

    @Override
    public boolean updateByFields(Object object, Map<String, Object> map) {
        Class<?> clazz = object.getClass();
        this.manager.assertIsInMapping(clazz);
        try {
            Update update = DaoMapperUtils.createUpdateByInfo(object, this.manager.getObjectMapper(clazz), this, map);
            return this.getJDBCTemplate().executeUpdate(update) > 0;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    @Override
    public boolean saveOrUpdateByFields(Object object, Map<String, Object> map) {
        Class<?> clazz = object.getClass();
        this.manager.assertIsInMapping(clazz);
        List<Object> list = this.listByFieldValues4MVFilter(object.getClass(), map);
        if (list.isEmpty()) {
            return this.save(object) >= 0L;
        }
        try {
            Update update = DaoMapperUtils.createUpdateByInfo(object, this.manager.getObjectMapper(clazz), this, map);
            return this.getJDBCTemplate().executeUpdate(update) > 0;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }
}

