/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.data.core.db.dialect.TypeUtils;
import java.sql.Connection;
import java.sql.SQLException;

public class HSQLDialect
extends AbstractDialect {
    private String defaultAutoIncrease = "GENERATED BY DEFAULT AS IDENTITY (start with 1)";

    public String columnType2SQL(int n, String string) {
        switch (n) {
            case 2004: {
                return "BINARY";
            }
            case 12: {
                return string.equals("1") ? "BOOLEAN" : "VARCHAR(" + string + ")";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case -7: {
                return "BOOLEAN";
            }
        }
        return TypeUtils.getTypeName(n);
    }

    public String createSequence(Connection connection, String string, String string2, String string3) {
        return new StringBuffer().append(string3).append(' ').append(this.defaultAutoIncrease).toString();
    }

    public String getIdentitySelectString() {
        return "call identity()";
    }

    public String getLimitString(String string, int n, int n2) {
        return new StringBuffer(string.length() + 20).append(string).insert(string.toLowerCase().indexOf("select") + 6, " limit " + n + " " + n2).toString();
    }

    public String quartzDelegateClass() {
        return "com.fr.third.org.quartz.impl.jdbcjobstore.HSQLDBDelegate";
    }

    public boolean supportsUniqueViolationExceptionCheck() {
        return true;
    }

    public boolean isUniqueViolationException(SQLException sQLException) {
        return sQLException != null && sQLException.getMessage() != null && sQLException.getMessage().indexOf("Violation of unique constraint") > -1;
    }
}

