/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db;

import com.fr.data.core.db.ColumnInformation;
import com.fr.data.core.db.DBConstants;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.core.db.dialect.AccessDialect;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.exception.ColumnMismatchException;
import com.fr.data.core.db.handler.SQLTypeHandler;
import com.fr.data.impl.AbstractDatabaseConnection;
import com.fr.data.impl.Connection;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.data.impl.JNDIDatabaseConnection;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.data.pool.DBCPConnectionPoolAttr;
import com.fr.file.DatasourceManager;
import com.fr.file.DatasourceManagerProvider;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.EnvProvider;
import com.fr.general.FRLogLevel;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.GeneralUtils;
import com.fr.general.IOUtils;
import com.fr.general.Inter;
import com.fr.json.JSONObject;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.write.WriteSubmitException;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUtils {
    public static final String COLOMN_TYPE_PREFIX = "FR-Engine-Write_Column_Type_Mismatch";
    private static final int DEFAULT_CACHE_LOG_SIZE = 200;
    private static final int ACCESS_OLE = -4;

    private DBUtils() {
    }

    public static void applyColumnTypeValue(Dialect dialect, java.sql.Connection connection, Table table, String string, Object object, PreparedStatement preparedStatement, int n, int n2, Object object2) throws SQLException {
        if (FRLogger.getLogger().isLoggable(FRLogLevel.DEBUG)) {
            FRLogger.getLogger().info("columnIndex:" + n + "[" + n2 + "]<--->columnValue:" + GeneralUtils.objectToString(object2) + "[" + (object2 == null ? "NULL" : object2.getClass().getName()) + "]");
        }
        if (DBUtils.isNULL(object2, dialect)) {
            if (DBUtils.isProcessSpecialNull(preparedStatement, n2, n)) {
                return;
            }
            preparedStatement.setNull(n, n2);
            return;
        }
        if (dialect.isYearData(connection, n2, table, string)) {
            object2 = DateUtils.date2Year(object2);
        }
        SQLTypeHandler sQLTypeHandler = dialect.buildSQLTypeHandlerFactory().getTypeHandler(new Integer(n2));
        try {
            sQLTypeHandler.setValue(preparedStatement, n, object2, n2);
        }
        catch (ColumnMismatchException columnMismatchException) {
            throw new ColumnMismatchException(COLOMN_TYPE_PREFIX + object.toString());
        }
    }

    private static boolean isProcessSpecialNull(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        if (n == -4 && DialectFactory.generateDialect(preparedStatement.getConnection()) instanceof AccessDialect) {
            preparedStatement.setString(n2, "");
            return true;
        }
        return false;
    }

    public static boolean isNULL(Object object, Dialect dialect) {
        return dialect.isNULL(object) || ComparatorUtils.equals(Primitive.NULL, object);
    }

    public static int getColumnFRType(int n) {
        int n2;
        for (n2 = 0; n2 < DBConstants.STRING_ARRAY.length; ++n2) {
            if (DBConstants.STRING_ARRAY[n2] != n) continue;
            return DBConstants.FR_STRING;
        }
        for (n2 = 0; n2 < DBConstants.NUMBER_ARRAY.length; ++n2) {
            if (DBConstants.NUMBER_ARRAY[n2] != n) continue;
            return DBConstants.FR_NUMBER;
        }
        for (n2 = 0; n2 < DBConstants.NULL_ARRAY.length; ++n2) {
            if (DBConstants.NULL_ARRAY[n2] != n) continue;
            return DBConstants.FR_NULL;
        }
        for (n2 = 0; n2 < DBConstants.STREAM_ARRAY.length; ++n2) {
            if (DBConstants.STREAM_ARRAY[n2] != n) continue;
            return DBConstants.FR_STREAM;
        }
        for (n2 = 0; n2 < DBConstants.BOOLEAN_ARRAY.length; ++n2) {
            if (DBConstants.BOOLEAN_ARRAY[n2] != n) continue;
            return DBConstants.FR_BOOLEAN;
        }
        return DBConstants.FR_NULL;
    }

    public static void closeConnection(java.sql.Connection connection) {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
                connection = null;
            }
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
        }
    }

    public static void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
                statement = null;
            }
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
        }
    }

    public static void rollback(java.sql.Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (!connection.getAutoCommit()) {
                connection.rollback();
                FRLogger.getLogger().info("Rollback Successfully");
            } else {
                FRLogger.getLogger().info("Failed to rollback because of the connection is autoCommit");
            }
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(Inter.getLocText("FR-Engine_Data_Rollback_Failed"), sQLException);
        }
    }

    public static String[] checkInColumnNames(java.sql.Connection connection, Dialect dialect, String string) {
        try {
            ColumnInformation[] columnInformationArray = DBUtils.checkInColumnInformation(connection, dialect, string);
            String[] stringArray = new String[columnInformationArray.length];
            for (int i = 0; i < columnInformationArray.length; ++i) {
                stringArray[i] = columnInformationArray[i].getColumnName();
            }
            return stringArray;
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            return new String[0];
        }
    }

    public static JSONObject checkInColumnTypeMap(java.sql.Connection connection, Dialect dialect, String string) {
        try {
            ColumnInformation[] columnInformationArray = DBUtils.checkInColumnInformation(connection, dialect, string);
            JSONObject jSONObject = new JSONObject();
            for (int i = 0; i < columnInformationArray.length; ++i) {
                jSONObject.put(columnInformationArray[i].getColumnName(), columnInformationArray[i].getColumnType());
            }
            return jSONObject;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return new JSONObject();
        }
    }

    public static NameDatabaseConnection checkDBConnection(String string) {
        DatasourceManagerProvider datasourceManagerProvider = DatasourceManager.getProviderInstance();
        Iterator iterator = datasourceManagerProvider.getConnectionNameIterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Connection connection = datasourceManagerProvider.getConnection(string2);
            if (connection == null || !ComparatorUtils.equals(string, string2)) continue;
            try {
                return new NameDatabaseConnection(string2);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        return null;
    }

    public static ColumnInformation[] checkInColumnInformation(java.sql.Connection connection, Dialect dialect, String string) throws SQLException {
        Object[] objectArray;
        if (connection == null) {
            throw new SQLException("Cannot connect to database!");
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            if (DBUtils.isProcedure(string)) {
                objectArray = dialect.remoteProcedureCall(connection, string);
                statement = (Statement)objectArray[0];
                resultSet = (ResultSet)objectArray[1];
            } else {
                statement = connection.createStatement();
                try {
                    resultSet = statement.executeQuery(dialect.createSQL4Columns(string));
                }
                catch (Exception exception) {
                    statement.close();
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string);
                }
            }
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            throw sQLException;
        }
        objectArray = DBUtils.checkInColumnInformationByMetaData(resultSet.getMetaData());
        resultSet.close();
        statement.close();
        return objectArray;
    }

    public static ColumnInformation[] checkInColumnInformationByMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        return DBUtils.checkInColumnInformationByMetaData(resultSetMetaData, "", "");
    }

    public static ColumnInformation[] checkInColumnInformationByMetaData(ResultSetMetaData resultSetMetaData, String string, String string2) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        ColumnInformation[] columnInformationArray = new ColumnInformation[n];
        for (int i = 0; i < n; ++i) {
            String string3 = resultSetMetaData.getColumnLabel(i + 1);
            string3 = DBUtils.changeCharset(string3, string, string2);
            columnInformationArray[i] = new ColumnInformation(string3, resultSetMetaData.getColumnType(i + 1), resultSetMetaData.getColumnTypeName(i + 1), resultSetMetaData.getPrecision(i + 1), resultSetMetaData.getScale(i + 1));
        }
        return columnInformationArray;
    }

    public static String changeCharset(String string, String string2, String string3) {
        if (StringUtils.isNotEmpty(string2) && StringUtils.isNotEmpty(string3)) {
            try {
                if (string3 != null && string3.length() > 0) {
                    return new String(string.getBytes(string2), string3);
                }
                return new String(string.getBytes(string2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
        return string;
    }

    public static boolean isProcedure(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.replaceAll(" ", "").toUpperCase();
        return string2.startsWith("{CALL") || string2.startsWith("{?=CALL");
    }

    public static boolean isExsitedTable(Connection connection, String string) {
        try {
            for (TableProcedure tableProcedure : (TableProcedure[])GeneralContext.getEnvProvider().getTableProcedure(connection, "TABLE", null)) {
                if (!string.equalsIgnoreCase(tableProcedure.getName())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().info(exception.getMessage());
        }
        return false;
    }

    public static void refreshDatabase() {
        DatasourceManagerProvider datasourceManagerProvider = DatasourceManager.getProviderInstance();
        Iterator iterator = datasourceManagerProvider.getConnectionNameIterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            String string3;
            Object object;
            AbstractDatabaseConnection abstractDatabaseConnection;
            String string4 = (String)iterator.next();
            Connection connection = datasourceManagerProvider.getConnection(string4);
            if (connection instanceof JDBCDatabaseConnection) {
                abstractDatabaseConnection = new JDBCDatabaseConnection();
                object = ((JDBCDatabaseConnection)connection).getDriver();
                string3 = ((JDBCDatabaseConnection)connection).getURL();
                string2 = ((JDBCDatabaseConnection)connection).getUser();
                string = ((JDBCDatabaseConnection)connection).getPassword();
                ((JDBCDatabaseConnection)abstractDatabaseConnection).setDriver((String)object);
                ((JDBCDatabaseConnection)abstractDatabaseConnection).setURL(string3);
                ((JDBCDatabaseConnection)abstractDatabaseConnection).setUser(string2);
                ((JDBCDatabaseConnection)abstractDatabaseConnection).setPassword(string);
                datasourceManagerProvider.putConnection(string4, abstractDatabaseConnection);
                continue;
            }
            if (!(connection instanceof JNDIDatabaseConnection)) continue;
            abstractDatabaseConnection = new JNDIDatabaseConnection();
            object = ((JNDIDatabaseConnection)connection).getContextHashtable();
            string3 = ((JNDIDatabaseConnection)connection).getJNDIName();
            string2 = ((JNDIDatabaseConnection)connection).getNewCharsetName();
            string = ((JNDIDatabaseConnection)connection).getOriginalCharsetName();
            ((JNDIDatabaseConnection)abstractDatabaseConnection).setContextHashtable((Hashtable)object);
            ((JNDIDatabaseConnection)abstractDatabaseConnection).setJNDIName(string3);
            abstractDatabaseConnection.setNewCharsetName(string2);
            abstractDatabaseConnection.setOriginalCharsetName(string);
            datasourceManagerProvider.putConnection(string4, abstractDatabaseConnection);
        }
    }

    public static JDBCDatabaseConnection getEmbeddedDB(String string, int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("hsqldb.cache_size_scale", new Integer(8));
        hashMap.put("hsqldb.cache_scale", new Integer(8));
        hashMap.put("hsqldb.cache_file_scale", new Integer(8));
        hashMap.put("hsqldb.default_table_type", "cached");
        hashMap.put("hsqldb.applog", new Integer(0));
        DBCPConnectionPoolAttr dBCPConnectionPoolAttr = new DBCPConnectionPoolAttr();
        dBCPConnectionPoolAttr.setInitialSize(10);
        dBCPConnectionPoolAttr.setMaxActive(100);
        dBCPConnectionPoolAttr.setMaxIdle(30);
        dBCPConnectionPoolAttr.setMinIdle(10);
        dBCPConnectionPoolAttr.setMaxWait(5000);
        return DBUtils.getEmbeddedDB(string, hashMap, n, dBCPConnectionPoolAttr);
    }

    public static JDBCDatabaseConnection getEmbeddedDB(String string, Map map, int n, DBCPConnectionPoolAttr dBCPConnectionPoolAttr) {
        Object object;
        Serializable serializable;
        String string2 = DBUtils.dealWithDBPath(string);
        String string3 = "emb:jdbc:hsqldb:file:" + StableUtils.pathJoin(string2, string, "db");
        if (map != null) {
            serializable = new StringBuffer(";");
            object = map.entrySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ((StringBuffer)serializable).append(entry.getKey()).append("=").append(entry.getValue()).append(";");
            }
            string3 = string3 + ((StringBuffer)serializable).toString();
        }
        serializable = new JDBCDatabaseConnection("com.fr.third.org.hsqldb.jdbcDriver", string3, "sa", "");
        ((JDBCDatabaseConnection)serializable).setDbcpAttr(dBCPConnectionPoolAttr);
        object = null;
        try {
            try {
                if (n <= 0) {
                    n = 1;
                } else if (n > 200) {
                    n = 200;
                }
                object = ((JDBCDatabaseConnection)serializable).createConnection();
                object.createStatement().execute("SET LOGSIZE " + n);
            }
            catch (Exception exception) {
                throw new RuntimeException("CREATE EMB-DB: SET LOGSIZE FAILED!", exception);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            DBUtils.closeConnection(object);
            throw throwable;
        }
        DBUtils.closeConnection((java.sql.Connection)object);
        return serializable;
    }

    private static String dealWithDBPath(String string) {
        EnvProvider envProvider = GeneralContext.getEnvProvider();
        if (envProvider == null) {
            return "";
        }
        if (envProvider.isPackDeploy()) {
            try {
                File file = new File(StableUtils.pathJoin(envProvider.getPath(), string));
                if (!file.exists()) {
                    InputStream inputStream = envProvider.readBean("db.data", string);
                    IOUtils.copy(inputStream, "db.data", file);
                    inputStream = envProvider.readBean("db.script", string);
                    IOUtils.copy(inputStream, "db.script", file);
                }
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
            }
        }
        return envProvider.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void commitConnections(Map<String, java.sql.Connection> map) throws WriteSubmitException {
        if (map == null || map.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, java.sql.Connection>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Object var7_6;
            Map.Entry<String, java.sql.Connection> entry = iterator.next();
            java.sql.Connection connection = entry.getValue();
            try {
                try {
                    if (connection != null && !connection.isClosed()) {
                        try {
                            if (!connection.getAutoCommit()) {
                                connection.commit();
                            }
                        }
                        catch (SQLException sQLException) {
                            DBUtils.rollback(connection);
                            while (true) {
                                if (!iterator.hasNext()) {
                                    throw new WriteSubmitException("Could not commit to Database : " + entry.getKey() + "\n" + sQLException.getMessage(), sQLException);
                                }
                                java.sql.Connection connection2 = iterator.next().getValue();
                                DBUtils.rollback(connection2);
                                DBUtils.closeConnection(connection2);
                            }
                        }
                    }
                    var7_6 = null;
                }
                catch (SQLException sQLException) {
                    FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                    var7_6 = null;
                    DBUtils.closeConnection(connection);
                    continue;
                }
            }
            catch (Throwable throwable) {
                var7_6 = null;
                DBUtils.closeConnection(connection);
                throw throwable;
            }
            DBUtils.closeConnection(connection);
        }
        return;
    }
}

