/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x9.X9ECParameters;

public class X962Parameters
extends ASN1Encodable
implements ASN1Choice {
    private DERObject params = null;

    public static X962Parameters getInstance(Object obj) {
        if (obj == null || obj instanceof X962Parameters) {
            return (X962Parameters)obj;
        }
        if (obj instanceof DERObject) {
            return new X962Parameters((DERObject)obj);
        }
        throw new IllegalArgumentException("unknown object in getInstance()");
    }

    public static X962Parameters getInstance(ASN1TaggedObject obj, boolean explicit) {
        return X962Parameters.getInstance(obj.getObject());
    }

    public X962Parameters(X9ECParameters ecParameters) {
        this.params = ecParameters.getDERObject();
    }

    public X962Parameters(DERObjectIdentifier namedCurve) {
        this.params = namedCurve;
    }

    public X962Parameters(DERObject obj) {
        this.params = obj;
    }

    public boolean isNamedCurve() {
        return this.params instanceof DERObjectIdentifier;
    }

    public boolean isImplicitlyCA() {
        return this.params instanceof ASN1Null;
    }

    public DERObject getParameters() {
        return this.params;
    }

    public DERObject toASN1Object() {
        return this.params;
    }
}

