/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.plugin.frame.PlugInFrame;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;

public class MemoryMonitor
extends PlugInFrame {
    private static final int WIDTH = 250;
    private static final int HEIGHT = 90;
    private static final String LOC_KEY = "memory.loc";
    private static MemoryMonitor instance;
    private Image image;
    private Graphics2D g;
    private int frames;
    private double[] mem;
    private int index;
    private long value;
    private double defaultMax;
    private double max;
    private long maxMemory;

    public MemoryMonitor() {
        super("Memory");
        this.max = this.defaultMax = 1.849344E7;
        this.maxMemory = IJ.maxMemory();
        if (instance != null) {
            WindowManager.toFront(instance);
            return;
        }
        instance = this;
        WindowManager.addWindow(this);
        this.setLayout(new BorderLayout());
        Canvas ic = new Canvas();
        ic.setSize(250, 90);
        this.add(ic);
        this.setResizable(false);
        this.pack();
        Point loc = Prefs.getLocation(LOC_KEY);
        if (loc != null) {
            this.setLocation(loc);
        } else {
            GUI.center(this);
        }
        this.image = this.createImage(250, 90);
        this.g = (Graphics2D)this.image.getGraphics();
        this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.g.setColor(Color.white);
        this.g.fillRect(0, 0, 250, 90);
        this.g.setFont(new Font("SansSerif", 0, 12));
        Graphics icg = ic.getGraphics();
        icg.drawImage(this.image, 0, 0, null);
        this.show();
        ImageJ ij = IJ.getInstance();
        if (ij != null) {
            this.addKeyListener(ij);
            ic.addKeyListener(ij);
            ic.addMouseListener(ij);
        }
        this.mem = new double[251];
        Thread.currentThread().setPriority(1);
        while (true) {
            this.updatePlot();
            this.addText();
            icg.drawImage(this.image, 0, 0, null);
            IJ.wait(50);
            ++this.frames;
        }
    }

    void addText() {
        double value2;
        String s = String.valueOf(IJ.d2s(value2, (value2 = (double)this.value / 1048576.0) > 50.0 ? 0 : 2)) + "MB";
        if (this.maxMemory > 0L) {
            double percent = this.value * 100L / this.maxMemory;
            s = String.valueOf(s) + " (" + (percent < 1.0 ? "<1" : IJ.d2s(percent, 0)) + "%)";
        }
        this.g.drawString(s, 2, 15);
        String images = "" + WindowManager.getImageCount();
        this.g.drawString(images, 250 - (5 + images.length() * 8), 15);
    }

    void updatePlot() {
        int index2;
        double used = IJ.currentMemory();
        if (this.frames % 10 == 0) {
            this.value = (long)used;
        }
        if (used > 0.86 * this.max) {
            this.max *= 2.0;
        }
        this.mem[this.index++] = used;
        if (this.index == this.mem.length) {
            this.index = 0;
        }
        double maxmax = 0.0;
        int i = 0;
        while (i < this.mem.length) {
            if (this.mem[i] > maxmax) {
                maxmax = this.mem[i];
            }
            ++i;
        }
        if (maxmax < this.defaultMax) {
            this.max = this.defaultMax * 2.0;
        }
        if (maxmax < this.defaultMax / 2.0) {
            this.max = this.defaultMax;
        }
        if ((index2 = this.index + 1) == this.mem.length) {
            index2 = 0;
        }
        this.g.setColor(Color.white);
        this.g.fillRect(0, 0, 250, 90);
        this.g.setColor(Color.black);
        double scale = 90.0 / this.max;
        int x1 = 0;
        int y1 = 90 - (int)(this.mem[index2] * scale);
        int x2 = 1;
        while (x2 < 250) {
            if (++index2 == this.mem.length) {
                index2 = 0;
            }
            int y2 = 90 - (int)(this.mem[index2] * scale);
            this.g.drawLine(x1, y1, x2, y2);
            x1 = x2++;
            y1 = y2;
        }
    }

    public void close() {
        super.close();
        instance = null;
        Prefs.saveLocation(LOC_KEY, this.getLocation());
    }
}

