/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import java.awt.Polygon;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class XYWriter
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 1183;
    }

    public void run(ImageProcessor ip) {
        try {
            this.saveXYCoordinates(this.imp);
        }
        catch (IllegalArgumentException e) {
            IJ.error("XYWriter", e.getMessage());
        }
    }

    public void saveXYCoordinates(ImagePlus imp) {
        Roi roi = imp.getRoi();
        if (roi == null) {
            throw new IllegalArgumentException("ROI required");
        }
        SaveDialog sd = new SaveDialog("Save Coordinates as Text...", imp.getTitle(), ".txt");
        String name = sd.getFileName();
        if (name == null) {
            return;
        }
        String directory = sd.getDirectory();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedOutputStream(new FileOutputStream(String.valueOf(directory) + name)));
        }
        catch (IOException e) {
            IJ.error("XYWriter", "" + e);
            return;
        }
        Calibration cal = imp.getCalibration();
        String ls = System.getProperty("line.separator");
        if (roi.subPixelResolution()) {
            FloatPolygon p = roi.getFloatPolygon();
            int i = 0;
            while (i < p.npoints) {
                pw.print(String.valueOf(IJ.d2s((double)p.xpoints[i] * cal.pixelWidth, 4)) + "\t" + IJ.d2s((double)p.ypoints[i] * cal.pixelHeight, 4) + ls);
                ++i;
            }
        } else {
            Polygon p = roi.getPolygon();
            boolean scaled = cal.scaled();
            int i = 0;
            while (i < p.npoints) {
                if (scaled) {
                    pw.print(String.valueOf(IJ.d2s((double)p.xpoints[i] * cal.pixelWidth, 4)) + "\t" + IJ.d2s((double)p.ypoints[i] * cal.pixelHeight, 4) + ls);
                } else {
                    pw.print(String.valueOf(p.xpoints[i]) + "\t" + p.ypoints[i] + ls);
                }
                ++i;
            }
        }
        pw.close();
    }
}

