/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.plugin.ChannelSplitter;
import ij.plugin.PlugIn;
import ij.plugin.RGBStackMerge;
import ij.plugin.ThumbnailsCanvas;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class ChannelArranger
implements PlugIn,
TextListener {
    private ThumbnailsCanvas thumbNails;
    private String patternString;
    private String allowedDigits;
    private TextField orderField;
    private int nChannels;

    public void run(String arg) {
        String msg;
        ImagePlus imp = IJ.getImage();
        this.nChannels = imp.getNChannels();
        if (this.nChannels == 1) {
            IJ.error("Image must have more than one channel");
            return;
        }
        this.allowedDigits = this.patternString = "1234567890".substring(0, this.nChannels);
        GenericDialog gd = new GenericDialog("Arrange Channels");
        this.thumbNails = new ThumbnailsCanvas(imp);
        Panel panel = new Panel();
        panel.add(this.thumbNails);
        gd.addPanel(panel);
        gd.addStringField("New channel order:", this.allowedDigits);
        Vector v = gd.getStringFields();
        this.orderField = (TextField)v.elementAt(0);
        this.orderField.addTextListener(this);
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/image.html#arrange");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String newOrder = gd.getNextString();
        int nChannels2 = newOrder.length();
        if (nChannels2 == 0) {
            return;
        }
        int i = 0;
        while (i < nChannels2) {
            if (!Character.isDigit(newOrder.charAt(i))) {
                IJ.error("Arrange Channels", "Non-digit in new order string: \"" + newOrder + "\"");
                return;
            }
            ++i;
        }
        if (nChannels2 < this.nChannels && !IJ.showMessageWithCancel("Reduce Number of Channels?", msg = "The number of channels will be reduced from " + this.nChannels + " to " + nChannels2 + ".")) {
            return;
        }
        ImagePlus[] channels = ChannelSplitter.split(imp);
        ImagePlus[] channels2 = new ImagePlus[nChannels2];
        int i2 = 0;
        while (i2 < nChannels2) {
            channels2[i2] = channels[newOrder.charAt(i2) - 48 - 1];
            ++i2;
        }
        ImagePlus imp2 = null;
        imp2 = nChannels2 == 1 ? channels2[0] : RGBStackMerge.mergeChannels(channels2, false);
        int mode2 = 2;
        if (imp.isComposite()) {
            mode2 = ((CompositeImage)imp).getMode();
        }
        if (imp2.isComposite()) {
            ((CompositeImage)imp2).setMode(mode2);
        }
        int[] stackPos = this.thumbNails.getStackPos();
        String digit = "" + stackPos[0];
        int currentCh = newOrder.indexOf(digit) + 1;
        int currentSlc = stackPos[1];
        int currentFrm = stackPos[2];
        imp2.setPosition(currentCh, currentSlc, currentFrm);
        Point location = imp.getWindow() != null ? imp.getWindow().getLocation() : null;
        imp.changes = false;
        imp.close();
        imp2.copyAttributes(imp);
        if (location != null) {
            ImageWindow.setNextLocation(location);
        }
        imp2.changes = true;
        imp2.show();
    }

    public void textValueChanged(TextEvent e) {
        TextField tf = (TextField)e.getSource();
        String typed = tf.getText();
        if (typed.length() > this.nChannels) {
            this.orderField.setText(this.patternString);
            return;
        }
        int jj = 0;
        while (jj < typed.length()) {
            String digit = typed.substring(jj, jj + 1);
            int found = typed.indexOf(digit, jj + 1);
            if (found != -1) {
                this.orderField.setText(this.patternString);
                return;
            }
            if (this.allowedDigits.indexOf(digit) == -1) {
                this.orderField.setText(this.patternString);
                return;
            }
            ++jj;
        }
        this.patternString = typed;
        this.thumbNails.setSequence(this.patternString);
        this.thumbNails.repaint();
    }
}

