/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.extractor;

import com.fr.third.v2.org.apache.poi.POITextExtractor;
import com.fr.third.v2.org.apache.poi.POIXMLTextExtractor;
import com.fr.third.v2.org.apache.poi.hssf.extractor.ExcelExtractor;
import com.fr.third.v2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.OPCPackage;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Cell;
import com.fr.third.v2.org.apache.poi.ss.usermodel.CellStyle;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Comment;
import com.fr.third.v2.org.apache.poi.ss.usermodel.DataFormatter;
import com.fr.third.v2.org.apache.poi.ss.usermodel.HeaderFooter;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Row;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFCell;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFDrawing;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFRelation;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFShape;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFSheet;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import com.fr.third.v2.org.apache.xmlbeans.XmlException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;

public class XSSFExcelExtractor
extends POIXMLTextExtractor
implements com.fr.third.v2.org.apache.poi.ss.extractor.ExcelExtractor {
    public static final XSSFRelation[] SUPPORTED_TYPES = new XSSFRelation[]{XSSFRelation.WORKBOOK, XSSFRelation.MACRO_TEMPLATE_WORKBOOK, XSSFRelation.MACRO_ADDIN_WORKBOOK, XSSFRelation.TEMPLATE_WORKBOOK, XSSFRelation.MACROS_WORKBOOK};
    private Locale locale;
    private XSSFWorkbook workbook;
    private boolean includeSheetNames = true;
    private boolean formulasNotResults = false;
    private boolean includeCellComments = false;
    private boolean includeHeadersFooters = true;
    private boolean includeTextBoxes = true;

    public XSSFExcelExtractor(String path) throws XmlException, OpenXML4JException, IOException {
        this(new XSSFWorkbook(path));
    }

    public XSSFExcelExtractor(OPCPackage container) throws XmlException, OpenXML4JException, IOException {
        this(new XSSFWorkbook(container));
    }

    public XSSFExcelExtractor(XSSFWorkbook workbook) {
        super(workbook);
        this.workbook = workbook;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  XSSFExcelExtractor <filename.xlsx>");
            System.exit(1);
        }
        XSSFExcelExtractor extractor = new XSSFExcelExtractor(args[0]);
        try {
            System.out.println(((POITextExtractor)extractor).getText());
        }
        finally {
            extractor.close();
        }
    }

    public void setIncludeSheetNames(boolean includeSheetNames) {
        this.includeSheetNames = includeSheetNames;
    }

    public void setFormulasNotResults(boolean formulasNotResults) {
        this.formulasNotResults = formulasNotResults;
    }

    public void setIncludeCellComments(boolean includeCellComments) {
        this.includeCellComments = includeCellComments;
    }

    public void setIncludeHeadersFooters(boolean includeHeadersFooters) {
        this.includeHeadersFooters = includeHeadersFooters;
    }

    public void setIncludeTextBoxes(boolean includeTextBoxes) {
        this.includeTextBoxes = includeTextBoxes;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getText() {
        DataFormatter formatter = this.locale == null ? new DataFormatter() : new DataFormatter(this.locale);
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
            XSSFDrawing drawing;
            XSSFSheet sheet = this.workbook.getSheetAt(i);
            if (this.includeSheetNames) {
                text.append(this.workbook.getSheetName(i)).append("\n");
            }
            if (this.includeHeadersFooters) {
                text.append(this.extractHeaderFooter(sheet.getFirstHeader()));
                text.append(this.extractHeaderFooter(sheet.getOddHeader()));
                text.append(this.extractHeaderFooter(sheet.getEvenHeader()));
            }
            Iterator<Row> iterator = sheet.iterator();
            while (iterator.hasNext()) {
                Row rawR;
                Row row = rawR = iterator.next();
                Iterator<Cell> ri = row.cellIterator();
                while (ri.hasNext()) {
                    Cell cell = ri.next();
                    if (cell.getCellType() == 2) {
                        if (this.formulasNotResults) {
                            String contents = cell.getCellFormula();
                            this.checkMaxTextSize(text, contents);
                            text.append(contents);
                        } else if (cell.getCachedFormulaResultType() == 1) {
                            this.handleStringCell(text, cell);
                        } else {
                            this.handleNonStringCell(text, cell, formatter);
                        }
                    } else if (cell.getCellType() == 1) {
                        this.handleStringCell(text, cell);
                    } else {
                        this.handleNonStringCell(text, cell, formatter);
                    }
                    Comment comment = cell.getCellComment();
                    if (this.includeCellComments && comment != null) {
                        String commentText = comment.getString().getString().replace('\n', ' ');
                        this.checkMaxTextSize(text, commentText);
                        text.append(" Comment by ").append(comment.getAuthor()).append(": ").append(commentText);
                    }
                    if (!ri.hasNext()) continue;
                    text.append("\t");
                }
                text.append("\n");
            }
            if (this.includeTextBoxes && (drawing = sheet.getDrawingPatriarch()) != null) {
                for (XSSFShape shape : drawing.getShapes()) {
                    String boxText;
                    if (!(shape instanceof XSSFSimpleShape) || (boxText = ((XSSFSimpleShape)shape).getText()).length() <= 0) continue;
                    text.append(boxText);
                    text.append('\n');
                }
            }
            if (!this.includeHeadersFooters) continue;
            text.append(this.extractHeaderFooter(sheet.getFirstFooter()));
            text.append(this.extractHeaderFooter(sheet.getOddFooter()));
            text.append(this.extractHeaderFooter(sheet.getEvenFooter()));
        }
        return text.toString();
    }

    private void handleStringCell(StringBuffer text, Cell cell) {
        String contents = cell.getRichStringCellValue().getString();
        this.checkMaxTextSize(text, contents);
        text.append(contents);
    }

    private void handleNonStringCell(StringBuffer text, Cell cell, DataFormatter formatter) {
        CellStyle cs;
        int type = cell.getCellType();
        if (type == 2) {
            type = cell.getCachedFormulaResultType();
        }
        if (type == 0 && (cs = cell.getCellStyle()) != null && cs.getDataFormatString() != null) {
            String contents = formatter.formatRawCellContents(cell.getNumericCellValue(), cs.getDataFormat(), cs.getDataFormatString());
            this.checkMaxTextSize(text, contents);
            text.append(contents);
            return;
        }
        String contents = ((XSSFCell)cell).getRawValue();
        this.checkMaxTextSize(text, contents);
        text.append(contents);
    }

    private String extractHeaderFooter(HeaderFooter hf) {
        return ExcelExtractor._extractHeaderFooter(hf);
    }
}

