/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.util;

public class Units {
    public static final int EMU_PER_PIXEL = 9525;
    public static final int EMU_PER_POINT = 12700;
    public static final int EMU_PER_CENTIMETER = 360000;
    public static final int MASTER_DPI = 576;
    public static final int PIXEL_DPI = 96;
    public static final int POINT_DPI = 72;

    public static int toEMU(double points) {
        return (int)Math.rint(12700.0 * points);
    }

    public static double toPoints(long emu) {
        return (double)emu / 12700.0;
    }

    public static double fixedPointToDouble(int fixedPoint) {
        int i = fixedPoint >> 16;
        int f = fixedPoint >> 0 & 0xFFFF;
        double floatPoint = (double)i + (double)f / 65536.0;
        return floatPoint;
    }

    public static int doubleToFixedPoint(double floatPoint) {
        int i = (int)Math.floor(floatPoint);
        int f = (int)(floatPoint % 1.0 * 65536.0);
        int fixedPoint = i << 16 | f & 0xFFFF;
        return fixedPoint;
    }

    public static double masterToPoints(int masterDPI) {
        double points = masterDPI;
        points *= 72.0;
        return points /= 576.0;
    }

    public static int pointsToMaster(double points) {
        points *= 576.0;
        return (int)Math.rint(points /= 72.0);
    }

    public static int pointsToPixel(double points) {
        points *= 96.0;
        return (int)Math.rint(points /= 72.0);
    }

    public static double pixelToPoints(int pixel) {
        double points = pixel;
        points *= 72.0;
        return points /= 96.0;
    }
}

