/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.hssf.record.common;

import com.fr.third.v2.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.v2.org.apache.poi.hssf.record.common.SharedFeature;
import com.fr.third.v2.org.apache.poi.util.BitField;
import com.fr.third.v2.org.apache.poi.util.BitFieldFactory;
import com.fr.third.v2.org.apache.poi.util.LittleEndianOutput;

public final class FeatFormulaErr2
implements SharedFeature {
    static BitField checkCalculationErrors = BitFieldFactory.getInstance(1);
    static BitField checkEmptyCellRef = BitFieldFactory.getInstance(2);
    static BitField checkNumbersAsText = BitFieldFactory.getInstance(4);
    static BitField checkInconsistentRanges = BitFieldFactory.getInstance(8);
    static BitField checkInconsistentFormulas = BitFieldFactory.getInstance(16);
    static BitField checkDateTimeFormats = BitFieldFactory.getInstance(32);
    static BitField checkUnprotectedFormulas = BitFieldFactory.getInstance(64);
    static BitField performDataValidation = BitFieldFactory.getInstance(128);
    private int errorCheck;

    public FeatFormulaErr2() {
    }

    public FeatFormulaErr2(RecordInputStream in) {
        this.errorCheck = in.readInt();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" [FEATURE FORMULA ERRORS]\n");
        buffer.append("  checkCalculationErrors    = ");
        buffer.append("  checkEmptyCellRef         = ");
        buffer.append("  checkNumbersAsText        = ");
        buffer.append("  checkInconsistentRanges   = ");
        buffer.append("  checkInconsistentFormulas = ");
        buffer.append("  checkDateTimeFormats      = ");
        buffer.append("  checkUnprotectedFormulas  = ");
        buffer.append("  performDataValidation     = ");
        buffer.append(" [/FEATURE FORMULA ERRORS]\n");
        return buffer.toString();
    }

    public void serialize(LittleEndianOutput out) {
        out.writeInt(this.errorCheck);
    }

    public int getDataSize() {
        return 4;
    }

    public int _getRawErrorCheckValue() {
        return this.errorCheck;
    }

    public boolean getCheckCalculationErrors() {
        return checkCalculationErrors.isSet(this.errorCheck);
    }

    public void setCheckCalculationErrors(boolean checkCalculationErrors) {
        FeatFormulaErr2.checkCalculationErrors.setBoolean(this.errorCheck, checkCalculationErrors);
    }

    public boolean getCheckEmptyCellRef() {
        return checkEmptyCellRef.isSet(this.errorCheck);
    }

    public void setCheckEmptyCellRef(boolean checkEmptyCellRef) {
        FeatFormulaErr2.checkEmptyCellRef.setBoolean(this.errorCheck, checkEmptyCellRef);
    }

    public boolean getCheckNumbersAsText() {
        return checkNumbersAsText.isSet(this.errorCheck);
    }

    public void setCheckNumbersAsText(boolean checkNumbersAsText) {
        FeatFormulaErr2.checkNumbersAsText.setBoolean(this.errorCheck, checkNumbersAsText);
    }

    public boolean getCheckInconsistentRanges() {
        return checkInconsistentRanges.isSet(this.errorCheck);
    }

    public void setCheckInconsistentRanges(boolean checkInconsistentRanges) {
        FeatFormulaErr2.checkInconsistentRanges.setBoolean(this.errorCheck, checkInconsistentRanges);
    }

    public boolean getCheckInconsistentFormulas() {
        return checkInconsistentFormulas.isSet(this.errorCheck);
    }

    public void setCheckInconsistentFormulas(boolean checkInconsistentFormulas) {
        FeatFormulaErr2.checkInconsistentFormulas.setBoolean(this.errorCheck, checkInconsistentFormulas);
    }

    public boolean getCheckDateTimeFormats() {
        return checkDateTimeFormats.isSet(this.errorCheck);
    }

    public void setCheckDateTimeFormats(boolean checkDateTimeFormats) {
        FeatFormulaErr2.checkDateTimeFormats.setBoolean(this.errorCheck, checkDateTimeFormats);
    }

    public boolean getCheckUnprotectedFormulas() {
        return checkUnprotectedFormulas.isSet(this.errorCheck);
    }

    public void setCheckUnprotectedFormulas(boolean checkUnprotectedFormulas) {
        FeatFormulaErr2.checkUnprotectedFormulas.setBoolean(this.errorCheck, checkUnprotectedFormulas);
    }

    public boolean getPerformDataValidation() {
        return performDataValidation.isSet(this.errorCheck);
    }

    public void setPerformDataValidation(boolean performDataValidation) {
        FeatFormulaErr2.performDataValidation.setBoolean(this.errorCheck, performDataValidation);
    }
}

