/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.util.Vector;

class Tree
extends Panel {
    private static Font fFont = new Font("Dialog", 0, 12);
    private static FontMetrics fMetrics = Toolkit.getDefaultToolkit().getFontMetrics(fFont);
    private static int iRowHeight = Tree.getMaxHeight(fMetrics);
    private static int iIndentWidth = 12;
    private int iMaxTextLength;
    private Dimension dMinimum;
    private Graphics gImage;
    private Image iImage;
    private int iWidth;
    private int iHeight;
    private int iFirstRow;
    private int iTreeWidth;
    private int iTreeHeight;
    private int iX;
    private int iY;
    private Vector vData = new Vector();
    private int iRowCount;
    private Scrollbar sbHoriz;
    private Scrollbar sbVert;
    private int iSbWidth;
    private int iSbHeight;

    Tree() {
        this.setLayout(null);
        this.sbHoriz = new Scrollbar(0);
        this.add(this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.add(this.sbVert);
    }

    public void setMinimumSize(Dimension d) {
        this.dMinimum = d;
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.iSbHeight = this.sbHoriz.getPreferredSize().height;
        this.iSbWidth = this.sbVert.getPreferredSize().width;
        this.iHeight = h - this.iSbHeight;
        this.iWidth = w - this.iSbWidth;
        this.sbHoriz.setBounds(0, this.iHeight, this.iWidth, this.iSbHeight);
        this.sbVert.setBounds(this.iWidth, 0, this.iSbWidth, this.iHeight);
        this.adjustScroll();
        this.iImage = null;
        this.repaint();
    }

    public void removeAll() {
        this.vData = new Vector();
        this.iRowCount = 0;
        this.adjustScroll();
        this.iMaxTextLength = 10;
        this.repaint();
    }

    public void addRow(String key, String value, String state, int color) {
        String[] row = new String[4];
        if (value == null) {
            value = "";
        }
        row[0] = key;
        row[1] = value;
        row[2] = state;
        row[3] = String.valueOf(color);
        this.vData.addElement(row);
        int len = fMetrics.stringWidth(value);
        if (len > this.iMaxTextLength) {
            this.iMaxTextLength = len;
        }
        ++this.iRowCount;
    }

    public void addRow(String key, String value) {
        this.addRow(key, value, null, 0);
    }

    public void update() {
        this.adjustScroll();
        this.repaint();
    }

    void adjustScroll() {
        this.iTreeHeight = iRowHeight * (this.iRowCount + 1);
        this.iTreeWidth = this.iMaxTextLength * 2;
        this.sbHoriz.setValues(this.iX, this.iWidth, 0, this.iTreeWidth);
        int v = this.iY / iRowHeight;
        int h = this.iHeight / iRowHeight;
        this.sbVert.setValues(v, h, 0, this.iRowCount + 1);
        this.iX = this.sbHoriz.getValue();
        this.iY = iRowHeight * this.sbVert.getValue();
    }

    public boolean handleEvent(Event e) {
        switch (e.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                this.iX = this.sbHoriz.getValue();
                this.iY = iRowHeight * this.sbVert.getValue();
                this.repaint();
                return true;
            }
        }
        return super.handleEvent(e);
    }

    public void paint(Graphics g) {
        if (g == null || this.iWidth <= 0 || this.iHeight <= 0) {
            return;
        }
        g.setColor(SystemColor.control);
        g.fillRect(this.iWidth, this.iHeight, this.iSbWidth, this.iSbHeight);
        if (this.iImage == null) {
            this.iImage = this.createImage(this.iWidth, this.iHeight);
            this.gImage = this.iImage.getGraphics();
            this.gImage.setFont(fFont);
        }
        this.gImage.setColor(Color.white);
        this.gImage.fillRect(0, 0, this.iWidth, this.iHeight);
        int[] lasty = new int[100];
        String[] root = new String[100];
        root[0] = "";
        int currentindent = 0;
        int y = iRowHeight;
        y -= this.iY;
        boolean closed = false;
        for (int i = 0; i < this.iRowCount; ++i) {
            int ci;
            String[] s = (String[])this.vData.elementAt(i);
            String key = s[0];
            String data = s[1];
            String folder = s[2];
            for (ci = currentindent; ci > 0 && !key.startsWith(root[ci]); --ci) {
            }
            if (root[ci].length() < key.length()) {
                ++ci;
            }
            if (closed && ci > currentindent) continue;
            closed = folder != null && folder.equals("+");
            root[ci] = key;
            int x = iIndentWidth * ci - this.iX;
            this.gImage.setColor(Color.lightGray);
            this.gImage.drawLine(x, y, x + iIndentWidth, y);
            this.gImage.drawLine(x, y, x, lasty[ci]);
            lasty[ci + 1] = y;
            int py = y + iRowHeight / 3;
            int px = x + iIndentWidth * 2;
            if (folder != null) {
                int n = ci + 1;
                lasty[n] = lasty[n] + 4;
                int rgb = Integer.parseInt(s[3]);
                this.gImage.setColor(rgb == 0 ? Color.white : new Color(rgb));
                this.gImage.fillRect(x + iIndentWidth - 3, y - 3, 7, 7);
                this.gImage.setColor(Color.black);
                this.gImage.drawRect(x + iIndentWidth - 4, y - 4, 8, 8);
                this.gImage.drawLine(x + iIndentWidth - 2, y, x + iIndentWidth + 2, y);
                if (folder.equals("+")) {
                    this.gImage.drawLine(x + iIndentWidth, y - 2, x + iIndentWidth, y + 2);
                }
            } else {
                px -= iIndentWidth;
            }
            this.gImage.setColor(Color.black);
            this.gImage.drawString(data, px, py);
            currentindent = ci;
            y += iRowHeight;
        }
        g.drawImage(this.iImage, 0, 0, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public Dimension preferredSize() {
        return this.dMinimum;
    }

    public Dimension getPreferredSize() {
        return this.dMinimum;
    }

    public Dimension getMinimumSize() {
        return this.dMinimum;
    }

    public Dimension minimumSize() {
        return this.dMinimum;
    }

    public boolean mouseDown(Event e, int x, int y) {
        String[] s;
        int i;
        if (iRowHeight == 0 || x > this.iWidth || y > this.iHeight) {
            return true;
        }
        y += iRowHeight / 2;
        String[] root = new String[100];
        root[0] = "";
        int currentindent = 0;
        int cy = iRowHeight;
        boolean closed = false;
        y += this.iY;
        for (i = 0; i < this.iRowCount; ++i) {
            int ci;
            s = (String[])this.vData.elementAt(i);
            String key = s[0];
            String folder = s[2];
            for (ci = currentindent; ci > 0 && !key.startsWith(root[ci]); --ci) {
            }
            if (root[ci].length() < key.length()) {
                ++ci;
            }
            if (closed && ci > currentindent) continue;
            if (cy <= y && cy + iRowHeight > y) break;
            root[ci] = key;
            closed = folder != null && folder.equals("+");
            currentindent = ci;
            cy += iRowHeight;
        }
        if (i >= 0 && i < this.iRowCount) {
            s = (String[])this.vData.elementAt(i);
            String folder = s[2];
            if (folder != null && folder.equals("+")) {
                folder = "-";
            } else if (folder != null && folder.equals("-")) {
                folder = "+";
            }
            s[2] = folder;
            this.vData.setElementAt(s, i);
            this.repaint();
        }
        return true;
    }

    private static int getMaxHeight(FontMetrics f) {
        return f.getHeight() + 2;
    }
}

