/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.record.formula.AddPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.ConcatPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.DividePtg;
import com.fr.third.org.apache.poi.hssf.record.formula.EqualPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.ExpPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.FuncPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.FuncVarPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.GreaterEqualPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.GreaterThanPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.LessEqualPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.LessThanPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.MultiplyPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.NotEqualPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.OperationPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.PercentPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.PowerPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.record.formula.SubtractPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.UnaryMinusPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.UnaryPlusPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.AddEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ConcatEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.DivideEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.EqualEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.FuncVarEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.GreaterEqualEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.GreaterThanEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.LessEqualEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.LessThanEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.MultiplyEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NotEqualEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.OperationEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.PercentEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.PowerEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.SubtractEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.UnaryMinusEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.UnaryPlusEval;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

final class OperationEvaluatorFactory {
    private static final Class[] OPERATION_CONSTRUCTOR_CLASS_ARRAY = new Class[]{Ptg.class};
    private static final Map _constructorsByPtgClass = OperationEvaluatorFactory.initialiseConstructorsMap();

    private OperationEvaluatorFactory() {
    }

    private static Map initialiseConstructorsMap() {
        HashMap m = new HashMap(32);
        OperationEvaluatorFactory.add(m, AddPtg.class, AddEval.class);
        OperationEvaluatorFactory.add(m, ConcatPtg.class, ConcatEval.class);
        OperationEvaluatorFactory.add(m, DividePtg.class, DivideEval.class);
        OperationEvaluatorFactory.add(m, EqualPtg.class, EqualEval.class);
        OperationEvaluatorFactory.add(m, FuncPtg.class, FuncVarEval.class);
        OperationEvaluatorFactory.add(m, FuncVarPtg.class, FuncVarEval.class);
        OperationEvaluatorFactory.add(m, GreaterEqualPtg.class, GreaterEqualEval.class);
        OperationEvaluatorFactory.add(m, GreaterThanPtg.class, GreaterThanEval.class);
        OperationEvaluatorFactory.add(m, LessEqualPtg.class, LessEqualEval.class);
        OperationEvaluatorFactory.add(m, LessThanPtg.class, LessThanEval.class);
        OperationEvaluatorFactory.add(m, MultiplyPtg.class, MultiplyEval.class);
        OperationEvaluatorFactory.add(m, NotEqualPtg.class, NotEqualEval.class);
        OperationEvaluatorFactory.add(m, PercentPtg.class, PercentEval.class);
        OperationEvaluatorFactory.add(m, PowerPtg.class, PowerEval.class);
        OperationEvaluatorFactory.add(m, SubtractPtg.class, SubtractEval.class);
        OperationEvaluatorFactory.add(m, UnaryMinusPtg.class, UnaryMinusEval.class);
        OperationEvaluatorFactory.add(m, UnaryPlusPtg.class, UnaryPlusEval.class);
        return m;
    }

    private static void add(Map m, Class ptgClass, Class evalClass) {
        Constructor constructor;
        if (!Ptg.class.isAssignableFrom(ptgClass)) {
            throw new IllegalArgumentException("Expected Ptg subclass");
        }
        if (!OperationEval.class.isAssignableFrom(evalClass)) {
            throw new IllegalArgumentException("Expected OperationEval subclass");
        }
        if (!Modifier.isPublic(evalClass.getModifiers())) {
            throw new RuntimeException("Eval class must be public");
        }
        if (Modifier.isAbstract(evalClass.getModifiers())) {
            throw new RuntimeException("Eval class must not be abstract");
        }
        try {
            constructor = evalClass.getDeclaredConstructor(OPERATION_CONSTRUCTOR_CLASS_ARRAY);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Missing constructor");
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            throw new RuntimeException("Eval constructor must be public");
        }
        m.put(ptgClass, constructor);
    }

    public static OperationEval create(OperationPtg ptg) {
        Object result;
        if (ptg == null) {
            throw new IllegalArgumentException("ptg must not be null");
        }
        Class<?> ptgClass = ptg.getClass();
        Constructor constructor = (Constructor)_constructorsByPtgClass.get(ptgClass);
        if (constructor == null) {
            if (ptgClass == ExpPtg.class) {
                throw new RuntimeException("ExpPtg currently not supported");
            }
            throw new RuntimeException("Unexpected operation ptg class (" + ptgClass.getName() + ")");
        }
        Object[] initargs = new Object[]{ptg};
        try {
            result = constructor.newInstance(initargs);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return (OperationEval)result;
    }
}

