/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.model.Workbook;
import com.fr.third.org.apache.poi.hssf.record.FormatRecord;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class HSSFDataFormat {
    private static List builtinFormats = HSSFDataFormat.createBuiltinFormats();
    private Vector formats = new Vector();
    private Workbook workbook;
    private boolean movedBuiltins = false;

    public HSSFDataFormat(Workbook workbook) {
        this.workbook = workbook;
        Iterator i = workbook.getFormats().iterator();
        while (i.hasNext()) {
            FormatRecord r = (FormatRecord)i.next();
            if (this.formats.size() < r.getIndexCode() + 1) {
                this.formats.setSize(r.getIndexCode() + 1);
            }
            this.formats.set(r.getIndexCode(), r.getFormatString());
        }
    }

    private static synchronized List createBuiltinFormats() {
        Vector<String> builtinFormats = new Vector<String>();
        builtinFormats.add(0, "General");
        builtinFormats.add(1, "0");
        builtinFormats.add(2, "0.00");
        builtinFormats.add(3, "#,##0");
        builtinFormats.add(4, "#,##0.00");
        builtinFormats.add(5, "($#,##0_);($#,##0)");
        builtinFormats.add(6, "($#,##0_);[Red]($#,##0)");
        builtinFormats.add(7, "($#,##0.00);($#,##0.00)");
        builtinFormats.add(8, "($#,##0.00_);[Red]($#,##0.00)");
        builtinFormats.add(9, "0%");
        builtinFormats.add(10, "0.00%");
        builtinFormats.add(11, "0.00E+00");
        builtinFormats.add(12, "# ?/?");
        builtinFormats.add(13, "# ??/??");
        builtinFormats.add(14, "m/d/yy");
        builtinFormats.add(15, "d-mmm-yy");
        builtinFormats.add(16, "d-mmm");
        builtinFormats.add(17, "mmm-yy");
        builtinFormats.add(18, "h:mm AM/PM");
        builtinFormats.add(19, "h:mm:ss AM/PM");
        builtinFormats.add(20, "h:mm");
        builtinFormats.add(21, "h:mm:ss");
        builtinFormats.add(22, "m/d/yy h:mm");
        builtinFormats.add(23, "0x17");
        builtinFormats.add(24, "0x18");
        builtinFormats.add(25, "0x19");
        builtinFormats.add(26, "0x1a");
        builtinFormats.add(27, "0x1b");
        builtinFormats.add(28, "0x1c");
        builtinFormats.add(29, "0x1d");
        builtinFormats.add(30, "0x1e");
        builtinFormats.add(31, "0x1f");
        builtinFormats.add(32, "0x20");
        builtinFormats.add(33, "0x21");
        builtinFormats.add(34, "0x22");
        builtinFormats.add(35, "0x23");
        builtinFormats.add(36, "0x24");
        builtinFormats.add(37, "(#,##0_);(#,##0)");
        builtinFormats.add(38, "(#,##0_);[Red](#,##0)");
        builtinFormats.add(39, "(#,##0.00_);(#,##0.00)");
        builtinFormats.add(40, "(#,##0.00_);[Red](#,##0.00)");
        builtinFormats.add(41, "_(*#,##0_);_(*(#,##0);_(* \"-\"_);_(@_)");
        builtinFormats.add(42, "_($*#,##0_);_($*(#,##0);_($* \"-\"_);_(@_)");
        builtinFormats.add(43, "_(*#,##0.00_);_(*(#,##0.00);_(*\"-\"??_);_(@_)");
        builtinFormats.add(44, "_($*#,##0.00_);_($*(#,##0.00);_($*\"-\"??_);_(@_)");
        builtinFormats.add(45, "mm:ss");
        builtinFormats.add(46, "[h]:mm:ss");
        builtinFormats.add(47, "mm:ss.0");
        builtinFormats.add(48, "##0.0E+0");
        builtinFormats.add(49, "@");
        return builtinFormats;
    }

    public static List getBuiltinFormats() {
        return builtinFormats;
    }

    public static short getBuiltinFormat(String format) {
        if (format.toUpperCase().equals("TEXT")) {
            format = "@";
        }
        int retval = -1;
        for (int k = 0; k <= 49; k = (int)((short)(k + 1))) {
            String nformat = (String)builtinFormats.get(k);
            if (nformat == null || !nformat.equals(format)) continue;
            retval = k;
            break;
        }
        return (short)retval;
    }

    public short getFormat(String format) {
        int ind;
        ListIterator i;
        if (format.toUpperCase().equals("TEXT")) {
            format = "@";
        }
        if (!this.movedBuiltins) {
            i = builtinFormats.listIterator();
            while (i.hasNext()) {
                ind = i.nextIndex();
                if (this.formats.size() < ind + 1) {
                    this.formats.setSize(ind + 1);
                }
                this.formats.set(ind, i.next());
            }
            this.movedBuiltins = true;
        }
        i = this.formats.listIterator();
        while (i.hasNext()) {
            ind = i.nextIndex();
            if (!format.equals(i.next())) continue;
            return (short)ind;
        }
        ind = this.workbook.getFormat(format, true);
        if (this.formats.size() <= ind) {
            this.formats.setSize(ind + 1);
        }
        this.formats.set(ind, format);
        return (short)ind;
    }

    public String getFormat(short index) {
        if (this.movedBuiltins) {
            return (String)this.formats.get(index);
        }
        return (String)(builtinFormats.size() > index && builtinFormats.get(index) != null ? builtinFormats.get(index) : this.formats.get(index));
    }

    public static String getBuiltinFormat(short index) {
        return (String)builtinFormats.get(index);
    }

    public static int getNumberOfBuiltinBuiltinFormats() {
        return builtinFormats.size();
    }
}

