/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.EvaluationException;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.OperandResolver;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Function;

public class Mid
implements Function {
    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        int startIx;
        int numChars;
        String text;
        if (args.length != 3) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ValueEval evText = OperandResolver.getSingleValue(args[0], srcCellRow, srcCellCol);
            text = OperandResolver.coerceValueToString(evText);
            int startCharNum = Mid.evaluateNumberArg(args[1], srcCellRow, srcCellCol);
            numChars = Mid.evaluateNumberArg(args[2], srcCellRow, srcCellCol);
            startIx = startCharNum - 1;
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        int len = text.length();
        if (startIx < 0) {
            return ErrorEval.VALUE_INVALID;
        }
        if (numChars < 0) {
            return ErrorEval.VALUE_INVALID;
        }
        if (numChars < 0 || startIx > len) {
            return new StringEval("");
        }
        int endIx = startIx + numChars;
        if (endIx > len) {
            endIx = len;
        }
        String result = text.substring(startIx, endIx);
        return new StringEval(result);
    }

    private static int evaluateNumberArg(Eval arg, int srcCellRow, short srcCellCol) throws EvaluationException {
        ValueEval ev = OperandResolver.getSingleValue(arg, srcCellRow, srcCellCol);
        if (ev instanceof BlankEval) {
            return 0;
        }
        return OperandResolver.coerceValueToInt(ev);
    }
}

