/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.OperandPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.CellReference;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;

public abstract class RefPtgBase
extends OperandPtg {
    private static final int SIZE = 5;
    private static final int MAX_ROW_NUMBER = 65536;
    private int field_1_row;
    private int field_2_col;
    private static final BitField rowRelative = BitFieldFactory.getInstance(32768);
    private static final BitField colRelative = BitFieldFactory.getInstance(16384);
    private static final BitField column = BitFieldFactory.getInstance(255);

    protected RefPtgBase() {
    }

    protected RefPtgBase(String cellref) {
        CellReference c = new CellReference(cellref);
        this.setRow(c.getRow());
        this.setColumn(c.getCol());
        this.setColRelative(!c.isColAbsolute());
        this.setRowRelative(!c.isRowAbsolute());
    }

    protected RefPtgBase(int row, int column, boolean isRowRelative, boolean isColumnRelative) {
        this.setRow(row);
        this.setColumn(column);
        this.setRowRelative(isRowRelative);
        this.setColRelative(isColumnRelative);
    }

    protected RefPtgBase(RecordInputStream in) {
        this.field_1_row = in.readUShort();
        this.field_2_col = in.readUShort();
    }

    public final String toString() {
        CellReference cr = new CellReference(this.getRow(), this.getColumn(), !this.isRowRelative(), !this.isColRelative());
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" [");
        sb.append(cr.formatAsString());
        sb.append("]");
        return sb.toString();
    }

    public final void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(this.getSid() + this.getPtgClass());
        LittleEndian.putShort(array, offset + 1, (short)this.field_1_row);
        LittleEndian.putShort(array, offset + 3, (short)this.field_2_col);
    }

    protected abstract byte getSid();

    public final void setRow(int row) {
        if (row < 0 || row >= 65536) {
            throw new IllegalArgumentException("The row number, when specified as an integer, must be between 0 and 65536");
        }
        this.field_1_row = row;
    }

    public final int getRow() {
        return this.field_1_row;
    }

    public final int getRowAsInt() {
        return this.field_1_row;
    }

    public final boolean isRowRelative() {
        return rowRelative.isSet(this.field_2_col);
    }

    public final void setRowRelative(boolean rel) {
        this.field_2_col = rowRelative.setBoolean(this.field_2_col, rel);
    }

    public final boolean isColRelative() {
        return colRelative.isSet(this.field_2_col);
    }

    public final void setColRelative(boolean rel) {
        this.field_2_col = colRelative.setBoolean(this.field_2_col, rel);
    }

    public final void setColumnRawX(int col) {
        this.field_2_col = col;
    }

    public int getColumnRawX() {
        return this.field_2_col;
    }

    public final void setColumn(int col) {
        if (col < 0 || col >= 256) {
            throw new IllegalArgumentException("Specified colIx (" + col + ") is out of range");
        }
        this.field_2_col = column.setValue(this.field_2_col, col);
    }

    public final int getColumn() {
        return column.getValue(this.field_2_col);
    }

    public final int getSize() {
        return 5;
    }

    public final String toFormulaString(HSSFWorkbook book) {
        return new CellReference(this.getRowAsInt(), this.getColumn(), !this.isRowRelative(), !this.isColRelative()).formatAsString();
    }

    public final byte getDefaultOperandClass() {
        return 0;
    }
}

