/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.eventmodel;

import com.fr.third.org.apache.poi.hssf.eventmodel.ERFListener;
import com.fr.third.org.apache.poi.hssf.eventmodel.EventRecordFactory;
import com.fr.third.org.apache.poi.hssf.eventmodel.ModelFactoryListener;
import com.fr.third.org.apache.poi.hssf.model.Model;
import com.fr.third.org.apache.poi.hssf.model.Sheet;
import com.fr.third.org.apache.poi.hssf.model.Workbook;
import com.fr.third.org.apache.poi.hssf.record.BOFRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ModelFactory
implements ERFListener {
    List listeners = new ArrayList(1);
    Model currentmodel;
    boolean lastEOF;

    public void registerListener(ModelFactoryListener listener) {
        this.listeners.add(listener);
    }

    public void run(InputStream stream) {
        EventRecordFactory factory = new EventRecordFactory(true);
        factory.registerListener(this, null);
        this.lastEOF = true;
        factory.processRecords(stream);
    }

    public boolean processRecord(Record rec) {
        if (rec.getSid() == 2057) {
            if (!this.lastEOF) {
                throw new RuntimeException("Not yet handled embedded models");
            }
            BOFRecord bof = (BOFRecord)rec;
            switch (bof.getType()) {
                case 5: {
                    this.currentmodel = new Workbook();
                    break;
                }
                case 16: {
                    this.currentmodel = new Sheet();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported model type " + bof.getType());
                }
            }
        }
        if (rec.getSid() == 10) {
            this.lastEOF = true;
            this.throwEvent(this.currentmodel);
        } else {
            this.lastEOF = false;
        }
        return true;
    }

    private void throwEvent(Model model) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ModelFactoryListener mfl = (ModelFactoryListener)i.next();
            mfl.process(model);
        }
    }
}

