/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.signatures;

import com.fr.third.fr.pdf.forms.PdfAcroForm;
import com.fr.third.fr.pdf.io.font.PdfEncodings;
import com.fr.third.fr.pdf.io.source.ByteBuffer;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfCatalog;
import com.fr.third.fr.pdf.kernel.pdf.PdfDeveloperExtension;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfIndirectReference;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.signatures.ICrlClient;
import com.fr.third.fr.pdf.signatures.IOcspClient;
import com.fr.third.fr.pdf.signatures.PdfPKCS7;
import com.fr.third.fr.pdf.signatures.SignatureUtil;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LtvVerification {
    private Logger LOGGER = LoggerFactory.getLogger(LtvVerification.class);
    private PdfDocument document;
    private SignatureUtil sgnUtil;
    private PdfAcroForm acroForm;
    private Map<PdfName, ValidationData> validated = new HashMap<PdfName, ValidationData>();
    private boolean used = false;

    public LtvVerification(PdfDocument document) {
        this.document = document;
        this.acroForm = PdfAcroForm.getAcroForm(document, true);
        this.sgnUtil = new SignatureUtil(document);
    }

    public boolean addVerification(String signatureName, IOcspClient ocsp, ICrlClient crl, CertificateOption certOption, Level level, CertificateInclusion certInclude) throws IOException, GeneralSecurityException {
        if (this.used) {
            throw new IllegalStateException("verification.already.output");
        }
        PdfPKCS7 pk = this.sgnUtil.verifySignature(signatureName);
        this.LOGGER.info("Adding verification for " + signatureName);
        Certificate[] xc = pk.getCertificates();
        X509Certificate signingCert = pk.getSigningCertificate();
        ValidationData vd = new ValidationData();
        for (int k = 0; k < xc.length; ++k) {
            Collection<byte[]> cims;
            X509Certificate cert = (X509Certificate)xc[k];
            this.LOGGER.info("Certificate: " + cert.getSubjectDN());
            if (certOption == CertificateOption.SIGNING_CERTIFICATE && !cert.equals(signingCert)) continue;
            byte[] ocspEnc = null;
            if (ocsp != null && level != Level.CRL && (ocspEnc = ocsp.getEncoded(cert, this.getParent(cert, xc), null)) != null) {
                vd.ocsps.add(LtvVerification.buildOCSPResponse(ocspEnc));
                this.LOGGER.info("OCSP added");
            }
            if (crl != null && (level == Level.CRL || level == Level.OCSP_CRL || level == Level.OCSP_OPTIONAL_CRL && ocspEnc == null) && (cims = crl.getEncoded(cert, null)) != null) {
                for (byte[] cim : cims) {
                    boolean dup = false;
                    for (byte[] b : vd.crls) {
                        if (!Arrays.equals(b, cim)) continue;
                        dup = true;
                        break;
                    }
                    if (dup) continue;
                    vd.crls.add(cim);
                    this.LOGGER.info("CRL added");
                }
            }
            if (certInclude != CertificateInclusion.YES) continue;
            vd.certs.add(cert.getEncoded());
        }
        if (vd.crls.size() == 0 && vd.ocsps.size() == 0) {
            return false;
        }
        this.validated.put(this.getSignatureHashKey(signatureName), vd);
        return true;
    }

    private X509Certificate getParent(X509Certificate cert, Certificate[] certs) {
        for (int i = 0; i < certs.length; ++i) {
            X509Certificate parent = (X509Certificate)certs[i];
            if (!cert.getIssuerDN().equals(parent.getSubjectDN())) continue;
            try {
                cert.verify(parent.getPublicKey());
                return parent;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean addVerification(String signatureName, Collection<byte[]> ocsps, Collection<byte[]> crls, Collection<byte[]> certs) throws IOException, GeneralSecurityException {
        if (this.used) {
            throw new IllegalStateException("verification.already.output");
        }
        ValidationData vd = new ValidationData();
        if (ocsps != null) {
            for (byte[] ocsp : ocsps) {
                vd.ocsps.add(LtvVerification.buildOCSPResponse(ocsp));
            }
        }
        if (crls != null) {
            for (byte[] crl : crls) {
                vd.crls.add(crl);
            }
        }
        if (certs != null) {
            for (byte[] cert : certs) {
                vd.certs.add(cert);
            }
        }
        this.validated.put(this.getSignatureHashKey(signatureName), vd);
        return true;
    }

    private static byte[] buildOCSPResponse(byte[] BasicOCSPResponse2) throws IOException {
        DEROctetString doctet = new DEROctetString(BasicOCSPResponse2);
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(OCSPObjectIdentifiers.id_pkix_ocsp_basic);
        v2.add(doctet);
        ASN1Enumerated den = new ASN1Enumerated(0);
        ASN1EncodableVector v3 = new ASN1EncodableVector();
        v3.add(den);
        v3.add(new DERTaggedObject(true, 0, (ASN1Encodable)new DERSequence(v2)));
        DERSequence seq = new DERSequence(v3);
        return seq.getEncoded();
    }

    private PdfName getSignatureHashKey(String signatureName) throws NoSuchAlgorithmException, IOException {
        PdfDictionary dic = this.sgnUtil.getSignatureDictionary(signatureName);
        PdfString contents = dic.getAsString(PdfName.Contents);
        byte[] bc = PdfEncodings.convertToBytes(contents.getValue(), null);
        byte[] bt = null;
        if (PdfName.ETSI_RFC3161.equals(dic.getAsName(PdfName.SubFilter))) {
            ASN1InputStream din = new ASN1InputStream(new ByteArrayInputStream(bc));
            ASN1Primitive pkcs = din.readObject();
            bc = pkcs.getEncoded();
        }
        bt = LtvVerification.hashBytesSha1(bc);
        return new PdfName(LtvVerification.convertToHex(bt));
    }

    private static byte[] hashBytesSha1(byte[] b) throws NoSuchAlgorithmException {
        MessageDigest sh = MessageDigest.getInstance("SHA1");
        return sh.digest(b);
    }

    public void merge() throws IOException {
        if (this.used || this.validated.size() == 0) {
            return;
        }
        this.used = true;
        PdfDictionary catalog = (PdfDictionary)this.document.getCatalog().getPdfObject();
        PdfObject dss = catalog.get(PdfName.DSS);
        if (dss == null) {
            this.createDss();
        } else {
            this.updateDss();
        }
    }

    private void updateDss() throws IOException {
        PdfDictionary catalog = (PdfDictionary)this.document.getCatalog().getPdfObject();
        catalog.setModified();
        PdfDictionary dss = catalog.getAsDictionary(PdfName.DSS);
        PdfArray ocsps = dss.getAsArray(PdfName.OCSPs);
        PdfArray crls = dss.getAsArray(PdfName.CRLs);
        PdfArray certs = dss.getAsArray(PdfName.Certs);
        dss.remove(PdfName.OCSPs);
        dss.remove(PdfName.CRLs);
        dss.remove(PdfName.Certs);
        PdfDictionary vrim = dss.getAsDictionary(PdfName.VRI);
        if (vrim != null) {
            for (PdfName n : vrim.keySet()) {
                PdfDictionary vri;
                if (!this.validated.containsKey(n) || (vri = vrim.getAsDictionary(n)) == null) continue;
                LtvVerification.deleteOldReferences(ocsps, vri.getAsArray(PdfName.OCSP));
                LtvVerification.deleteOldReferences(crls, vri.getAsArray(PdfName.CRL));
                LtvVerification.deleteOldReferences(certs, vri.getAsArray(PdfName.Cert));
            }
        }
        if (ocsps == null) {
            ocsps = new PdfArray();
        }
        if (crls == null) {
            crls = new PdfArray();
        }
        if (certs == null) {
            certs = new PdfArray();
        }
        this.outputDss(dss, vrim, ocsps, crls, certs);
    }

    private static void deleteOldReferences(PdfArray all, PdfArray toDelete) {
        if (all == null || toDelete == null) {
            return;
        }
        for (PdfObject pi : toDelete) {
            PdfIndirectReference pir = pi.getIndirectReference();
            if (pir == null) continue;
            for (int k = 0; k < all.size(); ++k) {
                PdfIndirectReference pod = all.get(k).getIndirectReference();
                if (pod == null || pir.getObjNumber() != pod.getObjNumber()) continue;
                all.remove(k);
                --k;
            }
        }
    }

    private void createDss() throws IOException {
        this.outputDss(new PdfDictionary(), new PdfDictionary(), new PdfArray(), new PdfArray(), new PdfArray());
    }

    private void outputDss(PdfDictionary dss, PdfDictionary vrim, PdfArray ocsps, PdfArray crls, PdfArray certs) throws IOException {
        PdfCatalog catalog = this.document.getCatalog();
        catalog.addDeveloperExtension(PdfDeveloperExtension.ESIC_1_7_EXTENSIONLEVEL5);
        catalog.setModified();
        for (PdfName vkey : this.validated.keySet()) {
            PdfStream ps;
            PdfArray ocsp = new PdfArray();
            PdfArray crl = new PdfArray();
            PdfArray cert = new PdfArray();
            PdfDictionary vri = new PdfDictionary();
            for (byte[] b : this.validated.get((Object)vkey).crls) {
                ps = new PdfStream(b);
                ps.setCompressionLevel(-1);
                ps.makeIndirect(this.document);
                crl.add(ps);
                crls.add(ps);
            }
            for (byte[] b : this.validated.get((Object)vkey).ocsps) {
                ps = new PdfStream(b);
                ps.setCompressionLevel(-1);
                ocsp.add(ps);
                ocsps.add(ps);
            }
            for (byte[] b : this.validated.get((Object)vkey).certs) {
                ps = new PdfStream(b);
                ps.setCompressionLevel(-1);
                ps.makeIndirect(this.document);
                cert.add(ps);
                certs.add(ps);
            }
            if (ocsp.size() > 0) {
                ocsp.makeIndirect(this.document);
                vri.put(PdfName.OCSP, ocsp);
            }
            if (crl.size() > 0) {
                crl.makeIndirect(this.document);
                vri.put(PdfName.CRL, crl);
            }
            if (cert.size() > 0) {
                cert.makeIndirect(this.document);
                vri.put(PdfName.Cert, cert);
            }
            vri.makeIndirect(this.document);
            vrim.put(vkey, vri);
        }
        vrim.makeIndirect(this.document);
        dss.put(PdfName.VRI, vrim);
        if (ocsps.size() > 0) {
            ocsps.makeIndirect(this.document);
            dss.put(PdfName.OCSPs, ocsps);
        }
        if (crls.size() > 0) {
            crls.makeIndirect(this.document);
            dss.put(PdfName.CRLs, crls);
        }
        if (certs.size() > 0) {
            certs.makeIndirect(this.document);
            dss.put(PdfName.Certs, certs);
        }
        dss.makeIndirect(this.document);
        catalog.put(PdfName.DSS, dss);
    }

    public static String convertToHex(byte[] bytes) {
        ByteBuffer buf = new ByteBuffer();
        for (byte b : bytes) {
            buf.appendHex(b);
        }
        return PdfEncodings.convertToString(buf.toByteArray(), null).toUpperCase();
    }

    private static class ValidationData {
        public List<byte[]> crls = new ArrayList<byte[]>();
        public List<byte[]> ocsps = new ArrayList<byte[]>();
        public List<byte[]> certs = new ArrayList<byte[]>();

        private ValidationData() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CertificateInclusion {
        YES,
        NO;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CertificateOption {
        SIGNING_CERTIFICATE,
        WHOLE_CHAIN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        OCSP,
        CRL,
        OCSP_CRL,
        OCSP_OPTIONAL_CRL;

    }
}

