/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.renderer;

import com.fr.third.fr.pdf.kernel.geom.PageSize;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfPage;
import com.fr.third.fr.pdf.kernel.pdf.canvas.PdfCanvas;
import com.fr.third.fr.pdf.layout.Document;
import com.fr.third.fr.pdf.layout.element.AreaBreak;
import com.fr.third.fr.pdf.layout.layout.LayoutArea;
import com.fr.third.fr.pdf.layout.layout.LayoutResult;
import com.fr.third.fr.pdf.layout.property.AreaBreakType;
import com.fr.third.fr.pdf.layout.renderer.DrawContext;
import com.fr.third.fr.pdf.layout.renderer.IRenderer;
import com.fr.third.fr.pdf.layout.renderer.RootRenderer;
import java.util.ArrayList;
import java.util.List;

public class DocumentRenderer
extends RootRenderer {
    protected Document document;
    protected List<Integer> wrappedContentPage = new ArrayList<Integer>();

    public DocumentRenderer(Document document) {
        this(document, true);
    }

    public DocumentRenderer(Document document, boolean immediateFlush) {
        this.document = document;
        this.immediateFlush = immediateFlush;
        this.modelElement = document;
    }

    public LayoutArea getOccupiedArea() {
        throw new IllegalStateException("Not applicable for DocumentRenderer");
    }

    public IRenderer getNextRenderer() {
        return null;
    }

    protected LayoutArea updateCurrentArea(LayoutResult overflowResult) {
        PageSize customPageSize;
        AreaBreak areaBreak = overflowResult != null && overflowResult.getAreaBreak() != null ? overflowResult.getAreaBreak() : null;
        this.moveToNextPage();
        while (areaBreak != null && areaBreak.getType() == AreaBreakType.LAST_PAGE && this.currentPageNumber < this.document.getPdfDocument().getNumberOfPages()) {
            this.moveToNextPage();
        }
        PageSize pageSize = customPageSize = areaBreak != null ? areaBreak.getPageSize() : null;
        while (this.document.getPdfDocument().getNumberOfPages() >= this.currentPageNumber && this.document.getPdfDocument().getPage(this.currentPageNumber).isFlushed()) {
            ++this.currentPageNumber;
        }
        PageSize lastPageSize = this.ensureDocumentHasNPages(this.currentPageNumber, customPageSize);
        if (lastPageSize == null) {
            lastPageSize = new PageSize(this.document.getPdfDocument().getPage(this.currentPageNumber).getPageSize());
        }
        this.currentArea = new LayoutArea(this.currentPageNumber, this.document.getPageEffectiveArea(lastPageSize));
        return this.currentArea;
    }

    protected void flushSingleRenderer(IRenderer resultRenderer) {
        if (!resultRenderer.isFlushed()) {
            int pageNum = resultRenderer.getOccupiedArea().getPageNumber();
            PdfDocument pdfDocument = this.document.getPdfDocument();
            this.ensureDocumentHasNPages(pageNum, null);
            PdfPage correspondingPage = pdfDocument.getPage(pageNum);
            boolean wrapOldContent = pdfDocument.getReader() != null && pdfDocument.getWriter() != null && correspondingPage.getContentStreamCount() > 0 && correspondingPage.getLastContentStream().getLength() > 0 && !this.wrappedContentPage.contains(pageNum) && pdfDocument.getNumberOfPages() >= pageNum;
            this.wrappedContentPage.add(pageNum);
            if (pdfDocument.isTagged()) {
                pdfDocument.getTagStructureContext().getAutoTaggingPointer().setPageForTagging(correspondingPage);
            }
            resultRenderer.draw(new DrawContext(pdfDocument, new PdfCanvas(correspondingPage, wrapOldContent), pdfDocument.isTagged()));
        }
    }

    protected PageSize addNewPage(PageSize customPageSize) {
        if (customPageSize != null) {
            this.document.getPdfDocument().addNewPage(customPageSize);
        } else {
            this.document.getPdfDocument().addNewPage();
        }
        return customPageSize != null ? customPageSize : this.document.getPdfDocument().getDefaultPageSize();
    }

    private PageSize ensureDocumentHasNPages(int n, PageSize customPageSize) {
        PageSize lastPageSize = null;
        while (this.document.getPdfDocument().getNumberOfPages() < n) {
            lastPageSize = this.addNewPage(customPageSize);
        }
        return lastPageSize;
    }

    private void moveToNextPage() {
        if (this.immediateFlush && this.currentPageNumber > 1) {
            this.document.getPdfDocument().getPage(this.currentPageNumber - 1).flush();
        }
        ++this.currentPageNumber;
    }
}

