/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.layout;

import com.fr.third.fr.pdf.io.util.HashCode;
import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import java.text.MessageFormat;

public class LayoutArea {
    protected int pageNumber;
    protected Rectangle bBox;
    protected boolean emptyArea = true;

    public LayoutArea(int pageNumber, Rectangle bBox) {
        this.pageNumber = pageNumber;
        this.bBox = bBox;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public Rectangle getBBox() {
        return this.bBox;
    }

    public void setBBox(Rectangle bbox) {
        this.bBox = bbox;
    }

    public boolean isEmptyArea() {
        return this.emptyArea;
    }

    public void setEmptyArea(boolean emptyArea) {
        this.emptyArea = emptyArea;
    }

    public LayoutArea clone() {
        LayoutArea area = new LayoutArea(this.pageNumber, this.bBox.clone());
        area.setEmptyArea(this.emptyArea);
        return area;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LayoutArea)) {
            return false;
        }
        LayoutArea that = (LayoutArea)obj;
        return this.pageNumber == that.pageNumber && this.bBox.equalsWithEpsilon(that.bBox, 1.0E-4f);
    }

    public int hashCode() {
        HashCode hashCode = new HashCode();
        hashCode.append(this.pageNumber).append(this.bBox.hashCode()).append(this.emptyArea);
        return hashCode.hashCode();
    }

    public String toString() {
        return MessageFormat.format("{0}, page {1}", this.bBox.toString(), this.pageNumber);
    }
}

