/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.collection;

import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.pdf.PdfBoolean;
import com.fr.third.fr.pdf.kernel.pdf.PdfDate;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfObjectWrapper;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfCollectionField
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = 4766153544105870238L;
    public static final int TEXT = 0;
    public static final int DATE = 1;
    public static final int NUMBER = 2;
    public static final int FILENAME = 3;
    public static final int DESC = 4;
    public static final int MODDATE = 5;
    public static final int CREATIONDATE = 6;
    public static final int SIZE = 7;
    protected int subType;
    private static Map<String, SubTypeHelper> subTypeHelperMap = new HashMap<String, SubTypeHelper>();

    protected PdfCollectionField(PdfDictionary pdfObject) {
        super(pdfObject);
        String subType = pdfObject.getAsName(PdfName.Subtype).getValue();
        SubTypeHelper subTypeHelper = subTypeHelperMap.get(subType);
        if (subTypeHelper != null) {
            subTypeHelper.dealWith(this);
        } else {
            this.subType = 0;
        }
    }

    public PdfCollectionField(String name, int subType) {
        super(new PdfDictionary());
        ((PdfDictionary)this.getPdfObject()).put(PdfName.N, new PdfString(name));
        this.subType = subType;
        switch (subType) {
            default: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.S);
                break;
            }
            case 1: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.D);
                break;
            }
            case 2: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.N);
                break;
            }
            case 3: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.F);
                break;
            }
            case 4: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.Desc);
                break;
            }
            case 5: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.ModDate);
                break;
            }
            case 6: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.CreationDate);
                break;
            }
            case 7: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.Size);
            }
        }
    }

    public PdfCollectionField setOrder(int order) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.O, new PdfNumber(order));
        return this;
    }

    public PdfNumber getOrder() {
        return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.O);
    }

    public PdfCollectionField setVisibility(boolean visible) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.V, new PdfBoolean(visible));
        return this;
    }

    public PdfBoolean getVisibility() {
        return ((PdfDictionary)this.getPdfObject()).getAsBoolean(PdfName.V);
    }

    public PdfCollectionField setEditable(boolean editable) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.E, new PdfBoolean(editable));
        return this;
    }

    public PdfBoolean getEditable() {
        return ((PdfDictionary)this.getPdfObject()).getAsBoolean(PdfName.E);
    }

    public PdfObject getValue(String value) {
        switch (this.subType) {
            case 0: {
                return new PdfString(value);
            }
            case 1: {
                return new PdfDate(PdfDate.decode(value)).getPdfObject();
            }
            case 2: {
                return new PdfNumber(Double.parseDouble(value.trim()));
            }
        }
        throw new PdfException("{0}.is.not.an.acceptable.value.for.the.field.{1}").setMessageParams(value, ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.N).getValue());
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }

    static {
        subTypeHelperMap.put("D", new SubTypeHelper(){

            public void dealWith(PdfCollectionField field) {
                field.subType = 1;
            }
        });
        subTypeHelperMap.put("N", new SubTypeHelper(){

            public void dealWith(PdfCollectionField field) {
                field.subType = 2;
            }
        });
        subTypeHelperMap.put("F", new SubTypeHelper(){

            public void dealWith(PdfCollectionField field) {
                field.subType = 3;
            }
        });
        subTypeHelperMap.put("Desc", new SubTypeHelper(){

            public void dealWith(PdfCollectionField field) {
                field.subType = 4;
            }
        });
        subTypeHelperMap.put("ModDate", new SubTypeHelper(){

            public void dealWith(PdfCollectionField field) {
                field.subType = 5;
            }
        });
        subTypeHelperMap.put("CreationDate", new SubTypeHelper(){

            public void dealWith(PdfCollectionField field) {
                field.subType = 6;
            }
        });
        subTypeHelperMap.put("Size", new SubTypeHelper(){

            public void dealWith(PdfCollectionField field) {
                field.subType = 7;
            }
        });
    }

    private static interface SubTypeHelper {
        public void dealWith(PdfCollectionField var1);
    }
}

