/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf;

import com.fr.third.fr.pdf.io.font.PdfEncodings;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfPrimitiveObject;
import java.util.Arrays;

public class PdfLiteral
extends PdfPrimitiveObject {
    private static final long serialVersionUID = -770215611509192403L;
    private long position;

    public PdfLiteral(byte[] content) {
        super(true);
        this.content = content;
    }

    public PdfLiteral(int size) {
        this(new byte[size]);
        Arrays.fill(this.content, (byte)32);
    }

    public PdfLiteral(String content) {
        this(PdfEncodings.convertToBytes(content, null));
    }

    private PdfLiteral() {
        this((byte[])null);
    }

    public byte getType() {
        return 4;
    }

    public String toString() {
        if (this.content != null) {
            return new String(this.content);
        }
        return "";
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public int getBytesCount() {
        return this.content.length;
    }

    protected void generateContent() {
    }

    protected PdfLiteral newInstance() {
        return new PdfLiteral();
    }

    protected void copyContent(PdfObject from, PdfDocument document) {
        super.copyContent(from, document);
        PdfLiteral literal = (PdfLiteral)from;
        this.content = literal.getInternalContent();
    }
}

