/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.font;

import com.fr.third.fr.pdf.io.IOException;
import com.fr.third.fr.pdf.io.font.AdobeGlyphList;
import com.fr.third.fr.pdf.io.font.FontConstants;
import com.fr.third.fr.pdf.io.font.FontNames;
import com.fr.third.fr.pdf.io.font.FontProgram;
import com.fr.third.fr.pdf.io.font.Type1Parser;
import com.fr.third.fr.pdf.io.font.otf.Glyph;
import com.fr.third.fr.pdf.io.source.RandomAccessFileOrArray;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Type1Font
extends FontProgram {
    private static final long serialVersionUID = -1078208220942939920L;
    private Type1Parser fontParser;
    private String characterSet;
    private Map<Long, Integer> kernPairs = new HashMap<Long, Integer>();
    private static final int[] PFB_TYPES = new int[]{1, 2, 1};
    private byte[] fontStreamBytes;
    private int[] fontStreamLengths;
    private static Map<String, FontDealer> fontDealerMap = new HashMap<String, FontDealer>();
    private static Map<String, TokenHelper> tokenHelper;

    protected static Type1Font createStandardFont(String name) throws Exception {
        if (FontConstants.BUILTIN_FONTS_14.contains(name)) {
            return new Type1Font(name, null, null, null);
        }
        throw new IOException("1.is.not.a.standard.type1.font").setMessageParams(name);
    }

    protected Type1Font(String metricsPath, String binaryPath, byte[] afm, byte[] pfb) throws Exception {
        this.checkFilePath(metricsPath);
        this.checkFilePath(binaryPath);
        this.fontParser = new Type1Parser(metricsPath, binaryPath, afm, pfb);
        this.process();
    }

    protected Type1Font(String baseFont) {
        this.getFontNames().setFontName(baseFont);
    }

    public boolean isBuiltInFont() {
        return this.fontParser != null && this.fontParser.isBuiltInFont();
    }

    public int getPdfFontFlags() {
        int flags = 0;
        if (this.fontMetrics.isFixedPitch()) {
            flags |= 1;
        }
        flags |= this.isFontSpecific() ? 4 : 32;
        if (this.fontMetrics.getItalicAngle() < 0.0f) {
            flags |= 0x40;
        }
        if (this.fontNames.getFontName().contains("Caps") || this.fontNames.getFontName().endsWith("SC")) {
            flags |= 0x20000;
        }
        if (this.fontNames.isBold() || this.fontNames.getFontWeight() > 500) {
            flags |= 0x40000;
        }
        return flags;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public boolean hasKernPairs() {
        return this.kernPairs.size() > 0;
    }

    public int getKerning(Glyph first, Glyph second) {
        if (first.hasValidUnicode() && second.hasValidUnicode()) {
            Long record = ((long)first.getUnicode().intValue() << 32) + (long)second.getUnicode().intValue();
            if (this.kernPairs.containsKey(record)) {
                return this.kernPairs.get(record);
            }
            return 0;
        }
        return 0;
    }

    public boolean setKerning(int first, int second, int kern) {
        Long record = ((long)first << 32) + (long)second;
        this.kernPairs.put(record, kern);
        return true;
    }

    public Glyph getGlyph(String name) {
        Integer unicode = AdobeGlyphList.nameToUnicode(name);
        if (unicode == null) {
            return null;
        }
        return this.getGlyph(unicode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getFontStreamBytes() {
        if (this.fontParser.isBuiltInFont()) {
            return null;
        }
        if (this.fontStreamBytes != null) {
            return this.fontStreamBytes;
        }
        RandomAccessFileOrArray raf = null;
        try {
            raf = this.fontParser.getPostscriptBinary();
            int fileLength = (int)raf.length();
            this.fontStreamBytes = new byte[fileLength - 18];
            this.fontStreamLengths = new int[3];
            int bytePtr = 0;
            int k = 0;
            while (true) {
                int size;
                if (k < 3) {
                    if (raf.read() != 128) {
                        Logger logger = LoggerFactory.getLogger(Type1Font.class);
                        logger.error("Start marker is missing in the pfb file");
                        byte[] byArray = null;
                        return byArray;
                    }
                    if (raf.read() != PFB_TYPES[k]) {
                        Logger logger = LoggerFactory.getLogger(Type1Font.class);
                        logger.error("incorrect.segment.type.in.pfb.file");
                        byte[] byArray = null;
                        return byArray;
                    }
                    size = raf.read();
                    size += raf.read() << 8;
                    size += raf.read() << 16;
                    this.fontStreamLengths[k] = size += raf.read() << 24;
                } else {
                    byte[] byArray = this.fontStreamBytes;
                    return byArray;
                }
                while (size != 0) {
                    int got = raf.read(this.fontStreamBytes, bytePtr, size);
                    if (got < 0) {
                        Logger logger = LoggerFactory.getLogger(Type1Font.class);
                        logger.error("premature.end.in.pfb.file");
                        byte[] byArray = null;
                        return byArray;
                    }
                    bytePtr += got;
                    size -= got;
                }
                ++k;
            }
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(Type1Font.class);
            logger.error("type1.font.file.exception");
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public int[] getFontStreamLengths() {
        return this.fontStreamLengths;
    }

    protected void process() throws Exception {
        String metricsPath;
        String ident;
        StringTokenizer tok;
        Glyph space;
        String line;
        RandomAccessFileOrArray raf = this.fontParser.getMetricsFile();
        boolean startKernPairs = false;
        while (!startKernPairs && (line = raf.readLine()) != null) {
            String ident2;
            FontDealer dealer;
            StringTokenizer tok2 = new StringTokenizer(line, " ,\n\r\t\f");
            if (!tok2.hasMoreTokens() || (dealer = fontDealerMap.get(ident2 = tok2.nextToken())) == null) continue;
            startKernPairs = dealer.dealWith(this, tok2);
        }
        if (!startKernPairs) {
            String metricsPath2 = this.fontParser.getAfmPath();
            if (metricsPath2 != null) {
                throw new IOException("missing.startcharmetrics.in.1").setMessageParams(metricsPath2);
            }
            throw new IOException("missing.startcharmetrics.in.the.metrics.file");
        }
        this.avgWidth = 0;
        int widthCount = 0;
        while ((line = raf.readLine()) != null) {
            StringTokenizer tok3 = new StringTokenizer(line);
            if (!tok3.hasMoreTokens()) continue;
            String ident3 = tok3.nextToken();
            if (ident3.equals("EndCharMetrics")) {
                startKernPairs = false;
                break;
            }
            GlyphHelper helper = new GlyphHelper();
            tok3 = new StringTokenizer(line, ";");
            while (tok3.hasMoreTokens()) {
                TokenHelper h;
                StringTokenizer tokc = new StringTokenizer(tok3.nextToken());
                if (!tokc.hasMoreTokens() || (h = tokenHelper.get(ident3 = tokc.nextToken())) == null) continue;
                h.getToken(helper, tokc);
            }
            Integer unicode = AdobeGlyphList.nameToUnicode(helper.N);
            Glyph glyph = new Glyph(helper.C, helper.WX, unicode != null ? unicode : -1, helper.B);
            if (helper.C >= 0) {
                this.codeToGlyph.put(helper.C, glyph);
            }
            if (unicode != null) {
                this.unicodeToGlyph.put(unicode, glyph);
            }
            this.avgWidth += helper.WX.intValue();
            ++widthCount;
        }
        if (widthCount != 0) {
            this.avgWidth /= widthCount;
        }
        if (startKernPairs) {
            String metricsPath3 = this.fontParser.getAfmPath();
            if (metricsPath3 != null) {
                throw new IOException("missing.endcharmetrics.in.1").setMessageParams(metricsPath3);
            }
            throw new IOException("missing.endcharmetrics.in.the.metrics.file");
        }
        if (!this.unicodeToGlyph.containsKey(160) && (space = (Glyph)this.unicodeToGlyph.get(32)) != null) {
            this.unicodeToGlyph.put(160, new Glyph(space.getCode(), space.getWidth(), 160, space.getBbox()));
        }
        boolean endOfMetrics = false;
        while ((line = raf.readLine()) != null) {
            tok = new StringTokenizer(line);
            if (!tok.hasMoreTokens()) continue;
            ident = tok.nextToken();
            if (ident.equals("EndFontMetrics")) {
                endOfMetrics = true;
                break;
            }
            if (!ident.equals("StartKernPairs")) continue;
            startKernPairs = true;
            break;
        }
        if (startKernPairs) {
            while ((line = raf.readLine()) != null) {
                tok = new StringTokenizer(line);
                if (!tok.hasMoreTokens()) continue;
                ident = tok.nextToken();
                if (ident.equals("KPX")) {
                    String first = tok.nextToken();
                    String second = tok.nextToken();
                    Integer width = (int)Float.parseFloat(tok.nextToken());
                    Integer firstUni = AdobeGlyphList.nameToUnicode(first);
                    Integer secondUni = AdobeGlyphList.nameToUnicode(second);
                    if (firstUni == null || secondUni == null) continue;
                    Long record = ((long)firstUni.intValue() << 32) + (long)secondUni.intValue();
                    this.kernPairs.put(record, width);
                    continue;
                }
                if (!ident.equals("EndKernPairs")) continue;
                startKernPairs = false;
                break;
            }
        } else if (!endOfMetrics) {
            metricsPath = this.fontParser.getAfmPath();
            if (metricsPath != null) {
                throw new IOException("missing.endfontmetrics.in.1").setMessageParams(metricsPath);
            }
            throw new IOException("missing.endfontmetrics.in.the.metrics.file");
        }
        if (startKernPairs) {
            metricsPath = this.fontParser.getAfmPath();
            if (metricsPath != null) {
                throw new IOException("missing.endkernpairs.in.1").setMessageParams(metricsPath);
            }
            throw new IOException("missing.endkernpairs.in.the.metrics.file");
        }
        raf.close();
        this.isFontSpecific = !this.encodingScheme.equals("AdobeStandardEncoding") && !this.encodingScheme.equals("StandardEncoding");
    }

    static {
        fontDealerMap.put("FontName", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                font.fontNames.setFontName(tok.nextToken("\u00ff").substring(1));
                return false;
            }
        });
        fontDealerMap.put("FullName", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                String fullName = tok.nextToken("\u00ff").substring(1);
                font.fontNames.setFullName(new String[][]{{"", "", "", fullName}});
                return false;
            }
        });
        fontDealerMap.put("FamilyName", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                String familyName = tok.nextToken("\u00ff").substring(1);
                font.fontNames.setFamilyName(new String[][]{{"", "", "", familyName}});
                return false;
            }
        });
        fontDealerMap.put("Weight", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                font.fontNames.setWeight(FontNames.convertFontWeight(tok.nextToken("\u00ff").substring(1)));
                return false;
            }
        });
        fontDealerMap.put("ItalicAngle", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                font.fontMetrics.setItalicAngle(Float.parseFloat(tok.nextToken()));
                return false;
            }
        });
        fontDealerMap.put("IsFixedPitch", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                font.fontMetrics.setIsFixedPitch(tok.nextToken().equals("true"));
                return false;
            }
        });
        fontDealerMap.put("CharacterSet", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                font.characterSet = tok.nextToken("\u00ff").substring(1);
                return false;
            }
        });
        fontDealerMap.put("FontBBox", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                int llx = (int)Float.parseFloat(tok.nextToken());
                int lly = (int)Float.parseFloat(tok.nextToken());
                int urx = (int)Float.parseFloat(tok.nextToken());
                int ury = (int)Float.parseFloat(tok.nextToken());
                font.fontMetrics.setBbox(llx, lly, urx, ury);
                return false;
            }
        });
        fontDealerMap.put("UnderlinePosition", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                font.fontMetrics.setUnderlinePosition((int)Float.parseFloat(tok.nextToken()));
                return false;
            }
        });
        fontDealerMap.put("UnderlineThickness", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                font.fontMetrics.setUnderlineThickness((int)Float.parseFloat(tok.nextToken()));
                return false;
            }
        });
        fontDealerMap.put("EncodingScheme", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                font.encodingScheme = tok.nextToken("\u00ff").substring(1).trim();
                return false;
            }
        });
        fontDealerMap.put("CapHeight", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                font.fontMetrics.setCapHeight((int)Float.parseFloat(tok.nextToken()));
                return false;
            }
        });
        fontDealerMap.put("XHeight", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                font.fontMetrics.setXHeight((int)Float.parseFloat(tok.nextToken()));
                return false;
            }
        });
        fontDealerMap.put("Ascender", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                font.fontMetrics.setTypoAscender((int)Float.parseFloat(tok.nextToken()));
                return false;
            }
        });
        fontDealerMap.put("Descender", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                font.fontMetrics.setTypoDescender((int)Float.parseFloat(tok.nextToken()));
                return false;
            }
        });
        fontDealerMap.put("StdHW", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                font.fontMetrics.setStemH((int)Float.parseFloat(tok.nextToken()));
                return false;
            }
        });
        fontDealerMap.put("StdVW", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                font.fontMetrics.setStemV((int)Float.parseFloat(tok.nextToken()));
                return false;
            }
        });
        fontDealerMap.put("StartCharMetrics", new FontDealer(){

            public boolean dealWith(Type1Font font, StringTokenizer tok) {
                return true;
            }
        });
        tokenHelper = new HashMap<String, TokenHelper>();
        tokenHelper.put("C", new TokenHelper(){

            public void getToken(GlyphHelper helper, StringTokenizer tokc) {
                helper.C = Integer.valueOf(tokc.nextToken());
            }
        });
        tokenHelper.put("WX", new TokenHelper(){

            public void getToken(GlyphHelper helper, StringTokenizer tokc) {
                helper.WX = (int)Float.parseFloat(tokc.nextToken());
            }
        });
        tokenHelper.put("N", new TokenHelper(){

            public void getToken(GlyphHelper helper, StringTokenizer tokc) {
                helper.N = tokc.nextToken();
            }
        });
        tokenHelper.put("B", new TokenHelper(){

            public void getToken(GlyphHelper helper, StringTokenizer tokc) {
                helper.B = new int[]{Integer.parseInt(tokc.nextToken()), Integer.parseInt(tokc.nextToken()), Integer.parseInt(tokc.nextToken()), Integer.parseInt(tokc.nextToken())};
            }
        });
    }

    private class GlyphHelper {
        Integer C = -1;
        Integer WX = 250;
        String N = "";
        int[] B = null;

        private GlyphHelper() {
        }
    }

    private static interface TokenHelper {
        public void getToken(GlyphHelper var1, StringTokenizer var2);
    }

    private static interface FontDealer {
        public boolean dealWith(Type1Font var1, StringTokenizer var2);
    }
}

