/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.forms.fields;

import com.fr.third.fr.pdf.forms.fields.PdfButtonFormField;
import com.fr.third.fr.pdf.forms.fields.PdfChoiceFormField;
import com.fr.third.fr.pdf.forms.fields.PdfSignatureFormField;
import com.fr.third.fr.pdf.forms.fields.PdfTextFormField;
import com.fr.third.fr.pdf.io.codec.Base64;
import com.fr.third.fr.pdf.io.font.PdfEncodings;
import com.fr.third.fr.pdf.io.image.ImageData;
import com.fr.third.fr.pdf.io.image.ImageDataFactory;
import com.fr.third.fr.pdf.io.source.PdfTokenizer;
import com.fr.third.fr.pdf.io.source.RandomAccessFileOrArray;
import com.fr.third.fr.pdf.io.source.RandomAccessSourceFactory;
import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.color.Color;
import com.fr.third.fr.pdf.kernel.color.DeviceCmyk;
import com.fr.third.fr.pdf.kernel.color.DeviceGray;
import com.fr.third.fr.pdf.kernel.color.DeviceRgb;
import com.fr.third.fr.pdf.kernel.font.PdfFont;
import com.fr.third.fr.pdf.kernel.font.PdfFontFactory;
import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.PdfAConformanceLevel;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfIndirectReference;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfObjectWrapper;
import com.fr.third.fr.pdf.kernel.pdf.PdfResources;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.pdf.action.PdfAction;
import com.fr.third.fr.pdf.kernel.pdf.annot.PdfAnnotation;
import com.fr.third.fr.pdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.fr.third.fr.pdf.kernel.pdf.canvas.PdfCanvas;
import com.fr.third.fr.pdf.kernel.pdf.xobject.PdfFormXObject;
import com.fr.third.fr.pdf.kernel.pdf.xobject.PdfImageXObject;
import com.fr.third.fr.pdf.layout.Canvas;
import com.fr.third.fr.pdf.layout.element.Paragraph;
import com.fr.third.fr.pdf.layout.property.TextAlignment;
import com.fr.third.fr.pdf.layout.property.VerticalAlignment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfFormField
extends PdfObjectWrapper<PdfDictionary> {
    public static final int FF_MULTILINE = PdfFormField.makeFieldFlag(13);
    public static final int FF_PASSWORD = PdfFormField.makeFieldFlag(14);
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final int DA_FONT = 0;
    public static final int DA_SIZE = 1;
    public static final int DA_COLOR = 2;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int TYPE_CHECK = 1;
    public static final int TYPE_CIRCLE = 2;
    public static final int TYPE_CROSS = 3;
    public static final int TYPE_DIAMOND = 4;
    public static final int TYPE_SQUARE = 5;
    public static final int TYPE_STAR = 6;
    public static final int HIDDEN = 1;
    public static final int VISIBLE_BUT_DOES_NOT_PRINT = 2;
    public static final int HIDDEN_BUT_PRINTABLE = 3;
    public static final int FF_READ_ONLY = PdfFormField.makeFieldFlag(1);
    public static final int FF_REQUIRED = PdfFormField.makeFieldFlag(2);
    public static final int FF_NO_EXPORT = PdfFormField.makeFieldFlag(3);
    protected static String[] typeChars = new String[]{"4", "l", "8", "u", "n", "H"};
    protected String text;
    protected ImageData img;
    protected PdfFont font;
    protected int fontSize;
    protected Color color;
    protected int checkType;
    protected float borderWidth = 1.0f;
    protected Color backgroundColor;
    protected Color borderColor = Color.BLACK;
    protected int rotation = 0;
    protected PdfFormXObject form;
    protected PdfAConformanceLevel pdfAConformanceLevel;
    protected static final String check = "0.8 0 0 0.8 0.3 0.5 cm 0 0 m\n0.066 -0.026 l\n0.137 -0.15 l\n0.259 0.081 0.46 0.391 0.553 0.461 c\n0.604 0.489 l\n0.703 0.492 l\n0.543 0.312 0.255 -0.205 0.154 -0.439 c\n0.069 -0.399 l\n0.035 -0.293 -0.039 -0.136 -0.091 -0.057 c\nh\nf\n";
    protected static final String circle = "1 0 0 1 0.86 0.5 cm 0 0 m\n0 0.204 -0.166 0.371 -0.371 0.371 c\n-0.575 0.371 -0.741 0.204 -0.741 0 c\n-0.741 -0.204 -0.575 -0.371 -0.371 -0.371 c\n-0.166 -0.371 0 -0.204 0 0 c\nf\n";
    protected static final String cross = "1 0 0 1 0.80 0.8 cm 0 0 m\n-0.172 -0.027 l\n-0.332 -0.184 l\n-0.443 -0.019 l\n-0.475 -0.009 l\n-0.568 -0.168 l\n-0.453 -0.324 l\n-0.58 -0.497 l\n-0.59 -0.641 l\n-0.549 -0.627 l\n-0.543 -0.612 -0.457 -0.519 -0.365 -0.419 c\n-0.163 -0.572 l\n-0.011 -0.536 l\n-0.004 -0.507 l\n-0.117 -0.441 l\n-0.246 -0.294 l\n-0.132 -0.181 l\n0.031 -0.04 l\nh\nf\n";
    protected static final String diamond = "1 0 0 1 0.5 0.12 cm 0 0 m\n0.376 0.376 l\n0 0.751 l\n-0.376 0.376 l\nh\nf\n";
    protected static final String square = "1 0 0 1 0.835 0.835 cm 0 0 -0.669 -0.67 re\nf\n";
    protected static final String star = "0.95 0 0 0.95 0.85 0.6 cm 0 0 m\n-0.291 0 l\n-0.381 0.277 l\n-0.47 0 l\n-0.761 0 l\n-0.526 -0.171 l\n-0.616 -0.448 l\n-0.381 -0.277 l\n-0.145 -0.448 l\n-0.236 -0.171 l\nh\nf\n";

    public PdfFormField(PdfDictionary pdfObject) {
        super(pdfObject);
        PdfFormField.ensureObjectIsAddedToDocument(pdfObject);
        this.setForbidRelease();
    }

    protected PdfFormField(PdfDocument pdfDocument) {
        this(new PdfDictionary().makeIndirect(pdfDocument));
        PdfName formType = this.getFormType();
        if (formType != null) {
            this.put(PdfName.FT, formType);
        }
    }

    protected PdfFormField(PdfWidgetAnnotation widget, PdfDocument pdfDocument) {
        this(new PdfDictionary().makeIndirect(pdfDocument));
        widget.makeIndirect(pdfDocument);
        this.addKid(widget);
        this.put(PdfName.FT, this.getFormType());
    }

    public static int makeFieldFlag(int bitPosition) {
        return 1 << bitPosition - 1;
    }

    public static PdfFormField createEmptyField(PdfDocument doc) {
        return new PdfFormField(doc);
    }

    public static PdfButtonFormField createButton(PdfDocument doc, Rectangle rect, int flags) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfButtonFormField field = new PdfButtonFormField(annot, doc);
        field.setFieldFlags(flags);
        return field;
    }

    public static PdfButtonFormField createButton(PdfDocument doc, int flags) {
        PdfButtonFormField field = new PdfButtonFormField(doc);
        field.setFieldFlags(flags);
        return field;
    }

    public static PdfTextFormField createText(PdfDocument doc) {
        return new PdfTextFormField(doc);
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        return new PdfTextFormField(annot, doc);
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect, String name) {
        return PdfFormField.createText(doc, rect, name, "");
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect, String name, String value) {
        try {
            return PdfFormField.createText(doc, rect, name, value, PdfFontFactory.createFont(), 12);
        }
        catch (Exception e) {
            throw new PdfException(e);
        }
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, int fontSize) {
        return PdfFormField.createText(doc, rect, name, value, font, fontSize, false);
    }

    public static PdfTextFormField createText(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, int fontSize, boolean multiline) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfTextFormField field = new PdfTextFormField(annot, doc);
        field.setMultiline(multiline);
        field.font = font;
        field.fontSize = fontSize;
        field.setValue(value);
        field.setFieldName(name);
        return field;
    }

    public static PdfTextFormField createMultilineText(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, int fontSize) {
        return PdfFormField.createText(doc, rect, name, value, font, fontSize, true);
    }

    public static PdfTextFormField createMultilineText(PdfDocument doc, Rectangle rect, String name, String value) {
        try {
            return PdfFormField.createText(doc, rect, name, value, PdfFontFactory.createFont(), 12, true);
        }
        catch (Exception e) {
            throw new PdfException(e);
        }
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, int flags) {
        PdfChoiceFormField field = new PdfChoiceFormField(doc);
        field.setFieldFlags(flags);
        return field;
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, Rectangle rect, int flags) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfChoiceFormField field = new PdfChoiceFormField(annot, doc);
        field.setFieldFlags(flags);
        return field;
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, Rectangle rect, String name, String value, PdfArray options, int flags) {
        try {
            return PdfFormField.createChoice(doc, rect, name, value, PdfFontFactory.createFont(), 12, options, flags);
        }
        catch (Exception e) {
            throw new PdfException(e);
        }
    }

    public static PdfChoiceFormField createChoice(PdfDocument doc, Rectangle rect, String name, String value, PdfFont font, int fontSize, PdfArray options, int flags) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfChoiceFormField field = new PdfChoiceFormField(annot, doc);
        field.font = font;
        field.fontSize = fontSize;
        field.put(PdfName.Opt, options);
        field.setFieldFlags(flags);
        field.setFieldName(name);
        ((PdfDictionary)field.getPdfObject()).put(PdfName.V, new PdfString(value));
        if ((flags & PdfChoiceFormField.FF_COMBO) == 0) {
            value = super.optionsArrayToString(options);
        }
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, rect.getWidth(), rect.getHeight()));
        field.drawMultiLineTextAppearance(rect, font, fontSize, value, xObject);
        xObject.getResources().addFont(doc, font);
        annot.setNormalAppearance((PdfDictionary)xObject.getPdfObject());
        return field;
    }

    public static PdfSignatureFormField createSignature(PdfDocument doc) {
        return new PdfSignatureFormField(doc);
    }

    public static PdfSignatureFormField createSignature(PdfDocument doc, Rectangle rect) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        return new PdfSignatureFormField(annot, doc);
    }

    public static PdfButtonFormField createRadioGroup(PdfDocument doc, String name, String value) {
        PdfButtonFormField radio = PdfFormField.createButton(doc, PdfButtonFormField.FF_RADIO);
        radio.setFieldName(name);
        radio.put(PdfName.V, new PdfName(value));
        return radio;
    }

    public static PdfFormField createRadioButton(PdfDocument doc, Rectangle rect, PdfButtonFormField radioGroup, String value) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfButtonFormField radio = new PdfButtonFormField(annot, doc);
        String name = radioGroup.getValue().toString().substring(1);
        if (name.equals(value)) {
            annot.setAppearanceState(new PdfName(value));
        } else {
            annot.setAppearanceState(new PdfName("Off"));
        }
        radio.drawRadioAppearance(rect.getWidth(), rect.getHeight(), value);
        radioGroup.addKid(radio);
        return radio;
    }

    public static PdfFormField createRadioButton(PdfDocument doc, Rectangle rect, PdfButtonFormField radioGroup, String value, PdfAConformanceLevel pdfAConformanceLevel) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfButtonFormField radio = new PdfButtonFormField(annot, doc);
        radio.pdfAConformanceLevel = pdfAConformanceLevel;
        annot.setFlag(4);
        String name = radioGroup.getValue().toString().substring(1);
        if (name.equals(value)) {
            annot.setAppearanceState(new PdfName(value));
        } else {
            annot.setAppearanceState(new PdfName("Off"));
        }
        if (pdfAConformanceLevel != null && "1".equals(pdfAConformanceLevel.getPart())) {
            radio.drawPdfA1RadioAppearance(rect.getWidth(), rect.getHeight(), value);
        } else {
            radio.drawRadioAppearance(rect.getWidth(), rect.getHeight(), value);
        }
        radioGroup.addKid(radio);
        return radio;
    }

    public static PdfButtonFormField createPushButton(PdfDocument doc, Rectangle rect, String name, String caption) {
        PdfButtonFormField field;
        try {
            field = PdfFormField.createPushButton(doc, rect, name, caption, PdfFontFactory.createFont(), 12);
        }
        catch (Exception e) {
            throw new PdfException(e);
        }
        return field;
    }

    public static PdfButtonFormField createPushButton(PdfDocument doc, Rectangle rect, String name, String caption, PdfFont font, int fontSize) {
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfButtonFormField field = new PdfButtonFormField(annot, doc);
        field.setPushButton(true);
        field.setFieldName(name);
        field.text = caption;
        field.font = font;
        field.fontSize = fontSize;
        PdfFormXObject xObject = field.drawPushButtonAppearance(rect.getWidth(), rect.getHeight(), caption, font, fontSize);
        annot.setNormalAppearance((PdfDictionary)xObject.getPdfObject());
        PdfDictionary mk = new PdfDictionary();
        mk.put(PdfName.CA, new PdfString(caption));
        mk.put(PdfName.BG, new PdfArray(field.backgroundColor.getColorValue()));
        annot.setAppearanceCharacteristics(mk);
        return field;
    }

    public static PdfButtonFormField createCheckBox(PdfDocument doc, Rectangle rect, String name, String value) {
        return PdfFormField.createCheckBox(doc, rect, name, value, 3);
    }

    public static PdfButtonFormField createCheckBox(PdfDocument doc, Rectangle rect, String name, String value, int checkType) {
        return PdfFormField.createCheckBox(doc, rect, name, value, checkType, null);
    }

    public static PdfButtonFormField createCheckBox(PdfDocument doc, Rectangle rect, String name, String value, int checkType, PdfAConformanceLevel pdfAConformanceLevel) {
        String pdfAVersion;
        PdfWidgetAnnotation annot = new PdfWidgetAnnotation(rect);
        PdfButtonFormField check = new PdfButtonFormField(annot, doc);
        check.pdfAConformanceLevel = pdfAConformanceLevel;
        annot.setFlag(4);
        check.setCheckType(checkType);
        check.setFieldName(name);
        check.put(PdfName.V, new PdfName(value));
        annot.setAppearanceState(new PdfName(value));
        String string = pdfAVersion = pdfAConformanceLevel != null ? pdfAConformanceLevel.getPart() : "";
        if ("1".equals(pdfAVersion)) {
            check.drawPdfA1CheckAppearance(rect.getWidth(), rect.getHeight(), value.equals("Off") ? "Yes" : value, checkType);
        } else if ("2".equals(pdfAVersion)) {
            check.drawPdfA2CheckAppearance(rect.getWidth(), rect.getHeight(), value.equals("Off") ? "Yes" : value, checkType);
        } else if ("3".equals(pdfAVersion)) {
            check.drawPdfA2CheckAppearance(rect.getWidth(), rect.getHeight(), value.equals("Off") ? "Yes" : value, checkType);
        } else {
            check.drawCheckAppearance(rect.getWidth(), rect.getHeight(), value.equals("Off") ? "Yes" : value);
        }
        return check;
    }

    public static PdfChoiceFormField createComboBox(PdfDocument doc, Rectangle rect, String name, String value, String[][] options) {
        return PdfFormField.createChoice(doc, rect, name, value, PdfFormField.processOptions(options), PdfChoiceFormField.FF_COMBO);
    }

    public static PdfChoiceFormField createComboBox(PdfDocument doc, Rectangle rect, String name, String value, String[] options) {
        return PdfFormField.createChoice(doc, rect, name, value, PdfFormField.processOptions(options), PdfChoiceFormField.FF_COMBO);
    }

    public static PdfChoiceFormField createList(PdfDocument doc, Rectangle rect, String name, String value, String[][] options) {
        return PdfFormField.createChoice(doc, rect, name, value, PdfFormField.processOptions(options), 0);
    }

    public static PdfChoiceFormField createList(PdfDocument doc, Rectangle rect, String name, String value, String[] options) {
        return PdfFormField.createChoice(doc, rect, name, value, PdfFormField.processOptions(options), 0);
    }

    public static PdfFormField makeFormField(PdfObject pdfObject, PdfDocument document) {
        PdfObjectWrapper field = null;
        if (pdfObject.isIndirectReference()) {
            pdfObject = ((PdfIndirectReference)pdfObject).getRefersTo();
        }
        if (pdfObject.isDictionary()) {
            PdfDictionary dictionary = (PdfDictionary)pdfObject;
            PdfName formType = dictionary.getAsName(PdfName.FT);
            field = PdfName.Tx.equals(formType) ? new PdfTextFormField(dictionary) : (PdfName.Btn.equals(formType) ? new PdfButtonFormField(dictionary) : (PdfName.Ch.equals(formType) ? new PdfChoiceFormField(dictionary) : (PdfName.Sig.equals(formType) ? new PdfSignatureFormField(dictionary) : new PdfFormField(dictionary))));
        }
        if (field != null) {
            field.makeIndirect(document);
            if (document != null && document.getReader() != null && document.getReader().getPdfAConformanceLevel() != null) {
                ((PdfFormField)field).pdfAConformanceLevel = document.getReader().getPdfAConformanceLevel();
            }
        }
        return field;
    }

    public PdfName getFormType() {
        return this.getTypeFromParent((PdfDictionary)this.getPdfObject());
    }

    public PdfFormField setValue(String value) {
        PdfArray kids;
        PdfName ft = this.getFormType();
        if (!(ft != null && ft.equals(PdfName.Btn) || (kids = this.getKids()) == null)) {
            for (int i = 0; i < kids.size(); ++i) {
                PdfObject kid = kids.get(i);
                if (kid.isIndirectReference()) {
                    kid = ((PdfIndirectReference)kid).getRefersTo();
                }
                PdfFormField field = new PdfFormField((PdfDictionary)kid);
                field.font = this.font;
                field.fontSize = this.fontSize;
                field.setValue(value);
            }
        }
        return this.setValue(value, true);
    }

    public PdfFormField setValue(String value, boolean generateAppearance) {
        PdfName formType = this.getFormType();
        if (PdfName.Tx.equals(formType) || PdfName.Ch.equals(formType)) {
            this.put(PdfName.V, new PdfString(value, "UnicodeBig"));
        } else if (PdfName.Btn.equals(formType)) {
            if ((this.getFieldFlags() & PdfButtonFormField.FF_PUSH_BUTTON) != 0) {
                try {
                    this.img = ImageDataFactory.create(Base64.decode(value));
                }
                catch (Exception e) {
                    this.text = value;
                }
            } else {
                this.put(PdfName.V, new PdfName(value));
                for (String as : this.getAppearanceStates()) {
                    if (!as.equals(value)) continue;
                    this.put(PdfName.AS, new PdfName(value));
                    break;
                }
            }
        } else {
            this.put(PdfName.V, new PdfString(value, "UnicodeBig"));
        }
        if (PdfName.Btn.equals(formType) && (this.getFieldFlags() & PdfButtonFormField.FF_PUSH_BUTTON) == 0) {
            if (generateAppearance) {
                this.regenerateField();
            }
        } else {
            this.regenerateField();
        }
        return this;
    }

    public PdfFormField setValue(String value, PdfFont font, int fontSize) {
        PdfName formType = this.getFormType();
        if (!formType.equals(PdfName.Tx) && !formType.equals(PdfName.Ch)) {
            return this.setValue(value);
        }
        PdfArray bBox = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Rect);
        if (bBox == null) {
            PdfArray kids = this.getKids();
            if (kids == null) {
                throw new PdfException("wrong.form.field.add.annotation.to.the.field");
            }
            bBox = ((PdfDictionary)kids.get(0)).getAsArray(PdfName.Rect);
        }
        PdfFormXObject appearance = new PdfFormXObject(new Rectangle(0.0f, 0.0f, bBox.toRectangle().getWidth(), bBox.toRectangle().getHeight()));
        if (formType.equals(PdfName.Tx)) {
            this.drawTextAppearance(bBox.toRectangle(), font, fontSize, value, appearance);
        } else {
            this.drawMultiLineTextAppearance(bBox.toRectangle(), font, fontSize, value, appearance);
        }
        appearance.getResources().addFont(this.getDocument(), font);
        PdfDictionary ap = new PdfDictionary();
        ap.put(PdfName.N, (PdfObject)appearance.getPdfObject());
        ((PdfDictionary)this.getPdfObject()).put(PdfName.V, new PdfString(value, "UnicodeBig"));
        return this.put(PdfName.AP, ap);
    }

    public PdfFormField setValue(String value, String display) {
        if (display == null) {
            return this.setValue(value);
        }
        this.setValue(display, true);
        PdfName formType = this.getFormType();
        if (PdfName.Tx.equals(formType) || PdfName.Ch.equals(formType)) {
            this.put(PdfName.V, new PdfString(value, "UnicodeBig"));
        } else if (PdfName.Btn.equals(formType)) {
            if ((this.getFieldFlags() & PdfButtonFormField.FF_PUSH_BUTTON) != 0) {
                this.text = value;
            } else {
                this.put(PdfName.V, new PdfName(value));
            }
        } else {
            this.put(PdfName.V, new PdfString(value, "UnicodeBig"));
        }
        return this;
    }

    public PdfFormField setParent(PdfFormField parent) {
        return this.put(PdfName.Parent, (PdfObject)parent.getPdfObject());
    }

    public PdfDictionary getParent() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Parent);
    }

    public PdfArray getKids() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Kids);
    }

    public PdfFormField addKid(PdfFormField kid) {
        kid.setParent(this);
        PdfArray kids = this.getKids();
        if (kids == null) {
            kids = new PdfArray();
        }
        kids.add((PdfObject)kid.getPdfObject());
        return this.put(PdfName.Kids, kids);
    }

    public PdfFormField addKid(PdfWidgetAnnotation kid) {
        kid.setParent((PdfObject)this.getPdfObject());
        PdfArray kids = this.getKids();
        if (kids == null) {
            kids = new PdfArray();
        }
        kids.add((PdfObject)kid.getPdfObject());
        return this.put(PdfName.Kids, kids);
    }

    public PdfFormField setFieldName(String name) {
        return this.put(PdfName.T, new PdfString(name));
    }

    public PdfString getFieldName() {
        PdfString name;
        PdfFormField parentField;
        PdfString pName;
        String parentName = "";
        PdfDictionary parent = this.getParent();
        if (parent != null && (pName = (parentField = PdfFormField.makeFormField(this.getParent(), this.getDocument())).getFieldName()) != null) {
            parentName = pName.toUnicodeString() + ".";
        }
        if ((name = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.T)) != null) {
            name = new PdfString(parentName + name.toUnicodeString());
        }
        return name;
    }

    public PdfFormField setAlternativeName(String name) {
        return this.put(PdfName.TU, new PdfString(name));
    }

    public PdfString getAlternativeName() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.TU);
    }

    public PdfFormField setMappingName(String name) {
        return this.put(PdfName.TM, new PdfString(name));
    }

    public PdfString getMappingName() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.TM);
    }

    public boolean getFieldFlag(int flag) {
        return (this.getFieldFlags() & flag) != 0;
    }

    public PdfFormField setFieldFlag(int flag) {
        return this.setFieldFlag(flag, true);
    }

    public PdfFormField setFieldFlag(int flag, boolean value) {
        int flags = this.getFieldFlags();
        flags = value ? (flags |= flag) : (flags &= ~flag);
        return this.setFieldFlags(flags);
    }

    public boolean isMultiline() {
        return this.getFieldFlag(FF_MULTILINE);
    }

    public boolean isPassword() {
        return this.getFieldFlag(FF_PASSWORD);
    }

    public PdfFormField setFieldFlags(int flags) {
        return this.put(PdfName.Ff, new PdfNumber(flags));
    }

    public int getFieldFlags() {
        PdfNumber f = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.Ff);
        if (f != null) {
            return f.intValue();
        }
        PdfDictionary parent = this.getParent();
        if (parent != null) {
            return new PdfFormField(parent).getFieldFlags();
        }
        return 0;
    }

    public PdfObject getValue() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.V);
    }

    public String getValueAsString() {
        PdfObject value = ((PdfDictionary)this.getPdfObject()).get(PdfName.V);
        if (value == null) {
            return "";
        }
        if (value instanceof PdfStream) {
            return new String(((PdfStream)value).getBytes());
        }
        if (value instanceof PdfName) {
            return ((PdfName)value).getValue();
        }
        if (value instanceof PdfString) {
            return ((PdfString)value).toUnicodeString();
        }
        return "";
    }

    public PdfFormField setDefaultValue(PdfObject value) {
        return this.put(PdfName.DV, value);
    }

    public PdfObject getDefaultValue() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.DV);
    }

    public PdfFormField setAdditionalAction(PdfName key, PdfAction action) {
        PdfAction.setAdditionalAction(this, key, action);
        return this;
    }

    public PdfDictionary getAdditionalAction() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.AA);
    }

    public PdfFormField setOptions(PdfArray options) {
        return this.put(PdfName.Opt, options);
    }

    public PdfArray getOptions() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Opt);
    }

    public List<PdfWidgetAnnotation> getWidgets() {
        PdfArray kids;
        ArrayList<PdfWidgetAnnotation> widgets = new ArrayList<PdfWidgetAnnotation>();
        PdfName subType = ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.Subtype);
        if (subType != null && subType.equals(PdfName.Widget)) {
            widgets.add((PdfWidgetAnnotation)PdfAnnotation.makeAnnotation(this.getPdfObject()));
        }
        if ((kids = this.getKids()) != null) {
            for (int i = 0; i < kids.size(); ++i) {
                PdfObject kid = kids.get(i);
                if (kid.isIndirectReference()) {
                    kid = ((PdfIndirectReference)kid).getRefersTo();
                }
                if ((subType = ((PdfDictionary)kid).getAsName(PdfName.Subtype)) == null || !subType.equals(PdfName.Widget)) continue;
                widgets.add((PdfWidgetAnnotation)PdfAnnotation.makeAnnotation(kid));
            }
        }
        return widgets;
    }

    public PdfString getDefaultAppearance() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.DA);
    }

    public PdfFormField setDefaultAppearance(String defaultAppearance) {
        byte[] b = defaultAppearance.getBytes();
        int len = b.length;
        for (int k = 0; k < len; ++k) {
            if (b[k] != 10) continue;
            b[k] = 32;
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.DA, new PdfString(new String(b)));
        return this;
    }

    public Integer getJustification() {
        return ((PdfDictionary)this.getPdfObject()).getAsInt(PdfName.Q);
    }

    public PdfFormField setJustification(int justification) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Q, new PdfNumber(justification));
        this.regenerateField();
        return this;
    }

    public PdfString getDefaultStyle() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.DS);
    }

    public PdfFormField setDefaultStyle(PdfString defaultStyleString) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.DS, defaultStyleString);
        return this;
    }

    public PdfObject getRichText() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.RV);
    }

    public PdfFormField setRichText(PdfObject richText) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.RV, richText);
        return this;
    }

    public PdfFont getFont() {
        return this.font;
    }

    public void setFont(PdfFont font) {
        this.font = font;
        this.regenerateField();
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.regenerateField();
    }

    public void setFontAndSize(PdfFont font, int fontSize) {
        this.font = font;
        this.fontSize = fontSize;
        this.regenerateField();
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        PdfDictionary mk = this.getWidgets().get(0).getAppearanceCharacteristics();
        if (mk == null) {
            mk = new PdfDictionary();
        }
        mk.put(PdfName.BG, new PdfArray(backgroundColor.getColorValue()));
        this.regenerateField();
    }

    public void setRotation(int degRotation) {
        if (degRotation % 90 != 0) {
            throw new IllegalArgumentException("degRotation.must.be.a.multiple.of.90");
        }
        if ((degRotation %= 360) < 0) {
            degRotation += 360;
        }
        this.rotation = degRotation;
        PdfDictionary mk = this.getWidgets().get(0).getAppearanceCharacteristics();
        if (mk == null) {
            mk = new PdfDictionary();
        }
        mk.put(PdfName.R, new PdfNumber(degRotation));
        this.rotation = degRotation;
        this.regenerateField();
    }

    public PdfFormField setAction(PdfAction action) {
        List<PdfWidgetAnnotation> widgets = this.getWidgets();
        if (widgets != null) {
            for (PdfWidgetAnnotation widget : widgets) {
                widget.setAction(action);
            }
        }
        return this;
    }

    public void setCheckType(int checkType) {
        if (checkType < 1 || checkType > 6) {
            checkType = 3;
        }
        this.checkType = checkType;
        this.text = typeChars[checkType - 1];
        if (this.pdfAConformanceLevel != null) {
            return;
        }
        try {
            this.font = PdfFontFactory.createFont("ZapfDingbats");
        }
        catch (Exception e) {
            throw new PdfException(e);
        }
    }

    public PdfFormField setVisibility(int visibility) {
        switch (visibility) {
            case 1: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.F, new PdfNumber(6));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.F, new PdfNumber(36));
                break;
            }
            default: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.F, new PdfNumber(4));
            }
        }
        return this;
    }

    public boolean regenerateField() {
        PdfName type = this.getFormType();
        String value = this.getValueAsString();
        if (PdfName.Tx.equals(type) || PdfName.Ch.equals(type)) {
            try {
                PdfArray bBox;
                PdfDictionary apDic = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.AP);
                PdfStream asNormal = null;
                if (apDic != null) {
                    asNormal = apDic.getAsStream(PdfName.N);
                }
                if ((bBox = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Rect)) == null) {
                    PdfArray kids = this.getKids();
                    if (kids == null) {
                        throw new PdfException("wrong.form.field.add.annotation.to.the.field");
                    }
                    bBox = ((PdfDictionary)kids.get(0)).getAsArray(PdfName.Rect);
                }
                Object[] fontAndSize = this.getFontAndSize(asNormal);
                PdfFont localFont = (PdfFont)fontAndSize[0];
                int fontSz = (Integer)fontAndSize[1];
                if (fontSz == 0) {
                    fontSz = 12;
                }
                PdfFormXObject appearance = null;
                if (asNormal != null) {
                    appearance = new PdfFormXObject(asNormal);
                    appearance.setBBox(new PdfArray(new float[]{0.0f, 0.0f, bBox.toRectangle().getWidth(), bBox.toRectangle().getHeight()}));
                }
                if (appearance == null) {
                    appearance = new PdfFormXObject(new Rectangle(0.0f, 0.0f, bBox.toRectangle().getWidth(), bBox.toRectangle().getHeight()));
                }
                if (PdfName.Tx.equals(type)) {
                    if (!this.isMultiline()) {
                        this.drawTextAppearance(bBox.toRectangle(), localFont, fontSz, value, appearance);
                    } else {
                        this.drawMultiLineTextAppearance(bBox.toRectangle(), localFont, fontSz, value, appearance);
                    }
                } else {
                    if (!this.getFieldFlag(PdfChoiceFormField.FF_COMBO)) {
                        PdfNumber topIndex = ((PdfChoiceFormField)this).getTopIndex();
                        PdfArray options = (PdfArray)this.getOptions().clone();
                        if (topIndex != null) {
                            PdfObject object = options.get(topIndex.intValue());
                            options.remove(topIndex.intValue());
                            options.add(0, object);
                        }
                        value = this.optionsArrayToString(options);
                    }
                    this.drawMultiLineTextAppearance(bBox.toRectangle(), localFont, fontSz, value, appearance);
                }
                appearance.getResources().addFont(this.getDocument(), localFont);
                PdfDictionary ap = new PdfDictionary();
                ap.put(PdfName.N, (PdfObject)appearance.getPdfObject());
                this.put(PdfName.AP, ap);
                return true;
            }
            catch (Exception e) {
                throw new PdfException(e);
            }
        }
        if (PdfName.Btn.equals(type)) {
            int ff = this.getFieldFlags();
            if ((ff & PdfButtonFormField.FF_PUSH_BUTTON) != 0) {
                try {
                    PdfFormXObject appearance;
                    List<PdfWidgetAnnotation> widgets;
                    value = this.text;
                    Rectangle rect = this.getRect((PdfDictionary)this.getPdfObject());
                    PdfDictionary apDic = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.AP);
                    if (apDic == null && (widgets = this.getWidgets()).size() == 1) {
                        apDic = ((PdfDictionary)widgets.get(0).getPdfObject()).getAsDictionary(PdfName.AP);
                    }
                    if (this.img != null) {
                        appearance = this.drawPushButtonAppearance(rect.getWidth(), rect.getHeight(), value, null, 0);
                    } else if (this.form != null) {
                        appearance = this.drawPushButtonAppearance(rect.getWidth(), rect.getHeight(), value, null, 0);
                    } else {
                        PdfStream asNormal = null;
                        if (apDic != null) {
                            asNormal = apDic.getAsStream(PdfName.N);
                        }
                        Object[] fontAndSize = this.getFontAndSize(asNormal);
                        PdfFont localFont = (PdfFont)fontAndSize[0];
                        int fontSz = (Integer)fontAndSize[1];
                        appearance = this.drawPushButtonAppearance(rect.getWidth(), rect.getHeight(), value, localFont, fontSz);
                        appearance.getResources().addFont(this.getDocument(), localFont);
                    }
                    if (apDic == null) {
                        apDic = new PdfDictionary();
                        this.put(PdfName.AP, apDic);
                    }
                    apDic.put(PdfName.N, (PdfObject)appearance.getPdfObject());
                }
                catch (Exception e) {
                    throw new PdfException(e);
                }
            } else if ((ff & PdfButtonFormField.FF_RADIO) != 0) {
                PdfArray kids = this.getKids();
                for (int i = 0; i < kids.size(); ++i) {
                    PdfObject kid = kids.get(i);
                    if (kid.isIndirectReference()) {
                        kid = ((PdfIndirectReference)kid).getRefersTo();
                    }
                    PdfFormField field = new PdfFormField((PdfDictionary)kid);
                    PdfWidgetAnnotation widget = field.getWidgets().get(0);
                    PdfDictionary buttonValues = ((PdfDictionary)field.getPdfObject()).getAsDictionary(PdfName.AP).getAsDictionary(PdfName.N);
                    String state = buttonValues.get(new PdfName(value)) != null ? value : "Off";
                    widget.setAppearanceState(new PdfName(state));
                }
            } else {
                String pdfAVersion;
                Rectangle rect = this.getRect((PdfDictionary)this.getPdfObject());
                this.setCheckType(this.checkType);
                String string = pdfAVersion = this.pdfAConformanceLevel != null ? this.pdfAConformanceLevel.getPart() : "";
                if ("1".equals(pdfAVersion)) {
                    this.drawPdfA1CheckAppearance(rect.getWidth(), rect.getHeight(), value, this.checkType);
                } else if ("2".equals(pdfAVersion)) {
                    this.drawPdfA2CheckAppearance(rect.getWidth(), rect.getHeight(), value, this.checkType);
                } else if ("3".equals(pdfAVersion)) {
                    this.drawPdfA2CheckAppearance(rect.getWidth(), rect.getHeight(), value, this.checkType);
                } else {
                    this.drawCheckAppearance(rect.getWidth(), rect.getHeight(), value);
                }
                PdfWidgetAnnotation widget = this.getWidgets().get(0);
                if (widget.getNormalAppearanceObject() != null && widget.getNormalAppearanceObject().containsKey(new PdfName(value))) {
                    widget.setAppearanceState(new PdfName(value));
                } else {
                    widget.setAppearanceState(new PdfName("Off"));
                }
            }
        }
        return true;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
    }

    public PdfFormField setBorderColor(Color color) {
        this.borderColor = color;
        PdfDictionary mk = this.getWidgets().get(0).getAppearanceCharacteristics();
        if (mk == null) {
            mk = new PdfDictionary();
        }
        mk.put(PdfName.BC, new PdfArray(color.getColorValue()));
        this.regenerateField();
        return this;
    }

    public PdfFormField setColor(Color color) {
        this.color = color;
        this.regenerateField();
        return this;
    }

    public PdfFormField setReadOnly(boolean readOnly) {
        return this.setFieldFlag(FF_READ_ONLY, readOnly);
    }

    public boolean isReadOnly() {
        return this.getFieldFlag(FF_READ_ONLY);
    }

    public PdfFormField setRequired(boolean required) {
        return this.setFieldFlag(FF_REQUIRED, required);
    }

    public boolean isRequired() {
        return this.getFieldFlag(FF_REQUIRED);
    }

    public PdfFormField setNoExport(boolean noExport) {
        return this.setFieldFlag(FF_NO_EXPORT, noExport);
    }

    public boolean isNoExport() {
        return this.getFieldFlag(FF_NO_EXPORT);
    }

    public PdfFormField setPage(int pageNum) {
        PdfAnnotation annot;
        if (this.getWidgets().size() > 0 && (annot = (PdfAnnotation)this.getWidgets().get(0)) != null) {
            annot.setPage(this.getDocument().getPage(pageNum));
        }
        return this;
    }

    public String[] getAppearanceStates() {
        PdfArray kids;
        HashSet<String> names = new HashSet<String>();
        PdfString stringOpt = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Opt);
        if (stringOpt != null) {
            names.add(stringOpt.toUnicodeString());
        } else {
            PdfArray arrayOpt = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Opt);
            if (arrayOpt != null) {
                for (PdfObject pdfObject : arrayOpt) {
                    PdfString valStr = null;
                    if (pdfObject.isArray()) {
                        valStr = ((PdfArray)pdfObject).getAsString(1);
                    } else if (pdfObject.isString()) {
                        valStr = (PdfString)pdfObject;
                    }
                    if (valStr == null) continue;
                    names.add(valStr.toUnicodeString());
                }
            }
        }
        PdfDictionary dic = (PdfDictionary)this.getPdfObject();
        dic = dic.getAsDictionary(PdfName.AP);
        if (dic != null && (dic = dic.getAsDictionary(PdfName.N)) != null) {
            for (PdfName state : dic.keySet()) {
                names.add(state.getValue());
            }
        }
        if ((kids = this.getKids()) != null) {
            for (PdfObject kid : kids) {
                String[] states;
                PdfDictionary kidDic = kid.isIndirectReference() ? (PdfDictionary)((PdfIndirectReference)kid).getRefersTo() : (PdfDictionary)kid;
                PdfFormField fld = new PdfFormField(kidDic);
                for (String state : states = fld.getAppearanceStates()) {
                    names.add(state);
                }
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public PdfFormField setAppearance(PdfName appearanceType, String appearanceState, PdfStream appearanceStream) {
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        PdfDictionary dic = widget != null ? (PdfDictionary)widget.getPdfObject() : (PdfDictionary)this.getPdfObject();
        PdfDictionary ap = dic.getAsDictionary(PdfName.AP);
        if (ap != null) {
            PdfDictionary appearanceDictionary = ap.getAsDictionary(appearanceType);
            if (appearanceDictionary == null) {
                ap.put(appearanceType, appearanceStream);
            } else {
                appearanceDictionary.put(new PdfName(appearanceState), appearanceStream);
            }
        }
        return this;
    }

    public PdfFormField put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        return this;
    }

    public void release() {
        this.unsetForbidRelease();
        ((PdfDictionary)this.getPdfObject()).release();
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected PdfDocument getDocument() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
    }

    protected Rectangle getRect(PdfDictionary field) {
        PdfArray rect = field.getAsArray(PdfName.Rect);
        if (rect == null) {
            PdfArray kids = field.getAsArray(PdfName.Kids);
            if (kids == null) {
                throw new PdfException("wrong.form.field.add.annotation.to.the.field");
            }
            rect = ((PdfDictionary)kids.get(0)).getAsArray(PdfName.Rect);
        }
        return rect.toRectangle();
    }

    protected static PdfArray processOptions(String[][] options) {
        PdfArray array = new PdfArray();
        for (String[] option : options) {
            PdfArray subArray = new PdfArray(new PdfString(option[0]));
            subArray.add(new PdfString(option[1]));
            array.add(subArray);
        }
        return array;
    }

    protected static PdfArray processOptions(String[] options) {
        PdfArray array = new PdfArray();
        for (String option : options) {
            array.add(new PdfString(option));
        }
        return array;
    }

    protected String generateDefaultAppearanceString(PdfFont font, int fontSize, PdfResources res) {
        PdfStream stream = new PdfStream();
        PdfCanvas canvas = new PdfCanvas(stream, res, this.getDocument());
        canvas.setFontAndSize(font, fontSize).resetFillColorRgb();
        return new String(stream.getBytes());
    }

    protected Object[] getFontAndSize(PdfDictionary asNormal) throws Exception {
        Object[] fontAndSize = new Object[2];
        PdfDictionary resources = null;
        if (asNormal != null) {
            resources = asNormal.getAsDictionary(PdfName.Resources);
        }
        if (resources != null) {
            PdfDictionary fontDic = resources.getAsDictionary(PdfName.Font);
            if (fontDic != null) {
                String str = this.getDefaultAppearance().toUnicodeString();
                Object[] dab = PdfFormField.splitDAelements(str);
                PdfName fontName = new PdfName(dab[0].toString());
                fontAndSize[0] = this.font != null ? this.font : PdfFontFactory.createFont(fontDic.getAsDictionary(fontName));
                fontAndSize[1] = this.fontSize != 0 ? Integer.valueOf(this.fontSize) : dab[1];
                if (this.color == null) {
                    this.color = (Color)dab[2];
                }
            } else {
                fontAndSize[0] = this.font != null ? this.font : PdfFontFactory.createFont();
                fontAndSize[1] = this.fontSize != 0 ? Integer.valueOf(this.fontSize) : Integer.valueOf(12);
            }
        } else {
            fontAndSize[0] = this.font != null ? this.font : PdfFontFactory.createFont();
            fontAndSize[1] = this.fontSize != 0 ? Integer.valueOf(this.fontSize) : Integer.valueOf(12);
        }
        return fontAndSize;
    }

    protected static Object[] splitDAelements(String da) {
        PdfTokenizer tk = new PdfTokenizer(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(PdfEncodings.convertToBytes(da, null))));
        ArrayList<String> stack = new ArrayList<String>();
        Object[] ret = new Object[3];
        try {
            while (tk.nextToken()) {
                if (tk.getTokenType() == PdfTokenizer.TokenType.Comment) continue;
                if (tk.getTokenType() == PdfTokenizer.TokenType.Other) {
                    String operator2 = tk.getStringValue();
                    if (operator2.equals("Tf")) {
                        if (stack.size() >= 2) {
                            ret[0] = stack.get(stack.size() - 2);
                            ret[1] = new Integer((String)stack.get(stack.size() - 1));
                        }
                    } else if (operator2.equals("g")) {
                        float gray;
                        if (stack.size() >= 1 && (gray = new Float((String)stack.get(stack.size() - 1)).floatValue()) != 0.0f) {
                            ret[2] = new DeviceGray(gray);
                        }
                    } else if (operator2.equals("rg")) {
                        if (stack.size() >= 3) {
                            float red = new Float((String)stack.get(stack.size() - 3)).floatValue();
                            float green = new Float((String)stack.get(stack.size() - 2)).floatValue();
                            float blue = new Float((String)stack.get(stack.size() - 1)).floatValue();
                            ret[2] = new DeviceRgb(red, green, blue);
                        }
                    } else if (operator2.equals("k") && stack.size() >= 4) {
                        float cyan = new Float((String)stack.get(stack.size() - 4)).floatValue();
                        float magenta = new Float((String)stack.get(stack.size() - 3)).floatValue();
                        float yellow = new Float((String)stack.get(stack.size() - 2)).floatValue();
                        float black = new Float((String)stack.get(stack.size() - 1)).floatValue();
                        ret[2] = new DeviceCmyk(cyan, magenta, yellow, black);
                    }
                    stack.clear();
                    continue;
                }
                stack.add(tk.getStringValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    protected void drawTextAppearance(Rectangle rect, PdfFont font, int fontSize, String value, PdfFormXObject appearance) {
        Integer justification;
        PdfStream stream = new PdfStream().makeIndirect(this.getDocument());
        PdfResources resources = appearance.getResources();
        PdfCanvas canvas = new PdfCanvas(stream, resources, this.getDocument());
        this.setDefaultAppearance(this.generateDefaultAppearanceString(font, fontSize, resources));
        float height = rect.getHeight();
        float width = rect.getWidth();
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, width, height));
        this.drawBorder(canvas, xObject, width, height);
        if (this.isPassword()) {
            value = this.obfuscatePassword(value);
        }
        canvas.beginVariableText().saveState().newPath();
        Paragraph paragraph = (Paragraph)((Paragraph)((Paragraph)new Paragraph(value).setFont(font)).setFontSize(fontSize)).setMultipliedLeading(1.0f).setPaddings(0.0f, 2.0f, 0.0f, 2.0f);
        if (this.color != null) {
            paragraph.setFontColor(this.color);
        }
        if ((justification = this.getJustification()) == null) {
            justification = 0;
        }
        float x = 0.0f;
        TextAlignment textAlignment = TextAlignment.LEFT;
        if (justification == 2) {
            textAlignment = TextAlignment.RIGHT;
            x = rect.getWidth();
        } else if (justification == 1) {
            textAlignment = TextAlignment.CENTER;
            x = rect.getWidth() / 2.0f;
        }
        new Canvas(canvas, this.getDocument(), new Rectangle(0.0f, -height, 0.0f, 2.0f * height)).showTextAligned(paragraph, x, rect.getHeight() / 2.0f, textAlignment, VerticalAlignment.MIDDLE);
        canvas.restoreState().endVariableText();
        ((PdfStream)appearance.getPdfObject()).setData(stream.getBytes());
    }

    protected void drawMultiLineTextAppearance(Rectangle rect, PdfFont font, int fontSize, String value, PdfFormXObject appearance) {
        Boolean isFull;
        PdfStream stream = new PdfStream().makeIndirect(this.getDocument());
        PdfResources resources = appearance.getResources();
        PdfCanvas canvas = new PdfCanvas(stream, resources, this.getDocument());
        this.setDefaultAppearance(this.generateDefaultAppearanceString(font, fontSize, resources));
        float width = rect.getWidth();
        float height = rect.getHeight();
        List<String> strings = font.splitString(value, fontSize, width - 6.0f);
        this.drawBorder(canvas, appearance, width, height);
        canvas.beginVariableText().saveState().rectangle(3.0, 3.0, width - 6.0f, height - 6.0f).clip().newPath();
        Canvas modelCanvas = new Canvas(canvas, this.getDocument(), new Rectangle(3.0f, 0.0f, Math.max(0.0f, width - 6.0f), Math.max(0.0f, height - 2.0f)));
        for (int index = 0; !(index >= strings.size() || (isFull = modelCanvas.getRenderer().getPropertyAsBoolean(25)) != null && isFull.booleanValue()); ++index) {
            PdfArray indices;
            Paragraph paragraph = ((Paragraph)((Paragraph)((Paragraph)new Paragraph(strings.get(index)).setFont(font)).setFontSize(fontSize)).setMargins(0.0f, 0.0f, 0.0f, 0.0f)).setMultipliedLeading(1.0f);
            paragraph.setProperty(26, true);
            if (this.color != null) {
                paragraph.setFontColor(this.color);
            }
            if ((indices = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.I)) != null && indices.size() > 0) {
                for (PdfObject ind : indices) {
                    if (!ind.isNumber() || ((PdfNumber)ind).getValue() != (double)index) continue;
                    paragraph.setBackgroundColor(new DeviceRgb(10, 36, 106));
                    paragraph.setFontColor(Color.LIGHT_GRAY);
                }
            }
            modelCanvas.add(paragraph);
        }
        canvas.restoreState().endVariableText();
        ((PdfStream)appearance.getPdfObject()).setData(stream.getBytes());
    }

    protected void drawBorder(PdfCanvas canvas, PdfFormXObject xObject, float width, float height) {
        canvas.saveState();
        if (this.borderWidth < 0.0f) {
            this.borderWidth = 0.0f;
        }
        if (this.borderColor == null) {
            this.borderColor = Color.BLACK;
        }
        if (this.backgroundColor != null) {
            canvas.setFillColor(this.backgroundColor).rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, width - this.borderWidth, height - this.borderWidth).fill();
        }
        if (this.borderWidth > 0.0f) {
            this.borderWidth = Math.max(1.0f, this.borderWidth);
            canvas.setStrokeColor(this.borderColor).setLineWidth(this.borderWidth).rectangle(0.0, 0.0, width, height).stroke();
        }
        this.applyRotation(xObject, height, width);
        canvas.restoreState();
    }

    protected void drawRadioAppearance(float width, float height, String value) {
        PdfStream streamOn = new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOn = new PdfCanvas(streamOn, new PdfResources(), this.getDocument());
        Rectangle rect = new Rectangle(0.0f, 0.0f, width, height);
        PdfFormXObject xObjectOn = new PdfFormXObject(rect);
        PdfFormXObject xObjectOff = new PdfFormXObject(rect);
        this.drawBorder(canvasOn, xObjectOn, width, height);
        this.drawRadioField(canvasOn, width, height, true);
        PdfStream streamOff = new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOff = new PdfCanvas(streamOff, new PdfResources(), this.getDocument());
        this.drawBorder(canvasOff, xObjectOff, width, height);
        if (this.pdfAConformanceLevel != null && (this.pdfAConformanceLevel.getPart().equals("2") || this.pdfAConformanceLevel.getPart().equals("3"))) {
            xObjectOn.getResources();
            xObjectOff.getResources();
        }
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        ((PdfStream)xObjectOn.getPdfObject()).getOutputStream().writeBytes(streamOn.getBytes());
        widget.setNormalAppearance(new PdfDictionary());
        widget.getNormalAppearanceObject().put(new PdfName(value), (PdfObject)xObjectOn.getPdfObject());
        ((PdfStream)xObjectOff.getPdfObject()).getOutputStream().writeBytes(streamOff.getBytes());
        widget.getNormalAppearanceObject().put(new PdfName("Off"), (PdfObject)xObjectOff.getPdfObject());
    }

    protected void drawPdfA1RadioAppearance(float width, float height, String value) {
        PdfStream stream = new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvas = new PdfCanvas(stream, new PdfResources(), this.getDocument());
        Rectangle rect = new Rectangle(0.0f, 0.0f, width, height);
        PdfFormXObject xObject = new PdfFormXObject(rect);
        this.drawBorder(canvas, xObject, width, height);
        this.drawRadioField(canvas, rect.getWidth(), rect.getHeight(), !value.equals("Off"));
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        ((PdfStream)xObject.getPdfObject()).getOutputStream().writeBytes(stream.getBytes());
        widget.setNormalAppearance((PdfDictionary)xObject.getPdfObject());
    }

    protected void drawRadioField(PdfCanvas canvas, float width, float height, boolean on) {
        canvas.saveState();
        if (on) {
            canvas.resetFillColorRgb().circle(width / 2.0f, height / 2.0f, Math.min(width, height) / 4.0f).fill();
        }
        canvas.restoreState();
    }

    protected void drawCheckAppearance(float width, float height, String value) {
        PdfStream streamOn = new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOn = new PdfCanvas(streamOn, new PdfResources(), this.getDocument());
        Rectangle rect = new Rectangle(0.0f, 0.0f, width, height);
        PdfFormXObject xObjectOn = new PdfFormXObject(rect);
        PdfFormXObject xObjectOff = new PdfFormXObject(rect);
        this.drawBorder(canvasOn, xObjectOn, width, height);
        this.drawCheckBox(canvasOn, width, height, 12, true);
        PdfStream streamOff = new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOff = new PdfCanvas(streamOff, new PdfResources(), this.getDocument());
        this.drawBorder(canvasOff, xObjectOff, width, height);
        this.drawCheckBox(canvasOff, width, height, 12, false);
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        ((PdfStream)xObjectOn.getPdfObject()).getOutputStream().writeBytes(streamOn.getBytes());
        xObjectOn.getResources().addFont(this.getDocument(), this.getFont());
        this.setDefaultAppearance(this.generateDefaultAppearanceString(this.font, this.fontSize == 0 ? 12 : this.fontSize, xObjectOn.getResources()));
        ((PdfStream)xObjectOff.getPdfObject()).getOutputStream().writeBytes(streamOff.getBytes());
        xObjectOff.getResources().addFont(this.getDocument(), this.getFont());
        PdfDictionary normalAppearance = new PdfDictionary();
        normalAppearance.put(new PdfName(value), (PdfObject)xObjectOn.getPdfObject());
        normalAppearance.put(new PdfName("Off"), (PdfObject)xObjectOff.getPdfObject());
        PdfDictionary mk = new PdfDictionary();
        mk.put(PdfName.CA, new PdfString(this.text));
        ((PdfDictionary)widget.getPdfObject()).put(PdfName.MK, mk);
        widget.setNormalAppearance(normalAppearance);
    }

    protected void drawPdfA1CheckAppearance(float width, float height, String value, int checkType) {
        PdfStream stream = new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvas = new PdfCanvas(stream, new PdfResources(), this.getDocument());
        Rectangle rect = new Rectangle(0.0f, 0.0f, width, height);
        PdfFormXObject xObject = new PdfFormXObject(rect);
        this.checkType = checkType;
        this.drawBorder(canvas, xObject, width, height);
        this.drawPdfACheckBox(canvas, width, height, true);
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        ((PdfStream)xObject.getPdfObject()).getOutputStream().writeBytes(stream.getBytes());
        PdfDictionary normalAppearance = new PdfDictionary();
        normalAppearance.put(new PdfName(value), (PdfObject)xObject.getPdfObject());
        PdfDictionary mk = new PdfDictionary();
        mk.put(PdfName.CA, new PdfString(this.text));
        widget.put(PdfName.MK, mk);
        widget.setNormalAppearance((PdfDictionary)xObject.getPdfObject());
    }

    protected void drawPdfA2CheckAppearance(float width, float height, String value, int checkType) {
        PdfStream streamOn = new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOn = new PdfCanvas(streamOn, new PdfResources(), this.getDocument());
        PdfStream streamOff = new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvasOff = new PdfCanvas(streamOff, new PdfResources(), this.getDocument());
        Rectangle rect = new Rectangle(0.0f, 0.0f, width, height);
        PdfFormXObject xObjectOn = new PdfFormXObject(rect);
        PdfFormXObject xObjectOff = new PdfFormXObject(rect);
        this.checkType = checkType;
        this.drawBorder(canvasOn, xObjectOn, width, height);
        this.drawPdfACheckBox(canvasOn, width, height, true);
        this.drawBorder(canvasOff, xObjectOff, width, height);
        PdfWidgetAnnotation widget = this.getWidgets().get(0);
        ((PdfStream)xObjectOn.getPdfObject()).getOutputStream().writeBytes(streamOn.getBytes());
        ((PdfStream)xObjectOff.getPdfObject()).getOutputStream().writeBytes(streamOff.getBytes());
        xObjectOn.getResources();
        xObjectOff.getResources();
        PdfDictionary normalAppearance = new PdfDictionary();
        normalAppearance.put(new PdfName(value), (PdfObject)xObjectOn.getPdfObject());
        normalAppearance.put(new PdfName("Off"), (PdfObject)xObjectOff.getPdfObject());
        PdfDictionary mk = new PdfDictionary();
        mk.put(PdfName.CA, new PdfString(this.text));
        widget.put(PdfName.MK, mk);
        widget.setNormalAppearance(normalAppearance);
    }

    protected PdfFormXObject drawPushButtonAppearance(float width, float height, String text, PdfFont font, int fontSize) {
        PdfStream stream = new PdfStream().makeIndirect(this.getDocument());
        PdfCanvas canvas = new PdfCanvas(stream, new PdfResources(), this.getDocument());
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, width, height));
        if (this.backgroundColor == null) {
            this.backgroundColor = Color.LIGHT_GRAY;
        }
        this.drawBorder(canvas, xObject, width, height);
        if (this.img != null) {
            PdfImageXObject imgXObj = new PdfImageXObject(this.img);
            canvas.addXObject(imgXObj, width - this.borderWidth, 0.0f, 0.0f, height - this.borderWidth, this.borderWidth / 2.0f, this.borderWidth / 2.0f);
            xObject.getResources().addImage(imgXObj);
        } else if (this.form != null) {
            canvas.addXObject(this.form, (height - this.borderWidth) / this.form.getHeight(), 0.0f, 0.0f, (height - this.borderWidth) / this.form.getHeight(), this.borderWidth / 2.0f, this.borderWidth / 2.0f);
            xObject.getResources().addForm(this.form);
        } else {
            this.drawButton(canvas, 0.0f, 0.0f, width, height, text, font, fontSize);
            this.setDefaultAppearance(this.generateDefaultAppearanceString(font, fontSize, new PdfResources()));
            xObject.getResources().addFont(this.getDocument(), font);
        }
        ((PdfStream)xObject.getPdfObject()).getOutputStream().writeBytes(stream.getBytes());
        return xObject;
    }

    protected void drawButton(PdfCanvas canvas, float x, float y, float width, float height, String text, PdfFont font, int fontSize) {
        if (this.color == null) {
            this.color = Color.BLACK;
        }
        Paragraph paragraph = (Paragraph)((Paragraph)((Paragraph)((Paragraph)new Paragraph(text).setFont(font)).setFontSize(fontSize)).setMargin(0.0f)).setMultipliedLeading(1.0f).setVerticalAlignment(VerticalAlignment.MIDDLE);
        new Canvas(canvas, this.getDocument(), new Rectangle(0.0f, -height, width, 2.0f * height)).showTextAligned(paragraph, width / 2.0f, height / 2.0f, TextAlignment.CENTER, VerticalAlignment.MIDDLE);
    }

    protected void drawCheckBox(PdfCanvas canvas, float width, float height, int fontSize, boolean on) {
        if (!on) {
            return;
        }
        if (this.checkType == 3) {
            float offset = this.borderWidth * 2.0f;
            canvas.moveTo((width - height) / 2.0f + offset, height - offset).lineTo((width + height) / 2.0f - offset, offset).moveTo((width + height) / 2.0f - offset, height - offset).lineTo((width - height) / 2.0f + offset, offset).stroke();
            return;
        }
        PdfFont ufont = this.getFont();
        canvas.beginText().setFontAndSize(ufont, fontSize).resetFillColorRgb().setTextMatrix((width - ufont.getWidth(this.text, (float)fontSize)) / 2.0f, (height - (float)ufont.getAscent(this.text, (float)fontSize)) / 2.0f).showText(this.text).endText();
    }

    protected void drawPdfACheckBox(PdfCanvas canvas, float width, float height, boolean on) {
        if (!on) {
            return;
        }
        String appearanceString = check;
        switch (this.checkType) {
            case 1: {
                appearanceString = check;
                break;
            }
            case 2: {
                appearanceString = circle;
                break;
            }
            case 3: {
                appearanceString = cross;
                break;
            }
            case 4: {
                appearanceString = diamond;
                break;
            }
            case 5: {
                appearanceString = square;
                break;
            }
            case 6: {
                appearanceString = star;
            }
        }
        canvas.saveState();
        canvas.resetFillColorRgb();
        canvas.concatMatrix(width, 0.0, 0.0, height, 0.0, 0.0);
        canvas.getContentStream().getOutputStream().writeBytes(appearanceString.getBytes());
        canvas.restoreState();
    }

    private PdfName getTypeFromParent(PdfDictionary field) {
        PdfDictionary parent = field.getAsDictionary(PdfName.Parent);
        PdfName formType = field.getAsName(PdfName.FT);
        if (parent != null && (formType = parent.getAsName(PdfName.FT)) == null) {
            formType = this.getTypeFromParent(parent);
        }
        return formType;
    }

    private String obfuscatePassword(String text) {
        char[] pchar = new char[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            pchar[i] = 42;
        }
        return new String(pchar);
    }

    private void applyRotation(PdfFormXObject xObject, float height, float width) {
        switch (this.rotation) {
            case 90: {
                ((PdfStream)xObject.getPdfObject()).put(PdfName.Matrix, new PdfArray(new float[]{0.0f, 1.0f, -1.0f, 0.0f, height, 0.0f}));
                break;
            }
            case 180: {
                ((PdfStream)xObject.getPdfObject()).put(PdfName.Matrix, new PdfArray(new float[]{-1.0f, 0.0f, 0.0f, -1.0f, width, height}));
                break;
            }
            case 270: {
                ((PdfStream)xObject.getPdfObject()).put(PdfName.Matrix, new PdfArray(new float[]{0.0f, -1.0f, 1.0f, 0.0f, 0.0f, width}));
            }
        }
    }

    private String optionsArrayToString(PdfArray options) {
        String value = "";
        for (PdfObject obj : options) {
            PdfObject element;
            if (obj.isString()) {
                value = value + ((PdfString)obj).toUnicodeString() + '\n';
                continue;
            }
            if (!obj.isArray() || !(element = ((PdfArray)obj).get(1)).isString()) continue;
            value = value + ((PdfString)element).toUnicodeString() + '\n';
        }
        value = value.substring(0, value.length() - 1);
        return value;
    }
}

