/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.parser;

import com.fr.third.com.lowagie.text.Document;
import com.fr.third.com.lowagie.text.DocumentException;
import com.fr.third.com.lowagie.text.Element;
import com.fr.third.com.lowagie.text.List;
import com.fr.third.com.lowagie.text.rtf.direct.RtfDirectContent;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.parser.RtfImportMappings;
import com.fr.third.com.lowagie.text.rtf.parser.RtfImportMgr;
import com.fr.third.com.lowagie.text.rtf.parser.RtfParserState;
import com.fr.third.com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.fr.third.com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordListener;
import com.fr.third.com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordMgr;
import com.fr.third.com.lowagie.text.rtf.parser.destinations.RtfDestination;
import com.fr.third.com.lowagie.text.rtf.parser.destinations.RtfDestinationMgr;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Stack;

public class RtfParser {
    private static final boolean debugParser = false;
    private String logFile = null;
    private boolean logging = false;
    private boolean logAppend = false;
    private Element elem = null;
    private Document document = null;
    private RtfDocument rtfDoc = null;
    private RtfCtrlWordMgr rtfKeywordMgr = null;
    private RtfImportMgr importMgr = null;
    private RtfDestinationMgr destinationMgr = null;
    private Stack stackState = null;
    private RtfParserState currentState = null;
    private PushbackInputStream pbReader = null;
    private int conversionType = 0;
    public static final int PARSER_IN_HEADER = 0;
    public static final int PARSER_IN_CHARSET = 1;
    public static final int PARSER_IN_DEFFONT = 2;
    public static final int PARSER_IN_FONT_TABLE = 3;
    public static final int PARSER_IN_FONT_TABLE_INFO = 4;
    public static final int PARSER_IN_FILE_TABLE = 5;
    public static final int PARSER_IN_COLOR_TABLE = 6;
    public static final int PARSER_IN_STYLESHEET = 7;
    public static final int PARSER_IN_LIST_TABLE = 8;
    public static final int PARSER_IN_LISTOVERRIDE_TABLE = 9;
    public static final int PARSER_IN_REV_TABLE = 10;
    public static final int PARSER_IN_RSID_TABLE = 11;
    public static final int PARSER_IN_GENERATOR = 12;
    public static final int PARSER_IN_PARAGRAPH_TABLE = 14;
    public static final int PARSER_IN_OLDCPROPS = 15;
    public static final int PARSER_IN_OLDPPROPS = 16;
    public static final int PARSER_IN_OLDTPROPS = 18;
    public static final int PARSER_IN_OLDSPROPS = 19;
    public static final int PARSER_IN_PROT_USER_TABLE = 20;
    public static final int PARSER_IN_LATENTSTYLES = 21;
    public static final int PARSER_IN_PARAGRAPH_GROUP_PROPERTIES = 22;
    public static final int PARSER_IN_DOCUMENT = 0x20000000;
    public static final int PARSER_IN_INFO_GROUP = 0x20000001;
    public static final int PARSER_IN_UPR = 0x20000002;
    public static final int PARSER_IN_SHPPICT = 0x20000010;
    public static final int PARSER_IN_PICT = 0x20000011;
    public static final int PARSER_IN_PICPROP = 0x20000012;
    public static final int PARSER_IN_BLIPUID = 536870931;
    public static final int PARSER_STARTSTOP = 0x40000001;
    public static final int PARSER_ERROR = Integer.MIN_VALUE;
    public static final int PARSER_ERROR_EOF = -2147483647;
    public static final int PARSER_IN_UNKNOWN = -1879048193;
    public static final int TYPE_UNIDENTIFIED = -1;
    public static final int TYPE_IMPORT_FULL = 0;
    public static final int TYPE_IMPORT_FRAGMENT = 1;
    public static final int TYPE_CONVERT = 2;
    public static final int TYPE_IMPORT_INTO_ELEMENT = 3;
    public static final int DESTINATION_NORMAL = 0;
    public static final int DESTINATION_SKIP = 1;
    public static final int TOKENISER_NORMAL = 0;
    public static final int TOKENISER_SKIP_BYTES = 1;
    public static final int TOKENISER_SKIP_GROUP = 2;
    public static final int TOKENISER_BINARY = 3;
    public static final int TOKENISER_HEX = 4;
    public static final int TOKENISER_IGNORE_RESULT = 5;
    public static final int TOKENISER_STATE_IN_ERROR = Integer.MIN_VALUE;
    public static final int TOKENISER_STATE_IN_UNKOWN = -16777216;
    private int groupLevel = 0;
    private int docGroupLevel = 0;
    private long binByteCount = 0L;
    private long binSkipByteCount = 0L;
    private int skipGroupLevel = 0;
    public static final int errOK = 0;
    public static final int errStackUnderflow = -1;
    public static final int errStackOverflow = -2;
    public static final int errUnmatchedBrace = -3;
    public static final int errInvalidHex = -4;
    public static final int errBadTable = -5;
    public static final int errAssertion = -6;
    public static final int errEndOfFile = -7;
    public static final int errCtrlWordNotFound = -8;
    private long byteCount = 0L;
    private long ctrlWordCount = 0L;
    private long openGroupCount = 0L;
    private long closeGroupCount = 0L;
    private long characterCount = 0L;
    private long ctrlWordHandledCount = 0L;
    private long ctrlWordNotHandledCount = 0L;
    private long ctrlWordSkippedCount = 0L;
    private long groupSkippedCount = 0L;
    private long startTime = 0L;
    private long endTime = 0L;
    private Date startDate = null;
    private Date endDate = null;
    private RtfCtrlWordData lastCtrlWordParam = null;
    private ArrayList listeners = new ArrayList();

    public RtfParser(Document doc) {
        this.document = doc;
    }

    public void importRtfDocument(InputStream readerIn, RtfDocument rtfDoc) throws IOException {
        if (readerIn == null || rtfDoc == null) {
            return;
        }
        this.init(0, rtfDoc, readerIn, this.document, null);
        this.setCurrentDestination("null");
        this.startDate = new Date();
        this.startTime = System.currentTimeMillis();
        this.groupLevel = 0;
        try {
            this.tokenise();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.endTime = System.currentTimeMillis();
        this.endDate = new Date();
    }

    public void importRtfDocumentIntoElement(Element elem, InputStream readerIn, RtfDocument rtfDoc) throws IOException {
        if (readerIn == null || rtfDoc == null || elem == null) {
            return;
        }
        this.init(3, rtfDoc, readerIn, this.document, elem);
        this.setCurrentDestination("null");
        this.startDate = new Date();
        this.startTime = System.currentTimeMillis();
        this.groupLevel = 0;
        try {
            this.tokenise();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.endTime = System.currentTimeMillis();
        this.endDate = new Date();
    }

    public void convertRtfDocument(InputStream readerIn, Document doc) throws IOException {
        if (readerIn == null || doc == null) {
            return;
        }
        this.init(2, null, readerIn, doc, null);
        this.setCurrentDestination("document");
        this.startDate = new Date();
        this.startTime = System.currentTimeMillis();
        this.groupLevel = 0;
        this.tokenise();
        this.endTime = System.currentTimeMillis();
        this.endDate = new Date();
    }

    public void importRtfFragment(InputStream readerIn, RtfDocument rtfDoc, RtfImportMappings importMappings) throws IOException {
        if (readerIn == null || rtfDoc == null || importMappings == null) {
            return;
        }
        this.init(1, rtfDoc, readerIn, null, null);
        this.handleImportMappings(importMappings);
        this.setCurrentDestination("document");
        this.groupLevel = 1;
        this.setParserState(0x20000000);
        this.startDate = new Date();
        this.startTime = System.currentTimeMillis();
        this.tokenise();
        this.endTime = System.currentTimeMillis();
        this.endDate = new Date();
    }

    public void addListener(EventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    private void init(int type, RtfDocument rtfDoc, InputStream readerIn, Document doc, Element elem) {
        this.init_stats();
        this.pbReader = this.init_Reader(readerIn);
        this.conversionType = type;
        this.rtfDoc = rtfDoc;
        this.document = doc;
        this.elem = elem;
        this.currentState = new RtfParserState();
        this.stackState = new Stack();
        this.setParserState(0x40000001);
        this.importMgr = new RtfImportMgr(this.rtfDoc, this.document);
        this.destinationMgr = RtfDestinationMgr.getInstance(this);
        RtfDestinationMgr.setParser(this);
        this.rtfKeywordMgr = new RtfCtrlWordMgr(this, this.pbReader);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Object listener = iterator.next();
            if (!(listener instanceof RtfCtrlWordListener)) continue;
            this.rtfKeywordMgr.addRtfCtrlWordListener((RtfCtrlWordListener)listener);
        }
    }

    protected void init_stats() {
        this.byteCount = 0L;
        this.ctrlWordCount = 0L;
        this.openGroupCount = 0L;
        this.closeGroupCount = 0L;
        this.characterCount = 0L;
        this.ctrlWordHandledCount = 0L;
        this.ctrlWordNotHandledCount = 0L;
        this.ctrlWordSkippedCount = 0L;
        this.groupSkippedCount = 0L;
        this.startTime = 0L;
        this.endTime = 0L;
        this.startDate = null;
        this.endDate = null;
    }

    private PushbackInputStream init_Reader(InputStream readerIn) {
        if (!(readerIn instanceof BufferedInputStream)) {
            readerIn = new BufferedInputStream(readerIn);
        }
        if (!(readerIn instanceof PushbackInputStream)) {
            readerIn = new PushbackInputStream(readerIn);
        }
        return (PushbackInputStream)readerIn;
    }

    private void handleImportMappings(RtfImportMappings importMappings) {
        Iterator it = importMappings.getFontMappings().keySet().iterator();
        while (it.hasNext()) {
            String fontNr = (String)it.next();
            this.importMgr.importFont(fontNr, (String)importMappings.getFontMappings().get(fontNr));
        }
        it = importMappings.getColorMappings().keySet().iterator();
        while (it.hasNext()) {
            String colorNr = (String)it.next();
            this.importMgr.importColor(colorNr, (Color)importMappings.getColorMappings().get(colorNr));
        }
        it = importMappings.getListMappings().keySet().iterator();
        while (it.hasNext()) {
            String listNr = (String)it.next();
            this.importMgr.importList(listNr, (String)importMappings.getListMappings().get(listNr));
        }
        it = importMappings.getStylesheetListMappings().keySet().iterator();
        while (it.hasNext()) {
            String stylesheetListNr = (String)it.next();
            this.importMgr.importStylesheetList(stylesheetListNr, (List)importMappings.getStylesheetListMappings().get(stylesheetListNr));
        }
    }

    public int handleOpenGroup() {
        int result = 0;
        ++this.openGroupCount;
        ++this.groupLevel;
        ++this.docGroupLevel;
        if (this.getTokeniserState() == 2) {
            ++this.groupSkippedCount;
        }
        RtfDestination dest = this.getCurrentDestination();
        boolean handled = false;
        if (dest != null) {
            handled = dest.handleOpeningSubGroup();
        }
        this.stackState.push(this.currentState);
        this.currentState = new RtfParserState(this.currentState);
        this.currentState.newGroup = true;
        dest = this.getCurrentDestination();
        if (dest != null) {
            handled = dest.handleOpenGroup();
        }
        return result;
    }

    public static void outputDebug(Object doc, int groupLevel, String str) {
        System.out.println(str);
        if (doc == null) {
            return;
        }
        if (groupLevel < 0) {
            groupLevel = 0;
        }
        char[] a = new char[groupLevel * 2];
        Arrays.fill(a, ' ');
        String spaces = new String(a);
        if (doc instanceof RtfDocument) {
            ((RtfDocument)doc).add(new RtfDirectContent("\n" + spaces + str));
        } else if (doc instanceof Document) {
            try {
                ((Document)doc).add(new RtfDirectContent("\n" + spaces + str));
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        }
    }

    public int handleCloseGroup() {
        int result = 0;
        ++this.closeGroupCount;
        if (this.getTokeniserState() != 2) {
            RtfDestination dest = this.getCurrentDestination();
            boolean handled = false;
            if (dest != null) {
                boolean bl = dest.handleCloseGroup();
            }
        }
        if (this.stackState.size() > 0) {
            this.currentState = (RtfParserState)this.stackState.pop();
        } else {
            result = -1;
        }
        --this.docGroupLevel;
        --this.groupLevel;
        if (this.getTokeniserState() == 2 && this.groupLevel < this.skipGroupLevel) {
            this.setTokeniserState(0);
        }
        return result;
    }

    public int handleCtrlWord(RtfCtrlWordData ctrlWordData) {
        int result = 0;
        ++this.ctrlWordCount;
        if (this.getTokeniserState() == 2) {
            ++this.ctrlWordSkippedCount;
            return result;
        }
        result = this.rtfKeywordMgr.handleKeyword(ctrlWordData, this.groupLevel);
        if (result == 0) {
            ++this.ctrlWordHandledCount;
        } else {
            ++this.ctrlWordNotHandledCount;
            result = 0;
        }
        return result;
    }

    public int handleCharacter(int nextChar) {
        ++this.characterCount;
        if (this.getTokeniserState() == 2) {
            return 0;
        }
        boolean handled = false;
        RtfDestination dest = this.getCurrentDestination();
        if (dest != null) {
            handled = dest.handleCharacter(nextChar);
        }
        return 0;
    }

    public RtfParserState getState() {
        return this.currentState;
    }

    public int getParserState() {
        return this.currentState.parserState;
    }

    public int setParserState(int newState) {
        this.currentState.parserState = newState;
        return this.currentState.parserState;
    }

    public int getConversionType() {
        return this.conversionType;
    }

    public RtfDocument getRtfDocument() {
        return this.rtfDoc;
    }

    public Document getDocument() {
        return this.document;
    }

    public RtfImportMgr getImportManager() {
        return this.importMgr;
    }

    public boolean setCurrentDestination(String destination) {
        RtfDestination dest = RtfDestinationMgr.getDestination(destination);
        if (dest != null) {
            this.currentState.destination = dest;
            return false;
        }
        this.setTokeniserStateSkipGroup();
        return false;
    }

    public RtfDestination getCurrentDestination() {
        return this.currentState.destination;
    }

    public RtfDestination getDestination(String destination) {
        return RtfDestinationMgr.getDestination(destination);
    }

    public boolean isNewGroup() {
        return this.currentState.newGroup;
    }

    public boolean setNewGroup(boolean value) {
        this.currentState.newGroup = value;
        return this.currentState.newGroup;
    }

    public void tokenise() throws IOException {
        int errorCode = 0;
        int nextChar = 0;
        this.setTokeniserState(0);
        block8: while ((nextChar = this.pbReader.read()) != -1) {
            ++this.byteCount;
            if (this.getTokeniserState() == 3) {
                errorCode = this.parseChar(nextChar);
                if (errorCode == 0) continue;
                return;
            }
            switch (nextChar) {
                case 123: {
                    this.handleOpenGroup();
                    break;
                }
                case 125: {
                    this.handleCloseGroup();
                    break;
                }
                case 10: 
                case 13: {
                    break;
                }
                case 92: {
                    if (this.parseCtrlWord(this.pbReader) == 0) continue block8;
                    return;
                }
                default: {
                    if (this.groupLevel == 0) continue block8;
                    if (this.getTokeniserState() == 4) {
                        StringBuffer hexChars = new StringBuffer();
                        hexChars.append(nextChar);
                        nextChar = this.pbReader.read();
                        if (nextChar == -1) {
                            return;
                        }
                        ++this.byteCount;
                        hexChars.append(nextChar);
                        try {
                            nextChar = Integer.parseInt(hexChars.toString(), 16);
                        }
                        catch (NumberFormatException e) {
                            return;
                        }
                        this.setTokeniserState(0);
                    }
                    if ((errorCode = this.parseChar(nextChar)) == 0) continue block8;
                    return;
                }
            }
        }
        RtfDestination dest = this.getCurrentDestination();
        if (dest != null) {
            dest.closeDestination();
        }
    }

    private int parseChar(int nextChar) {
        if (this.getTokeniserState() == 3 && --this.binByteCount <= 0L) {
            this.setTokeniserStateNormal();
        }
        if (this.getTokeniserState() == 1 && --this.binSkipByteCount <= 0L) {
            this.setTokeniserStateNormal();
        }
        return this.handleCharacter(nextChar);
    }

    private int parseCtrlWord(PushbackInputStream reader) throws IOException {
        int nextChar = 0;
        int result = 0;
        nextChar = reader.read();
        if (nextChar == -1) {
            return -7;
        }
        ++this.byteCount;
        StringBuffer parsedCtrlWord = new StringBuffer();
        StringBuffer parsedParam = new StringBuffer();
        RtfCtrlWordData ctrlWordParam = new RtfCtrlWordData();
        if (!Character.isLetterOrDigit((char)nextChar)) {
            parsedCtrlWord.append((char)nextChar);
            ctrlWordParam.ctrlWord = parsedCtrlWord.toString();
            result = this.handleCtrlWord(ctrlWordParam);
            this.lastCtrlWordParam = ctrlWordParam;
            return result;
        }
        do {
            parsedCtrlWord.append((char)nextChar);
            nextChar = reader.read();
            ++this.byteCount;
        } while (Character.isLetter((char)nextChar));
        ctrlWordParam.ctrlWord = parsedCtrlWord.toString();
        if (nextChar == 45) {
            ctrlWordParam.isNeg = true;
            nextChar = reader.read();
            if (nextChar == -1) {
                return -7;
            }
            ++this.byteCount;
        }
        if (Character.isDigit((char)nextChar)) {
            ctrlWordParam.hasParam = true;
            do {
                parsedParam.append((char)nextChar);
                nextChar = reader.read();
                ++this.byteCount;
            } while (Character.isDigit((char)nextChar));
            ctrlWordParam.param = parsedParam.toString();
        }
        if (nextChar != 32) {
            reader.unread(nextChar);
        }
        result = this.handleCtrlWord(ctrlWordParam);
        this.lastCtrlWordParam = ctrlWordParam;
        return result;
    }

    public int setTokeniserState(int value) {
        this.currentState.tokeniserState = value;
        return this.currentState.tokeniserState;
    }

    public int getTokeniserState() {
        return this.currentState.tokeniserState;
    }

    public int getLevel() {
        return this.groupLevel;
    }

    public void setTokeniserStateNormal() {
        this.setTokeniserState(0);
    }

    public void setTokeniserStateSkipGroup() {
        this.setTokeniserState(2);
        this.skipGroupLevel = this.groupLevel;
    }

    public void setTokeniserSkipBytes(long numberOfBytesToSkip) {
        this.setTokeniserState(1);
        this.binSkipByteCount = numberOfBytesToSkip;
    }

    public void setTokeniserStateBinary(int binaryCount) {
        this.setTokeniserState(3);
        this.binByteCount = binaryCount;
    }

    public void setTokeniserStateBinary(long binaryCount) {
        this.setTokeniserState(3);
        this.binByteCount = binaryCount;
    }

    public boolean isConvert() {
        return this.getConversionType() == 2;
    }

    public boolean isImport() {
        return this.isImportFull() || this.isImportFragment();
    }

    public boolean isImportFull() {
        return this.getConversionType() == 0;
    }

    public boolean isImportFragment() {
        return this.getConversionType() == 1;
    }

    public boolean getExtendedDestination() {
        return this.currentState.isExtendedDestination;
    }

    public boolean setExtendedDestination(boolean value) {
        this.currentState.isExtendedDestination = value;
        return this.currentState.isExtendedDestination;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void setLogFile(String logFile, boolean logAppend) {
        this.logFile = logFile;
        this.setLogAppend(logAppend);
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public boolean isLogAppend() {
        return this.logAppend;
    }

    public void setLogAppend(boolean logAppend) {
        this.logAppend = logAppend;
    }
}

