/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.spline;

import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.curve.AbstractSmoothCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.Curves2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.domain.ContinuousOrientedCurve2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.polygon.Polyline2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadBezierCurve2D
extends AbstractSmoothCurve2D
implements SmoothCurve2D,
ContinuousOrientedCurve2D,
Cloneable {
    protected double x1;
    protected double y1;
    protected double ctrlx;
    protected double ctrly;
    protected double x2;
    protected double y2;

    @Deprecated
    public static QuadBezierCurve2D create(Point2D p1, Point2D p2, Point2D p3) {
        return new QuadBezierCurve2D(p1, p2, p3);
    }

    public QuadBezierCurve2D() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public QuadBezierCurve2D(double[][] coefs) {
        this(coefs[0][0], coefs[1][0], coefs[0][0] + coefs[0][1] / 2.0, coefs[1][0] + coefs[1][1] / 2.0, coefs[0][0] + coefs[0][1] + coefs[0][2], coefs[1][0] + coefs[1][1] + coefs[1][2]);
    }

    public QuadBezierCurve2D(Point2D p1, Point2D ctrl, Point2D p2) {
        this(p1.x(), p1.y(), ctrl.x(), ctrl.y(), p2.x(), p2.y());
    }

    public QuadBezierCurve2D(Point2D[] pts) {
        this(pts[0].x(), pts[0].y(), pts[1].x(), pts[1].y(), pts[2].x(), pts[2].y());
    }

    public QuadBezierCurve2D(double x1, double y1, double xctrl, double yctrl, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.ctrlx = xctrl;
        this.ctrly = yctrl;
        this.x2 = x2;
        this.y2 = y2;
    }

    public Point2D getControl() {
        return new Point2D(this.ctrlx, this.ctrly);
    }

    public Point2D getP1() {
        return this.firstPoint();
    }

    public Point2D getP2() {
        return this.lastPoint();
    }

    public Point2D getCtrl() {
        return this.getControl();
    }

    public double[][] getParametric() {
        double[][] tab = new double[2][3];
        tab[0][0] = this.x1;
        tab[0][1] = 2.0 * this.ctrlx - 2.0 * this.x1;
        tab[0][2] = this.x2 - 2.0 * this.ctrlx + this.x1;
        tab[1][0] = this.y1;
        tab[1][1] = 2.0 * this.ctrly - 2.0 * this.y1;
        tab[1][2] = this.y2 - 2.0 * this.ctrly + this.y1;
        return tab;
    }

    @Override
    public double windingAngle(Point2D point) {
        return this.asPolyline(100).windingAngle(point);
    }

    @Override
    public boolean isInside(Point2D pt) {
        return this.asPolyline(100).isInside(pt);
    }

    @Override
    public double signedDistance(Point2D point) {
        if (this.isInside(point)) {
            return -this.distance(point.x(), point.y());
        }
        return this.distance(point.x(), point.y());
    }

    @Override
    public double signedDistance(double x, double y) {
        if (this.isInside(new Point2D(x, y))) {
            return -this.distance(x, y);
        }
        return this.distance(x, y);
    }

    @Override
    public Vector2D tangent(double t) {
        double[][] c = this.getParametric();
        double dx = c[0][1] + 2.0 * c[0][2] * t;
        double dy = c[1][1] + 2.0 * c[1][2] * t;
        return new Vector2D(dx, dy);
    }

    @Override
    public double curvature(double t) {
        double[][] c = this.getParametric();
        double xp = c[0][1] + 2.0 * c[0][2] * t;
        double yp = c[1][1] + 2.0 * c[1][2] * t;
        double xs = 2.0 * c[0][2];
        double ys = 2.0 * c[1][2];
        return (xp * ys - yp * xs) / Math.pow(Math.hypot(xp, yp), 3.0);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public Polyline2D asPolyline(int n) {
        double dt = 1.0 / (double)n;
        Point2D[] points = new Point2D[n + 1];
        int i = 0;
        while (i < n + 1) {
            points[i] = this.point((double)i * dt);
            ++i;
        }
        return new Polyline2D(points);
    }

    @Override
    public double t0() {
        return 0.0;
    }

    @Override
    @Deprecated
    public double getT0() {
        return this.t0();
    }

    @Override
    public double t1() {
        return 1.0;
    }

    @Override
    @Deprecated
    public double getT1() {
        return this.t1();
    }

    @Override
    public Collection<Point2D> intersections(LinearShape2D line) {
        return this.asPolyline(100).intersections(line);
    }

    @Override
    public Point2D point(double t) {
        t = Math.min(Math.max(t, 0.0), 1.0);
        double[][] c = this.getParametric();
        double x = c[0][0] + (c[0][1] + c[0][2] * t) * t;
        double y = c[1][0] + (c[1][1] + c[1][2] * t) * t;
        return new Point2D(x, y);
    }

    @Override
    public Point2D firstPoint() {
        return new Point2D(this.x1, this.y1);
    }

    @Override
    public Point2D lastPoint() {
        return new Point2D(this.x2, this.y2);
    }

    @Override
    public double position(Point2D point) {
        int N = 100;
        return this.asPolyline(N).position(point) / (double)N;
    }

    @Override
    public double project(Point2D point) {
        int N = 100;
        return this.asPolyline(N).project(point) / (double)N;
    }

    @Override
    public QuadBezierCurve2D reverse() {
        return new QuadBezierCurve2D(this.lastPoint(), this.getControl(), this.firstPoint());
    }

    @Override
    public QuadBezierCurve2D subCurve(double t0, double t1) {
        if ((t0 = Math.max(t0, 0.0)) > (t1 = Math.min(t1, 1.0))) {
            return null;
        }
        Point2D p0 = this.point(t0);
        Point2D p1 = this.point(t1);
        Vector2D v0 = this.tangent(t0);
        Vector2D v1 = this.tangent(t1);
        StraightLine2D tan0 = new StraightLine2D(p0, v0);
        StraightLine2D tan1 = new StraightLine2D(p1, v1);
        Point2D control = tan0.intersection(tan1);
        return new QuadBezierCurve2D(p0, control, p1);
    }

    @Override
    public boolean contains(double x, double y) {
        return new QuadCurve2D.Double(this.x1, this.y1, this.ctrlx, this.ctrly, this.x2, this.y2).contains(x, y);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x(), p.y());
    }

    @Override
    public double distance(Point2D p) {
        return this.distance(p.x(), p.y());
    }

    @Override
    public double distance(double x, double y) {
        return this.asPolyline(100).distance(x, y);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public CurveSet2D<? extends QuadBezierCurve2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curves2D.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveArray2D<QuadBezierCurve2D> result = new CurveArray2D<QuadBezierCurve2D>(set.size());
        for (Curve2D curve2D : set.curves()) {
            if (!(curve2D instanceof QuadBezierCurve2D)) continue;
            result.add((QuadBezierCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public Box2D boundingBox() {
        Point2D p1 = this.firstPoint();
        Point2D p2 = this.getControl();
        Point2D p3 = this.lastPoint();
        double xmin = Math.min(Math.min(p1.x(), p2.x()), p3.x());
        double xmax = Math.max(Math.max(p1.x(), p2.x()), p3.x());
        double ymin = Math.min(Math.min(p1.y(), p2.y()), p3.y());
        double ymax = Math.max(Math.max(p1.y(), p2.y()), p3.y());
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public QuadBezierCurve2D transform(AffineTransform2D trans) {
        return new QuadBezierCurve2D(trans.transform(this.firstPoint()), trans.transform(this.getControl()), trans.transform(this.lastPoint()));
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        Point2D p2 = this.getControl();
        Point2D p3 = this.lastPoint();
        path.quadTo(p2.x(), p2.y(), p3.x(), p3.y());
        return path;
    }

    public GeneralPath getGeneralPath() {
        GeneralPath path = new GeneralPath();
        Point2D p1 = this.firstPoint();
        Point2D p2 = this.getControl();
        Point2D p3 = this.lastPoint();
        path.moveTo(p1.x(), p1.y());
        path.quadTo(p2.x(), p2.y(), p3.x(), p3.y());
        return path;
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QuadBezierCurve2D)) {
            return false;
        }
        QuadBezierCurve2D bezier = (QuadBezierCurve2D)obj;
        if (Math.abs(this.x1 - bezier.x1) > eps) {
            return false;
        }
        if (Math.abs(this.y1 - bezier.y1) > eps) {
            return false;
        }
        if (Math.abs(this.ctrlx - bezier.ctrlx) > eps) {
            return false;
        }
        if (Math.abs(this.ctrly - bezier.ctrly) > eps) {
            return false;
        }
        if (Math.abs(this.x2 - bezier.x2) > eps) {
            return false;
        }
        return !(Math.abs(this.y2 - bezier.y2) > eps);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QuadBezierCurve2D)) {
            return false;
        }
        QuadBezierCurve2D bezier = (QuadBezierCurve2D)obj;
        if (Math.abs(this.x1 - bezier.x1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.y1 - bezier.y1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrlx - bezier.ctrlx) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrly - bezier.ctrly) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.x2 - bezier.x2) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(this.y2 - bezier.y2) > 1.0E-12);
    }

    @Override
    public QuadBezierCurve2D clone() {
        return new QuadBezierCurve2D(this.x1, this.y1, this.ctrlx, this.ctrly, this.x2, this.y2);
    }
}

