/*
 * Decompiled with CFR 0.152.
 */
package javapns.test;

import java.util.ArrayList;
import java.util.List;
import javapns.Push;
import javapns.communication.exceptions.CommunicationException;
import javapns.communication.exceptions.KeystoreException;
import javapns.devices.Device;
import javapns.devices.implementations.basic.BasicDevice;
import javapns.notification.AppleNotificationServer;
import javapns.notification.AppleNotificationServerBasicImpl;
import javapns.notification.Payload;
import javapns.notification.PushNotificationPayload;
import javapns.notification.PushedNotification;
import javapns.notification.PushedNotifications;
import javapns.notification.transmission.NotificationProgressListener;
import javapns.notification.transmission.NotificationThread;
import javapns.notification.transmission.NotificationThreads;
import javapns.test.TestFoundation;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationTest
extends TestFoundation {
    public static final NotificationProgressListener DEBUGGING_PROGRESS_LISTENER = new NotificationProgressListener(){

        public void eventThreadStarted(NotificationThread notificationThread) {
            System.out.println("   [EVENT]: thread #" + notificationThread.getThreadNumber() + " started with " + notificationThread.getDevices().size() + " devices beginning at message id #" + notificationThread.getFirstMessageIdentifier());
        }

        public void eventThreadFinished(NotificationThread thread) {
            System.out.println("   [EVENT]: thread #" + thread.getThreadNumber() + " finished: pushed messages #" + thread.getFirstMessageIdentifier() + " to " + thread.getLastMessageIdentifier() + " toward " + thread.getDevices().size() + " devices");
        }

        public void eventConnectionRestarted(NotificationThread thread) {
            System.out.println("   [EVENT]: connection restarted in thread #" + thread.getThreadNumber() + " because it reached " + thread.getMaxNotificationsPerConnection() + " notifications per connection");
        }

        public void eventAllThreadsStarted(NotificationThreads notificationThreads) {
            System.out.println("   [EVENT]: all threads started: " + notificationThreads.getThreads().size());
        }

        public void eventAllThreadsFinished(NotificationThreads notificationThreads) {
            System.out.println("   [EVENT]: all threads finished: " + notificationThreads.getThreads().size());
        }

        public void eventCriticalException(NotificationThread notificationThread, Exception exception) {
            System.out.println("   [EVENT]: critical exception occurred: " + exception);
        }
    };

    public static void main(String[] args) {
        if (!NotificationTest.verifyCorrectUsage(NotificationTest.class, args, "keystore-path", "keystore-password", "device-token", "[production|sandbox]", "[complex|simple|threads]", "[#devices]", "[#threads]")) {
            return;
        }
        NotificationTest.configureBasicLogging();
        try {
            NotificationTest.pushTest(args);
        }
        catch (CommunicationException e) {
            e.printStackTrace();
        }
        catch (KeystoreException e) {
            e.printStackTrace();
        }
    }

    private NotificationTest() {
    }

    private static void pushTest(String[] args) throws CommunicationException, KeystoreException {
        String keystore = args[0];
        String password = args[1];
        String token = args[2];
        boolean production = args.length >= 4 ? args[3].equalsIgnoreCase("production") : false;
        boolean simulation = args.length >= 4 ? args[3].equalsIgnoreCase("simulation") : false;
        boolean complex = args.length >= 5 ? args[4].equalsIgnoreCase("complex") : false;
        boolean threads = args.length >= 5 ? args[4].equalsIgnoreCase("threads") : false;
        int threadDevices = args.length >= 6 ? Integer.parseInt(args[5]) : 100;
        int threadThreads = args.length >= 7 ? Integer.parseInt(args[6]) : 10;
        boolean simple = !complex && !threads;
        NotificationTest.verifyKeystore(keystore, password, production);
        if (simple) {
            PushedNotifications notifications = Push.test(keystore, password, production, token);
            NotificationTest.printPushedNotifications(notifications);
        } else if (complex) {
            PushedNotifications notifications = Push.payload(NotificationTest.createComplexPayload(), keystore, password, production, token);
            NotificationTest.printPushedNotifications(notifications);
        } else if (threads) {
            NotificationTest.pushSimplePayloadUsingThreads(keystore, password, production, token, simulation, threadDevices, threadThreads);
        }
    }

    private static Payload createComplexPayload() {
        PushNotificationPayload complexPayload = PushNotificationPayload.complex();
        try {
            complexPayload.addCustomAlertBody("My alert message");
            complexPayload.addCustomAlertActionLocKey("Open App");
            complexPayload.addCustomAlertLocKey("javapns rocks %@ %@%@");
            ArrayList<Object> parameters = new ArrayList<Object>();
            parameters.add("Test1");
            parameters.add("Test");
            parameters.add(2);
            complexPayload.addCustomAlertLocArgs(parameters);
            complexPayload.addBadge(45);
            complexPayload.addSound("default");
            complexPayload.addCustomDictionary("acme", "foo");
            complexPayload.addCustomDictionary("acme2", 42);
            ArrayList<Object> values = new ArrayList<Object>();
            values.add("value1");
            values.add(2);
            complexPayload.addCustomDictionary("acme3", values);
        }
        catch (JSONException e) {
            System.out.println("Error creating complex payload:");
            e.printStackTrace();
        }
        return complexPayload;
    }

    protected static void pushSimplePayloadUsingThreads(String keystore, String password, boolean production, String token, boolean simulation, int devices, int threads) {
        try {
            System.out.println("Creating PushNotificationManager and AppleNotificationServer");
            AppleNotificationServerBasicImpl server = new AppleNotificationServerBasicImpl((Object)keystore, password, production);
            System.out.println("Creating payload (simulation mode)");
            PushNotificationPayload payload = PushNotificationPayload.test();
            System.out.println("Generating " + devices + " fake devices");
            ArrayList<Device> deviceList = new ArrayList<Device>(devices);
            for (int i = 0; i < devices; ++i) {
                String tokenToUse = token;
                if (tokenToUse == null || tokenToUse.length() != 64) {
                    tokenToUse = "123456789012345678901234567890123456789012345678901234567" + (1000000 + i);
                }
                deviceList.add(new BasicDevice(tokenToUse));
            }
            System.out.println("Creating " + threads + " notification threads");
            NotificationThreads work = new NotificationThreads((AppleNotificationServer)server, simulation ? payload.asSimulationOnly() : payload, deviceList, threads);
            System.out.println("Linking notification work debugging listener");
            work.setListener(DEBUGGING_PROGRESS_LISTENER);
            System.out.println("Starting all threads...");
            long timestamp1 = System.currentTimeMillis();
            work.start();
            System.out.println("All threads started, waiting for them...");
            work.waitForAllThreads();
            long timestamp2 = System.currentTimeMillis();
            System.out.println("All threads finished in " + (timestamp2 - timestamp1) + " milliseconds");
            NotificationTest.printPushedNotifications(work.getPushedNotifications());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printPushedNotifications(List<PushedNotification> notifications) {
        List<PushedNotification> failedNotifications = PushedNotification.findFailedNotifications(notifications);
        List<PushedNotification> successfulNotifications = PushedNotification.findSuccessfulNotifications(notifications);
        int failed = failedNotifications.size();
        int successful = successfulNotifications.size();
        if (successful > 0 && failed == 0) {
            NotificationTest.printPushedNotifications("All notifications pushed successfully (" + successfulNotifications.size() + "):", successfulNotifications);
        } else if (successful == 0 && failed > 0) {
            NotificationTest.printPushedNotifications("All notifications failed (" + failedNotifications.size() + "):", failedNotifications);
        } else if (successful == 0 && failed == 0) {
            System.out.println("No notifications could be sent, probably because of a critical error");
        } else {
            NotificationTest.printPushedNotifications("Some notifications failed (" + failedNotifications.size() + "):", failedNotifications);
            NotificationTest.printPushedNotifications("Others succeeded (" + successfulNotifications.size() + "):", successfulNotifications);
        }
    }

    public static void printPushedNotifications(String description, List<PushedNotification> notifications) {
        System.out.println(description);
        for (PushedNotification notification : notifications) {
            try {
                System.out.println("  " + notification.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

