package http.entity;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

import http.utils.JaxbUtil;
import http.utils.JaxbUtil.CollectionWrapper;

@XmlRootElement(name = "DATA")
public class DATA {
	
	private String dataType;
	
	private List<Record> record;
	
	@XmlAttribute(name = "DATATYPE") 
	public String getDataType() {
		return dataType;
	}

	public void setDataType(String dataType) {
		this.dataType = dataType;
	}

	@XmlElement(name = "RECORD")
	public List<Record> getRecord() {
		return record;
	}

	public void setRecord(List<Record> record) {
		this.record = record;
	}
	
	public DATA(){
		super();
	}
	
	public static void main(String[] args) {
		
		Srxm srxm = new Srxm();
		srxm.setXmbm("20320301");
		srxm.setXmje("200");
		srxm.setXmsl("100");
		
		List<Srxm> srxmList= new ArrayList<Srxm>();
		srxmList.add(srxm);
		srxmList.add(srxm);
		
		LIST list = new LIST();
		list.setSrxm(srxmList);
		
		Main main = new Main();
		main.setPjlx("01001");
		main.setPjhm("000000001X");
		
		Record record = new Record();
		record.setMain(main);
		record.setList(list);
		
		List<Record> recordList = new ArrayList<Record>();
		recordList.add(record);
		 
		DATA data = new DATA();
		data.setDataType("COMMONBILLINFO"); 
		data.setRecord(recordList);
		
		JaxbUtil requestBinder = new JaxbUtil(DATA.class,  
                CollectionWrapper.class);  
        String retXml = requestBinder.toXml(data, "GB2312").replace(" standalone=\"yes\"", "");  
        System.out.println("xml:"+retXml);  
	}

	

}
