package com.jshx.zzhxm.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhxm.dao.ZzhxmEntityHistoryDao;
import com.jshx.zzhxm.entity.Zzhxm;
import com.jshx.zzhxm.entity.ZzhxmEntityHistory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("zzhxmEntityHistoryDao")
public class ZzhxmEntityHistoryDaoImpl extends BaseDaoImpl implements ZzhxmEntityHistoryDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findZzhxmHistoryEntityByMap", paraMap, page);
	}

	@Override
	public Pagination findByPageReview(Pagination page, Map<String, Object> paraMap) {
		return this.findPageByHqlId("findZzhxmHistoryEntityByMap", paraMap, page);
	}

	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findZzhxm(Map<String, Object> paraMap){
		return this.findListByHqlId("findZzhxmHistoryEntityByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ZzhxmEntityHistory getById(String id)
	{
		return (ZzhxmEntityHistory) this.getObjectById(Zzhxm.class, id);
	}

	/**
	 * 保存信息
	 * @param zzhxm 信息
	 */
	public void save(ZzhxmEntityHistory zzhxm)
	{
		zzhxm.setId(null);
		this.saveOrUpdateObject(zzhxm);
	}

	/**
	 * 修改信息
	 * @param zzhxm 信息
	 */
	public void update(ZzhxmEntityHistory zzhxm)
	{
		this.saveOrUpdateObject(zzhxm);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Zzhxm.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		ZzhxmEntityHistory zzhxm = (ZzhxmEntityHistory)this.getObjectById(ZzhxmEntityHistory.class, id);
		zzhxm.setDelFlag(1);
		this.saveObject(zzhxm);
	}
}
