package com.jshx.zzhqfdz.web;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.mobile.utils.JsonUtil;
import com.jshx.yzssfgl.entity.Yzsdicgl;
import com.jshx.yzssfgl.service.YzsdicglService;
import com.jshx.zzhkppj.entity.Zzhkppj;
import com.jshx.zzhkppj.service.ZzhkppjService;
import com.jshx.zzhqfdz.entity.Zzhqfdz;
import com.jshx.zzhqfdz.service.ZzhqfdzService;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import com.jshx.zzhxm.entity.ZzhxmSfxx;
import com.jshx.zzhxm.service.ZzhxmJktzsService;
import com.jshx.zzhxm.service.ZzhxmService;
import com.jshx.zzhxm.service.ZzhxmSfxxService;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.io.FileInputStream;
import java.math.BigDecimal;
import java.util.*;

public class ZzhqrqfdzAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private String jktzsbhVal;
	private List<Zzhqfdz> zzhqfdzsList = new ArrayList<>();

	/**
	 * 实体类
	 */
	private Zzhqfdz zzhqfdz = new Zzhqfdz();
	private ZzhxmJktzs zzhxmJktzs = new ZzhxmJktzs();
	private ZzhxmSfxx zzhxmSfxx = new ZzhxmSfxx();

	/**
	 * 业务类
	 */
	@Autowired
	private ZzhqfdzService zzhqfdzService;
	@Autowired
	private ZzhxmJktzsService zzhxmJktzsService;
	@Autowired
	private ZzhxmSfxxService zzhxmSfxxService;
	@Autowired
	private YzsdicglService yzsdicglService;
	@Autowired
	private ZzhxmService zzhxmService;
	@Autowired
	private ZzhkppjService zzhkppjService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;



	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;


	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());

		if(null != zzhxmJktzs){

		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != zzhxmJktzs.getJfdmwybh()) && (0 < zzhxmJktzs.getJfdmwybh().trim().length())){
				paraMap.put("jfdmwybh", "%" + zzhxmJktzs.getJfdmwybh().trim() + "%");
			}
			if ((null != zzhxmJktzs.getAccountDetail()) && (0 < zzhxmJktzs.getAccountDetail().trim().length())){
				paraMap.put("accountDetail", "%" + zzhxmJktzs.getAccountDetail().trim() + "%");
			}
			if ((null != zzhxmJktzs.getJktzsbh()) && (0 < zzhxmJktzs.getJktzsbh().trim().length())){
				paraMap.put("jktzsbh", "%" + zzhxmJktzs.getJktzsbh().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|jfdmwybh|accountDetail|zzhhjdzje|nfkp|jktzsbh|jftzyje|czr|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = zzhxmJktzsService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 确认到账
	 */
	public String qrdz() throws Exception{
		try{
			//更新缴款通知书表
			ZzhxmJktzs zzhxmJktzs1 = zzhxmJktzsService.getById(ids);
			zzhxmJktzs1.setNfkp("1");
			zzhxmJktzs1.setAccountStatus("3");//已到账
			zzhxmJktzs1.setCzr(this.getLoginUser().getDisplayName());
//			zzhxmJktzsService.update(zzhxmJktzs1);

			//更新单笔到账表
			Map<String,Object> paramMap = new HashMap<>();
			paramMap.put("jfdmwybh",zzhxmJktzs1.getJfdmwybh());
			List<Zzhqfdz> zzhqfdzList = zzhqfdzService.findZzhqfdz(paramMap);
			// 判断单笔到账金额合计与应缴额是否相等
			List<String> arrivalAmount = new ArrayList<>();
			zzhqfdzList.stream().forEach(zzhqfdz1 -> arrivalAmount.add(zzhqfdz1.getDbdzje()));
			String s = this.simulateInvoicing(zzhxmJktzs1, zzhqfdzList);
			JSONObject jsonObject = JSONObject.fromObject(s);
			if ("200".equals(jsonObject.get("code"))) {
				zzhqfdzService.saveQfqrdz(zzhxmJktzs1, zzhqfdzList);
			}
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch (Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	// 模拟一站式开票数据录入
	public String simulateInvoicing(ZzhxmJktzs jktzs, List<Zzhqfdz> zzhqfdzList) {
		String str = "{ \"message\": \"成功\",\"code\": \"200\"}";
		Map<String, Object> sfxxMap = new HashMap<>();
		sfxxMap.put("jfdmwybh", jktzs.getJfdmwybh());
		List<ZzhxmSfxx> zzhxmSfxx = zzhxmSfxxService.findZzhxmSfxx(sfxxMap);
		for (ZzhxmSfxx sfxx : zzhxmSfxx) {
			//		JSONObject fpzzh = JSONObject.fromObject(messageParam);
//		String accountDetail = fpzzh.getString("accountDetail");//子账户账号
			String accountDetail = jktzs.getAccountDetail();
//			String wfpzbh = fpzzh.getString("wfpzbh");//完费凭证编号
			// 后期填写
//		String ybjksbh = fpzzh.getString("ybjksbh");//一般缴款书编号
//		String ybjksbh = sfxx.getYbjksbh();//一般缴款书编号
//		String kpje = fpzzh.getString("kpje");//开票金额
			String kpje = sfxx.getYjjemx();
			if ("0".equals(new BigDecimal(kpje).stripTrailingZeros().toPlainString())) {
				continue;
			}
			// 后期选择
//		String kprq = fpzzh.getString("kprq");//开票日期
//		String sfxmmc = fpzzh.getString("sfxmmc");//收费项目名称
			String sfxmmc = sfxx.getSfxmmc();

			String sfxmmc1 = "";
			Map<String, Object> paraMap = new HashMap<>();
			List<Yzsdicgl> yzsdicglsList = new ArrayList<>();
			paraMap.put("yzssfmc",sfxmmc);
			yzsdicglsList = yzsdicglService.findYzsdicgl(paraMap);
			if(CollectionUtils.isEmpty(yzsdicglsList)){
				getResponse().setStatus(305);
				str = "{ \"message\": \"收费项目名称编号无法获取收费项目名称，请检查参数\",\"code\": \"1000\"}";
				System.out.println(str);
				JsonUtil.printJsonString(getResponse(), str);
				return str;
			}else{
				sfxmmc1 =  yzsdicglsList.get(0).getYzssfmc();//收费项目名称
			}

			List<ZzhxmJktzs> zzhxmJktzsList = new ArrayList<>();
			ZzhxmJktzs zzhxmJktzs = new ZzhxmJktzs();
			Map<String,Object> paramMap = new HashMap<>();
			paramMap.put("accountDetail",accountDetail);
			zzhxmJktzsList = zzhxmJktzsService.findZzhxmJktzs(paramMap);
			if(CollectionUtils.isEmpty(zzhxmJktzsList) || zzhxmJktzsList.size() == 0){
				str = "{ \"message\": \"根据此子账户暂未查询到缴款项目信息，请核实后重试。\",\"code\": \"1000\"}";
				return str;
			}

			zzhxmJktzs = zzhxmJktzsList.get(0);
			Map<String,Object> paramMap33 = new HashMap<>();
			ZzhxmSfxx zzhxmSfxx22 = new ZzhxmSfxx();
			paramMap33.put("jfdmwybh",zzhxmJktzs.getJfdmwybh());
			paramMap33.put("sfxmmc",sfxmmc1);
			List<ZzhxmSfxx> zzhxmSfxxList22 = new ArrayList<>();
			zzhxmSfxxList22 = zzhxmSfxxService.findZzhxmSfxx(paramMap33);
			if(CollectionUtils.isNotEmpty(zzhxmSfxxList22)){
				zzhxmSfxx22 = zzhxmSfxxList22.get(0);
			}

			//存票据表
			Zzhkppj zzhkppj = new Zzhkppj();
			zzhkppj.setDelFlag(0);
			zzhkppj.setPjzt("0");
			zzhkppj.setAccountDetail(accountDetail);//子账户
			zzhkppj.setFshmc(zzhxmSfxx22.getKhyh());//非税行
			zzhkppj.setGcxmmc(zzhxmJktzs.getGcxmmc());//工程项目名称
			zzhkppj.setJfdmwybh(zzhxmJktzs.getJfdmwybh());//缴费代码唯一编号
			zzhkppj.setJktzsbh(zzhxmJktzs.getJktzsbh());//缴款通知书编号
			zzhkppj.setJsdwmc(zzhxmJktzs.getJsdwmc());//建设单位名称
			zzhkppj.setSfxmmc(sfxmmc1);//收费项目名称
			zzhkppj.setKpje(kpje);//开票金额
			// 2021-8-18 日期和一般缴款书编号后期填写
//			zzhkppj.setKprq(kprq);//开票日期
//			zzhkppj.setYbjksbh(ybjksbh);//一般缴款书编号
//			zzhkppj.setWfpzbh(wfpzbh);//完费凭证编号

		List<Zzhkppj> zzhkppjList2 = new ArrayList<>();
		Map<String,Object> paramMap2 = new HashMap<>();
//		paramMap2.put("ybjksbh",ybjksbh);
//		zzhkppjList2 = zzhkppjService.findZzhkppj(paramMap2);
			/*if(CollectionUtils.isEmpty(zzhkppjList2) || zzhkppjList2.size() == 0){
				zzhkppjService.save(zzhkppj);
			}*/


//			yzscwjzpz.setQfhzid(entry.getValue().get("qfhzid"));//清分汇总id
//			yzscwjzpz.setQfhzlsh(entry.getValue().get("qfhzlsh"));//清分汇总流水号
//			yzscwjzpzDao.save(yzscwjzpz);
			zzhxmService.saveJk4(new ArrayList<>(), zzhkppj);

		}
		return str;
	}

	/**
	 *	根据缴款通知书编号获取缴款信息
	 */
	public void getJktzxx() throws Exception {
		BigDecimal bval= new BigDecimal("0");
		try{
			ZzhxmJktzs zzhxmJktzs =  zzhxmJktzsService.getByJktzsbh(jktzsbhVal);
			//获取子账户合计到账总金额
			Map<String, Object> paraMap = new HashMap<>();
			paraMap.put("jfdmwybh",zzhxmJktzs.getJfdmwybh());
			List<Zzhqfdz> zzhqfdzsList = zzhqfdzService.findZzhqfdz(paraMap);
			for(Zzhqfdz zzhqfdz1 : zzhqfdzsList){
				bval = bval.add(new BigDecimal(zzhqfdz1.getDbdzje()));
			}
			if(zzhxmJktzs != null){
				this.getResponse().getWriter().println("{\"result\":true,\"jfdmwybh\":\""+zzhxmJktzs.getJfdmwybh()+"\"," +
						"\"accountDetail\":\""+zzhxmJktzs.getAccountDetail()+"\"," +
						"\"jftzyje\":\""+zzhxmJktzs.getJftzyje()+"\"," +
						"\"zzhhjdzje\":\""+bval.toString()+"\"}");
			}else{
				this.getResponse().getWriter().println("{\"result\":false}");
			}
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
	}

	/**
	 * 	添加字典信息
	 */
	public String initEditadd() throws Exception{
		view();
		return EDIT;
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != zzhxmJktzs)&&(null != zzhxmJktzs.getId())){
			zzhxmJktzs = zzhxmJktzsService.getById(zzhxmJktzs.getId());
			Map<String, Object> paraMap = new HashMap<>();
			paraMap.put("jfdmwybh",zzhxmJktzs.getJfdmwybh());
			zzhqfdzsList = zzhqfdzService.findZzhqfdz(paraMap);
		}
		return VIEW;
	}

	/**
	 * 	初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 	保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}

		if ("add".equalsIgnoreCase(this.flag)){
			ZzhxmJktzs zzhxmJktzs1 = new ZzhxmJktzs();
			zzhxmJktzs1 = zzhxmJktzsService.getByJktzsbh(zzhxmJktzs.getJktzsbh());
			zzhxmJktzs1.setZzhhjdzje(zzhxmJktzs.getZzhhjdzje());
			zzhxmJktzs1.setQfhjkzje(zzhxmJktzs.getQfhjkzje());
			zzhxmJktzsService.update(zzhxmJktzs1);
		}else{
			zzhxmJktzsService.update(zzhxmJktzs);
		}
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	*/
	private void setBlobField(FileInputStream in)
	{
		if (null != zzhxmJktzs)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到zsdw中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	*/
	public String delete() throws Exception{
	    try{
			zzhxmJktzsService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Zzhqfdz getZzhqfdz(){
		return this.zzhqfdz;
	}

	public void setZzhqfdz(Zzhqfdz zzhqfdz){
		this.zzhqfdz = zzhqfdz;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getJktzsbhVal() {
		return jktzsbhVal;
	}

	public void setJktzsbhVal(String jktzsbhVal) {
		this.jktzsbhVal = jktzsbhVal;
	}

	public ZzhxmJktzs getZzhxmJktzs() {
		return zzhxmJktzs;
	}

	public void setZzhxmJktzs(ZzhxmJktzs zzhxmJktzs) {
		this.zzhxmJktzs = zzhxmJktzs;
	}

	public ZzhxmSfxx getZzhxmSfxx() {
		return zzhxmSfxx;
	}

	public void setZzhxmSfxx(ZzhxmSfxx zzhxmSfxx) {
		this.zzhxmSfxx = zzhxmSfxx;
	}

	public List<Zzhqfdz> getZzhqfdzsList() {
		return zzhqfdzsList;
	}

	public void setZzhqfdzsList(List<Zzhqfdz> zzhqfdzsList) {
		this.zzhqfdzsList = zzhqfdzsList;
	}
}
