package com.jshx.yzsjfhc.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzsjfhc.dao.PaymentVerificationDao;
import com.jshx.yzsjfhc.dao.PaymentVerifyChargeDao;
import com.jshx.yzsjfhc.entity.PaymentVerification;
import com.jshx.yzsjfhc.entity.PaymentVerifyCharge;
import com.jshx.yzsjfhc.service.PaymentVerificationService;
import com.jshx.yzsjfhc.service.PaymentVerifyChargeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("paymentVerifyChargeService")
public class PaymentVerifyChargeServiceImpl extends BaseServiceImpl implements PaymentVerifyChargeService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("paymentVerifyChargeDao")
	private PaymentVerifyChargeDao paymentVerifyChargeDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return paymentVerifyChargeDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentVerifyCharge getById(String id)
	{
		return paymentVerifyChargeDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(PaymentVerifyCharge model)
	{
		paymentVerifyChargeDao.save(model);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(PaymentVerifyCharge model)
	{
		paymentVerifyChargeDao.update(model);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=paymentVerifyChargeDao.findPaymentVerifyCharge(paraMap);

		paymentVerifyChargeDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					paymentVerifyChargeDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<PaymentVerifyCharge> findPaymentVerifyCharge(Map<String, Object> paraMap) {

		return paymentVerifyChargeDao.findPaymentVerifyCharge(paraMap);

	}
}
