package com.jshx.yzscw.yzscwpzgl.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwpzgl.dao.YzscwpzglDao;
import com.jshx.yzscw.yzscwpzgl.dao.YzscwpzglSfxxDao;
import com.jshx.yzscw.yzscwpzgl.entity.Yzscwpzgl;
import com.jshx.yzscw.yzscwpzgl.entity.YzscwpzglSfxx;
import com.jshx.yzscw.yzscwpzgl.service.YzscwpzglService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.function.Consumer;

@Service("yzscwpzglService")
public class YzscwpzglServiceImpl extends BaseServiceImpl implements YzscwpzglService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("yzscwpzglDao")
	private YzscwpzglDao yzscwpzglDao;

	@Autowired()
	@Qualifier("yzscwpzglSfxxDao")
	private YzscwpzglSfxxDao yzscwpzglSfxxDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return yzscwpzglDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Yzscwpzgl getById(String id)
	{
		return yzscwpzglDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param yzscwpzgl 信息
	 */
	@Transactional
	public void save(Yzscwpzgl yzscwpzgl)
	{
		yzscwpzglDao.save(yzscwpzgl);
	}

	/**
	 * 修改信息
	 * @param yzscwpzgl 信息
	 */
	@Transactional
	public void update(Yzscwpzgl yzscwpzgl)
	{
		yzscwpzglDao.update(yzscwpzgl);
	}

	@Transactional
	@Override
	public void updateAll(List<Yzscwpzgl> pzgls) {
		for (Yzscwpzgl pzgl : pzgls) {
			this.update(pzgl);
		}
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects= yzscwpzglDao.findYzscwpzgl(paraMap);
		yzscwpzglDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(List<String> ids) {
		Map<String, Object> paraMap = new HashMap<>();
		//保存删除的记录年月,每个月只记录一次;
		Set<String> stringSet = new HashSet<>();
		for (String id : ids) {
			Yzscwpzgl byId = yzscwpzglDao.getById(id);
			if (StringUtils.isBlank(byId.getId())) {
				return;
			}
			stringSet.add(byId.getVoucherNumber().substring(0, 7));
			paraMap.put("pzglId", byId.getId());
			List<YzscwpzglSfxx> yzscwpzglSfxx = yzscwpzglSfxxDao.findYzscwpzglSfxx(paraMap);
			for (YzscwpzglSfxx sfxx : yzscwpzglSfxx) {
				yzscwpzglSfxxDao.deleteWithFlag(sfxx.getId());
			}
			yzscwpzglDao.deleteWithFlag(id);

			//调整序列号
			Map<String, Object> parameterMap = new HashMap<>();
			//遍历
			for (String s : stringSet) {
				parameterMap.put("voucherNumber", s + "%");
				//查询当月所有记录
				List<Yzscwpzgl> lists = yzscwpzglDao.findYzscwpzgl(parameterMap);
				if (CollectionUtils.isNotEmpty(lists)) {
					//遍历
					for (int i = 0; i < lists.size(); i++) {
						// tempNum 与大小与lists索引关系
						// desc排序
						Yzscwpzgl pzgl = lists.get(i);
						String tempNum = (lists.size() - i) + "";
						while (tempNum.length()<4) {
							tempNum = "0" + tempNum;
						}
						pzgl.setSequenceNumber(tempNum);
						pzgl.setVoucherNumber(s+"-"+tempNum);
						Map<String, Object> paraMap4Update = new HashMap<>();
						paraMap4Update.put("pzglId", pzgl.getId());
						List<YzscwpzglSfxx> list = yzscwpzglSfxxDao.findYzscwpzglSfxx(paraMap4Update);
						yzscwpzglDao.update(pzgl);
						for (YzscwpzglSfxx sfxx : list) {
							sfxx.setVoucherNumber(pzgl.getVoucherNumber());
							yzscwpzglSfxxDao.update(sfxx);
						}
					}
				}
			}
		}
	}

	@Override
	public List<Yzscwpzgl> findYzscwpzgl(Map<String, Object> paraMap) {

		return yzscwpzglDao.findYzscwpzgl(paraMap);

	}

	@Override
	public List<YzscwpzglSfxx> findYzscwpzglSfxx(Map<String, Object> paraMap) {
		return yzscwpzglSfxxDao.findYzscwpzglSfxx(paraMap);
	}

	/**
	 * 添加
	 * @param sfxxes
	 */
	@Override
	@Transactional
	public void saveSfxxByTransactional(List<YzscwpzglSfxx> sfxxes) {
		String accountSubject = "利息收入";
		Yzscwpzgl byId = yzscwpzglDao.getById(sfxxes.get(0).getPzglId());
		for (YzscwpzglSfxx sfxx : sfxxes) {
			yzscwpzglSfxxDao.save(sfxx);
			/*if (StringUtils.isNotBlank(sfxx.getCreditAccountSubject()) && sfxx.getCreditAccountSubject().contains(accountSubject)) {
				// 如果贷方为利息收入，则需要进行月末结转
				byId.setInterestForMonth(0);
			}*/
			//如果是利息收入
			if (StringUtils.isNotBlank(sfxx.getCreditAccountSubject()) && sfxx.getCreditAccountSubject().contains(accountSubject)) {
				byId.setAccountSubject("1");
				//标记利息收入
				//设置初始值
				byId.setInterestForMonth(0);
				byId.setInterestForYear(0);
			}
			/*
			if (StringUtils.isNotBlank(sfxx.getDebitAccountSubject()) && sfxx.getDebitAccountSubject().contains(accountSubject)) {
				byId.setAccountSubject("1");
				//标记利息收入
				//设置初始值
				byId.setInterestForMonth(0);
				byId.setInterestForYear(0);
			}*/
		}
		yzscwpzglDao.update(byId);
	}

	/**
	 * 期末结转
	 * @param sfxxes
	 * @param ids
	 */
	@Override
	@Transactional
	public void saveSfxxByTransactionalForQmjz(List<YzscwpzglSfxx> sfxxes, String ids) {
		String accountSubject = "利息收入";
//		String surplus = "3002本期盈余";
		Map<String, Object> summaryMap = new HashMap<>();
		Set<String> summarySet = new HashSet<>();
		Yzscwpzgl byId = yzscwpzglDao.getById(sfxxes.get(0).getPzglId());
		for (YzscwpzglSfxx sfxx : sfxxes) {
			summaryMap.put(sfxx.getSummary(), sfxx.getSummary());
			summarySet.add(sfxx.getSummary());
			if (sfxx.getAmount().contains(",")) {
				String amount = sfxx.getAmount();
				amount.replaceAll(",", "");
				sfxx.setAmount(amount);
			}
			yzscwpzglSfxxDao.save(sfxx);
			//如果是利息收入
			if (StringUtils.isNotBlank(sfxx.getCreditAccountSubject()) && sfxx.getCreditAccountSubject().contains(accountSubject)) {
				byId.setAccountSubject("1");
				//标记利息收入
				//设置初始值
				byId.setInterestForMonth(2);
				byId.setInterestForYear(0);
			} else {
				// 银行科目设置为利息收入
			}
		}
		StringBuilder sb = new StringBuilder();
		for (String s : summarySet) {
			sb.append(s);
			sb.append(",");
		}
		String s = sb.toString();
		if (s.endsWith(",")) {
			s = s.substring(0, s.length()-1);
		}
		byId.setSummary(s);
		//将结转过的修改状态
		String[] idArr = ids.split(",");
		for (String id : idArr) {
			Yzscwpzgl byId1 = yzscwpzglDao.getById(id.trim());
			byId1.setInterestForMonth(1);
			yzscwpzglDao.update(byId1);
		}
		yzscwpzglDao.update(byId);
	}
	@Override
	@Transactional
	public void saveSfxxByTransactionalForYear(List<YzscwpzglSfxx> sfxxes, String ids) {
		String accountSubject = "本期盈余";
		Map<String, Object> summaryMap = new HashMap<>();
		Set<String> summarySet = new HashSet<>();
		Yzscwpzgl byId = yzscwpzglDao.getById(sfxxes.get(0).getPzglId());
		for (YzscwpzglSfxx sfxx : sfxxes) {
			summaryMap.put(sfxx.getSummary(), sfxx.getSummary());
			summarySet.add(sfxx.getSummary());
			if (sfxx.getAmount().contains(",")) {
				String amount = sfxx.getAmount();
				amount.replaceAll(",", "");
				sfxx.setAmount(amount);
			}
			yzscwpzglSfxxDao.save(sfxx);
			//如果是利息收入
			if (StringUtils.isNotBlank(sfxx.getCreditAccountSubject()) && sfxx.getCreditAccountSubject().contains(accountSubject)) {
				byId.setAccountSubject("1");
				//标记利息收入
				//设置初始值
				byId.setInterestForMonth(3);
				byId.setInterestForYear(1);
			}
		}
		StringBuilder sb = new StringBuilder();
		for (String s : summarySet) {
			sb.append(s);
			sb.append(",");
		}
		String s = sb.toString();
		if (s.endsWith(",")) {
			s = s.substring(0, s.length()-1);
		}
		byId.setSummary(s);
		//将结转过的修改状态
		String[] idArr = ids.split(",");
		for (String id : idArr) {
			Yzscwpzgl byId1 = yzscwpzglDao.getById(id.trim());
			byId1.setInterestForMonth(3);
			yzscwpzglDao.update(byId1);
		}
		yzscwpzglDao.update(byId);
	}

	@Transactional
	@Override
	public void updateAndSfxx(Yzscwpzgl byId, List<YzscwpzglSfxx> sfxxList) {
		for (YzscwpzglSfxx yzscwpzglSfxx : sfxxList) {
			yzscwpzglSfxxDao.update(yzscwpzglSfxx);
		}
		yzscwpzglDao.update(byId);
	}
}
