package com.jshx.xmhf.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import com.jshx.core.utils.StringUtil;
import com.jshx.module.admin.web.action.CommonAction;
import com.jshx.zsdw.service.ZsdwService;
import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.szys.entity.Szys;
import com.jshx.szys.service.SzysService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.xmhf.entity.Xmhf;
import com.jshx.xmhf.service.XmhfService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;

public class XmhfAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private String fhid;
	private String fhbz;
	private String fhzt;
	
     
	public String getFhid() {
		return fhid;
	}
	public void setFhid(String fhid) {
		this.fhid = fhid;
	}
	public String getFhbz() {
		return fhbz;
	}
	public void setFhbz(String fhbz) {
		this.fhbz = fhbz;
	}
	public String getFhzt() {
		return fhzt;
	}
	public void setFhzt(String fhzt) {
		this.fhzt = fhzt;
	}

	/**
	 * 实体类
	 */
	private Xmhf xmhf = new Xmhf();
	private Xmxxb xmxxb =new Xmxxb();

	/**
	 * 业务类
	 */
	@Autowired
	private XmhfService xmhfService;
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private SzysService szysService;
	@Autowired
	private ZsdwService zsdwService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	private Date queryJbsjStart;

	private Date queryJbsjEnd;

	private Date queryFhsjStart;

	private Date queryFhsjEnd;

	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("starts", "0");
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != xmhf){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != xmhf.getXmxxbzj()) && (0 < xmhf.getXmxxbzj().trim().length())){
				paraMap.put("xmxxbzj", "%" + xmhf.getXmxxbzj().trim() + "%");
			}

			if ((null != xmhf.getXmjbr()) && (0 < xmhf.getXmjbr().trim().length())){
				paraMap.put("xmjbr", "%" + xmhf.getXmjbr().trim() + "%");
			}

			if (null != queryJbsjStart){
				paraMap.put("startJbsj", queryJbsjStart);
			}

			if (null != queryJbsjEnd){
				paraMap.put("endJbsj", queryJbsjEnd);
			}
		}
		if(null != xmxxb){
			//设置查询条件，开发人员可以在此增加过滤条件
			if ((null != xmxxb.getJsdw()) && (0 < xmxxb.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + xmxxb.getJsdw().trim() + "%");
			}
			if ((null != xmxxb.getXmmc()) && (0 < xmxxb.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + xmxxb.getXmmc().trim() + "%");
			}
			if ((null != xmxxb.getJsdd()) && (0 < xmxxb.getJsdd().trim().length())){
				paraMap.put("jsdd", "%" + xmxxb.getJsdd().trim() + "%");
			}
			if ((null != xmxxb.getXxylb()) && (0 < xmxxb.getXxylb().trim().length())){
				paraMap.put("xxylb", "%" + xmxxb.getXxylb().trim() + "%");
			}
	
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
//		final String filter = "id|xmxxbzj|xmjbr|jbsj|jbbz|hfzsdw|xmlsh|xxylb|jsdw|xmmc|jbcs|";
//		if (filter != null && filter.length() > 1) {
//			config.setJsonPropertyFilter(new PropertyFilter() {
//				public boolean apply(Object source, String name, Object value) {
//					if (filter.indexOf(name + "|") != -1)
//						return false;
//					else
//						return true;
//				}
//			});
//		}

		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		pagination = xmhfService.findByPage1(pagination, paraMap);
		pagination.setListOfObject(pagination.getList());
		convObjectToJson(pagination, config);
	}
	public void list1() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("starts", "1");
		paraMap.put("fhrid", this.getLoginUser().getId());
		if(pagination==null)
			pagination = new Pagination(this.getRequest());
		
		if(null != xmhf){
			//设置查询条件，开发人员可以在此增加过滤条件
			if ((null != xmhf.getXmxxbzj()) && (0 < xmhf.getXmxxbzj().trim().length())){
				paraMap.put("xmxxbzj", "%" + xmhf.getXmxxbzj().trim() + "%");
			}
			
			if ((null != xmhf.getXmjbr()) && (0 < xmhf.getXmjbr().trim().length())){
				paraMap.put("xmjbr", "%" + xmhf.getXmjbr().trim() + "%");
			}
			
			if (null != queryJbsjStart){
				paraMap.put("startJbsj", queryJbsjStart);
			}
			
			if (null != queryJbsjEnd){
				paraMap.put("endJbsj", queryJbsjEnd);
			}
		}
		if(null != xmxxb){
			//设置查询条件，开发人员可以在此增加过滤条件
			if ((null != xmxxb.getJsdw()) && (0 < xmxxb.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + xmxxb.getJsdw().trim() + "%");
			}
			if ((null != xmxxb.getXmmc()) && (0 < xmxxb.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + xmxxb.getXmmc().trim() + "%");
			}
			if ((null != xmxxb.getJsdd()) && (0 < xmxxb.getJsdd().trim().length())){
				paraMap.put("jsdd", "%" + xmxxb.getJsdd().trim() + "%");
			}
			if ((null != xmxxb.getXxylb()) && (0 < xmxxb.getXxylb().trim().length())){
				paraMap.put("xxylb", "%" + xmxxb.getXxylb().trim() + "%");
			}
			
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
//		final String filter = "id|xmxxbzj|xmjbr|jbsj|jbbz|hfzsdw|xmlsh|xxylb|jsdw|xmmc|jbcs|";
//		if (filter != null && filter.length() > 1) {
//			config.setJsonPropertyFilter(new PropertyFilter() {
//				public boolean apply(Object source, String name, Object value) {
//					if (filter.indexOf(name + "|") != -1)
//						return false;
//					else
//						return true;
//				}
//			});
//		}
		
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		pagination = xmhfService.findByPage1(pagination, paraMap);
		pagination.setListOfObject(pagination.getList());
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != xmhf)&&(null != xmhf.getId())){
			xmhf = xmhfService.getById(xmhf.getId());
			Xmxxb xmb=xmxxbService.getById(xmhf.getXmxxbzj());
			this.setRequestAttribute("xmxxb", xmb);
		}
		return VIEW;
	}

    /**
     * 查姓名
     * 
     * @return
     * @throws Exception
     */
    public String hristjuser() throws Exception {
        String nianyd = this.getRequest().getParameter("xmxxbzj");
        Xmxxb us = xmxxbService.getById(nianyd);
        if (us == null) {
            this.getResponse().getWriter().println("{\"result\":\"1\",\"message\":\"" + " " + "\"}");
            return null;
        } else {
            this.getResponse().getWriter().println("{\"result\":\"0\",\"csdw\":\"" + us.getJbcs().trim() + "\",\"message\":\"" + us.getXmmc().trim() + "\"}");

            return null;
        }

    }	
	
	
	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
		Xmhf xh=new Xmhf();
		if((null != xmhf)&&(null != xmhf.getId())){
			String start=xmhf.getStarts();
			xh = xmhfService.getById(xmhf.getId());
			xh.setUpdateTime(new Date());
			xh.setUpdateUserID(this.getLoginUserId());
			xh.setFhr(this.getLoginUser().getDisplayName());
			xh.setFhbz(xmhf.getFhbz()+" ");
			xh.setFhrid(this.getLoginUserId());
			xh.setFhsj(new Date());
			xh.setStarts(start);
			Xmxxb xxb = xmxxbService.getById(xmhf.getXmxxbzj());
			//退回
			if("0".equals(start)){
				xh.setStarts("");
				xxb.setHfsz("0");
				xxb.setHfsbz(xmhf.getFhbz()+" ");
			}
			//通过
			if("1".equals(start)){
				if("wqr".equals(xh.getDwdm())){
					//未确认的项目直接不走数字预审
					xxb.setHfsz("6");
				}else{
				xxb.setHfsz("2");
				}
				xxb.setZsdw(xh.getHfzsdw());
				//xxb.setZsfw(xh.getBxzd1());
				xxb.setDwdm(xh.getDwdm());
				xxb.setHfsbz(" ");
			}
			xmxxbService.update(xxb);
			xmhfService.update(xh);
			if("1".equals(start)){
			//创建数字预审
			Szys szys=new Szys();
			szys.setXmxxbzj(xh.getXmxxbzj());
			szys.setXmmc(xxb.getXmmc());
			szys.setZsdw(xh.getHfzsdw());
			szys.setZsfw(xh.getBxzd1());
			szys.setZjsmj(xxb.getZjsmj());
			szys.setYjje(xxb.getYjje());
			//单位代码
			szys.setBxzd1(xh.getDwdm());
			szys.setDeptId(this.getLoginUserDepartmentId());
			szys.setStarts("0");
			szys.setDelFlag(0);
			szysService.save(szys);
			}
		}
		
		return RELOAD;
	}

    /**
     * 同步施工系统
     * @return
     */
    public String  syncSgxt() throws Exception
    {
        System.out.println("划分复核开始同步施工许可系统，xxylb:"+fhid);
//        String str = "{ \"result\": \"false\",\"code\": \"1000\"}";
        if(StringUtil.isEmpty(fhid) || StringUtil.isEmpty(fhbz))
        {
            this.getResponse().getWriter().println("{\"result\":false}");
            return null;
        }
        Xmhf xmhf = xmhfService.getById(fhbz);
        Xmxxb xmxxb = xmxxbService.getByXxylb(fhid);
        if(xmxxb == null || xmhf == null )
        {
            this.getResponse().getWriter().println("{\"result\":false}");
            return null;
        }
		String dwdm = xmhf.getDwdm();

        System.out.println("dwdm是:"+dwdm);

        String r = CommonAction.send2wwSGXK(xmxxb,null,dwdm,null);

        System.out.println("r:"+r);

        if("true".equals(r))
        {
            this.getResponse().getWriter().println("{\"result\":true}");
        }
        else
        {
            this.getResponse().getWriter().println("{\"result\":false}");
        }
        return null;
    }
	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save1() throws Exception{
		
	    try{
	    	
			Xmhf xh=new Xmhf();
			if(!"".equals(fhid)){
				String start=fhzt;
				xh = xmhfService.getById(fhid);
				xh.setUpdateTime(new Date());
				xh.setUpdateUserID(this.getLoginUserId());
				xh.setFhr(this.getLoginUser().getDisplayName());
				xh.setFhbz(fhbz+" ");
				xh.setFhrid(this.getLoginUserId());
				xh.setFhsj(new Date());
				xh.setStarts(start);
				Xmxxb xxb = xmxxbService.getById(xh.getXmxxbzj());
				//退回
				if("0".equals(start)){
					xh.setStarts("");
					xxb.setHfsz("0");
					xxb.setHfsbz(fhbz+" ");
					xxb.setIstbsgxt("");//修改同步施工许可后，退回时将状态改为未同步
				}
				//通过
				if("1".equals(start)){
					if("wqr".equals(xh.getDwdm())){
						//未确认的项目直接不走数字预审
						xxb.setHfsz("6");
					}else{
						xxb.setHfsz("2");
					}
					xxb.setZsdw(xh.getHfzsdw());
					//xxb.setZsfw(xh.getBxzd1());
					xxb.setDwdm(xh.getDwdm());
					xxb.setHfsbz(" ");
				}
				xmxxbService.update(xxb);
				xmhfService.update(xh);
				if("1".equals(start)){
					//创建数字预审
					Szys szys=new Szys();
					szys.setXmxxbzj(xh.getXmxxbzj());
					szys.setXmmc(xxb.getXmmc());
					szys.setZsdw(xh.getHfzsdw());
					szys.setZsfw(xh.getBxzd1());
					szys.setZjsmj(xxb.getZjsmj());
					szys.setYjje(xxb.getYjje());
					//单位代码
					szys.setBxzd1(xh.getDwdm());
					szys.setDeptId(this.getLoginUserDepartmentId());
					szys.setStarts("0");
					szys.setDelFlag(0);
					szysService.save(szys);
				}
			}
	    	
	    	
				this.getResponse().getWriter().println("{\"result\":true}");
			}catch(Exception e){
				this.getResponse().getWriter().println("{\"result\":false}");
			}
		
		

		
		return null;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != xmhf)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到xmhf中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			xmhfService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Xmhf getXmhf(){
		return this.xmhf;
	}

	public void setXmhf(Xmhf xmhf){
		this.xmhf = xmhf;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
	public Date getQueryJbsjStart(){
		return this.queryJbsjStart;
	}

	public void setQueryJbsjStart(Date queryJbsjStart){
		this.queryJbsjStart = queryJbsjStart;
	}

	public Date getQueryJbsjEnd(){
		return this.queryJbsjEnd;
	}

	public void setQueryJbsjEnd(Date queryJbsjEnd){
		this.queryJbsjEnd = queryJbsjEnd;
	}

	public Date getQueryFhsjStart(){
		return this.queryFhsjStart;
	}

	public void setQueryFhsjStart(Date queryFhsjStart){
		this.queryFhsjStart = queryFhsjStart;
	}

	public Date getQueryFhsjEnd(){
		return this.queryFhsjEnd;
	}

	public void setQueryFhsjEnd(Date queryFhsjEnd){
		this.queryFhsjEnd = queryFhsjEnd;
	}

	public Xmxxb getXmxxb() {
		return xmxxb;
	}

	public void setXmxxb(Xmxxb xmxxb) {
		this.xmxxb = xmxxb;
	}
   
}
