package com.jshx.mobile.utils;

import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

import net.sf.json.JSONObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class DecodeStr {
	private static final Log logger = LogFactory.getLog(DecodeStr.class);

	// 手机端callback KEY
	private final String CALLBACK_KEY = "callback";

	public static String strDefaultKey = "h1y2i3j4l8";
	//
	private final int INVALIDATE_REQ = 100001;

	/**
	 * @param paras
	 * @param result
	 * @return
	 * 
	 *         创建时间：2012-8-29 创建人：wangbing 方法描述： （参数含义说明如下） 拼接callback内容返回给手机端
	 */
	private String contactCallBackString(Map<String, String> paras,
			String result) {
		try {
			StringBuffer rt = new StringBuffer();
			if (null == paras || paras.isEmpty()) {
				rt.append("null(");
			} else {
				rt.append((paras.get(CALLBACK_KEY))).append("(");
			}
			rt.append(result).append(")");
			return rt.toString();
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		return getExceptionJson("追加callback异常");
	}

	/**
	 * @return 返回请求无效字符串描述
	 */
	public String getNothingInReq() {
		JSONObject response = new JSONObject();
		response.put("TSR_RESULT", INVALIDATE_REQ);
		response.put("TSR_MSG", "无效的请求，没有包含任何有效参数");
		return response.toString();
	}

	public String getExceptionJson(String errorMsg) {
		JSONObject response = new JSONObject();
		response.put("TSR_RESULT", INVALIDATE_REQ);
		response.put("TSR_MSG", errorMsg);
		return response.toString();
	}

	public Map<String, String> getPostPara2(String content, String callback) {
		Map<String, String> paras = new HashMap<String, String>();
		try {
			if (null != callback && !"".equals(callback)) {
				paras.put(CALLBACK_KEY, callback);
			}
			logger.error("解密前内容：" + content);
			// System.out.println("解密前内容："+content);

			// 临时开放更新为不解密
			if (!content.contains("phoneBrand")) {
				content = SimpleDes.decrypt(content, DataDirection.FROM_MOBILE);
				logger.error("解密后内容：" + content);
				
			}
			if (null != content && !"".equals(content)) {
				if (content.indexOf(";") != -1) {
					String[] rs = content.split(";");
					for (int i = 0; i < rs.length; i++) {
						if (rs[i].indexOf("=") == -1) {
							continue;
						}
						String[] temp = rs[i].split("=");
						if (temp.length > 1) {
							// modify by wangbing
							// 增加替换等于号和分号=(%3d);(%3b)
							String str = temp[1].replaceAll("%3d", "=");
							str = str.replaceAll("%3b", ";");
							paras.put(temp[0], str);
						}
					}
				} else {
					if (content.indexOf("=") != -1) {
						String[] temp = content.split("=");
						if (temp.length > 1) {
							String str = temp[1].replaceAll("%3d", "=");
							str = str.replaceAll("%3b", ";");
							paras.put(temp[0], str);
						}
					}
				}
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		return paras;
	}

	public Map<String, String> getPostPara(String content, String callback) {
		Map<String, String> paras = new HashMap<String, String>();
		try {
			if (null != callback && !"".equals(callback)) {
				paras.put(CALLBACK_KEY, callback);
			}
			content=URLDecoder.decode(content,"UTF-8");
			logger.info("解密前内容：" + content);
			System.out.println("解密前内容：" + content);

			// 临时开放更新为不解密
			if (!content.contains("phoneBrand")) {
				DESUtil ttt = new DESUtil();
				content = ttt.decryption(content.replace(" ", "+"));
				System.out.println("解密后内容：" + content);
				logger.error("解密后内容：" + content);
			}
			if (null != content && !"".equals(content)) {
				if (content.indexOf(",") != -1) {
					String[] rs = content.split(",");
					for (int i = 0; i < rs.length; i++) {
						if (rs[i].indexOf("=") == -1) {
							continue;
						}
						String[] temp = rs[i].split("=");
						if (temp.length > 1) {
							// modify by wangbing
							// 增加替换等于号和分号=(%3d);(%3b)
							String str = temp[1].replaceAll("%3d", "=");
							str = str.replaceAll("%3b", ",");
							paras.put(temp[0], str);
						}
					}
				} else {
					if (content.indexOf("=") != -1) {
						String[] temp = content.split("=");
						if (temp.length > 1) {
							String str = temp[1].replaceAll("%3d", "=");
							str = str.replaceAll("%3b", ",");
							paras.put(temp[0], str);
						}
					}
				}
			}
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		return paras;
	}

}
