package com.jshx.message.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.jshx.core.base.entity.BaseModel;

@SuppressWarnings("serial")
@Entity
@Table(name = "JSHX_MESSAGE_INFO")
public class JshxMessageInfo extends BaseModel {
	/**
	 * 部门代码
	 */
	private String deptCode;

	/**
	 * 删除标记
	 */
	private Integer delFlag;

	/**
	 * 消息类型 "0"：公司通知 "1"：个人消息 "2"：短信群发
	 */
	private String msgtype;

	/**
	 * 消息发送方式 "1"：数据短信 "2"：普通短信 "3"：数据短信+普通短信
	 */
	private String msgchnl;

	/**
	 * 消息内容
	 */
	private String content;
	
	/**
	 * 消息标题
	 */
	private String title;
	
	/**
	 * 消息发送角色Id（以“;”分隔）
	 */
	private String msgInsertRoleid;
	
	/**
	 * 消息发送部门Id（以“;”分隔）
	 */
	private String msgInsertDeptcode;
	
	/**
	 * 附件Id
	 */
	private String attachIds;
	
	
	@Column(name="ATTACH_IDS")
	public String getAttachIds() {
		return attachIds;
	}

	public void setAttachIds(String attachIds) {
		this.attachIds = attachIds;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@Column
	public String getDeptCode() {
		return deptCode;
	}

	public void setDeptCode(String deptCode) {
		this.deptCode = deptCode;
	}

	@Column
	public Integer getDelFlag() {
		return delFlag;
	}

	public void setDelFlag(Integer delFlag) {
		this.delFlag = delFlag;
	}

	@Column(name = "MSGTYPE")
	public String getMsgtype() {
		return this.msgtype;
	}

	public void setMsgtype(String msgtype) {
		this.msgtype = msgtype;
	}

	@Column(name = "MSGCHNL")
	public String getMsgchnl() {
		return this.msgchnl;
	}

	public void setMsgchnl(String msgchnl) {
		this.msgchnl = msgchnl;
	}

	@Column(name = "CONTENT")
	public String getContent() {
		return this.content;
	}

	public void setContent(String content) {
		this.content = content;
	}
	
	public String getMsgInsertRoleid() {
		return msgInsertRoleid;
	}

	public void setMsgInsertRoleid(String msgInsertRoleid) {
		this.msgInsertRoleid = msgInsertRoleid;
	}

	public String getMsgInsertDeptcode() {
		return msgInsertDeptcode;
	}

	public void setMsgInsertDeptcode(String msgInsertDeptcode) {
		this.msgInsertDeptcode = msgInsertDeptcode;
	}

}
