package com.jshx.hscmj.web;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;

import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.hscmj.entity.Hscmj;
import com.jshx.hscmj.service.HscmjService;

import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

public class HscmjAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Hscmj hscmj = new Hscmj();

	/**
	 * 业务类
	 */
	@Autowired
	private HscmjService hscmjService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		if (null != hscmj)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != hscmj.getSlbh()) && (0 < hscmj.getSlbh().trim().length()))
			{
				paraMap.put("slbh", "%" + hscmj.getSlbh().trim() + "%");
			}

			if ((null != hscmj.getDmjzj()) && (0 < hscmj.getDmjzj().trim().length()))
			{
				paraMap.put("dmjzj", "%" + hscmj.getDmjzj().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = hscmjService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception
	{
		if ((null != hscmj) && (null != hscmj.getId()))
			hscmj = hscmjService.getById(hscmj.getId());

		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception
	{
		view();
		return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception
	{
		FileInputStream in = null;
		try
		{
			// 设置Blob字段
			setBlobField(in);
		} finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				} catch (Exception ex)
				{
				}
			}
		}

		if ("add".equalsIgnoreCase(this.flag))
		{
			hscmj.setDeptId(this.getLoginUserDepartmentId());
			hscmj.setDelFlag(0);
			hscmjService.save(hscmj);
		}
		else
		{
			hscmjService.update(hscmj);
		}

		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != hscmj)
		{
			try
			{
				// 此处将File对象转换成blob对象，并设置到hscmj中去

			} catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 删除信息
	 */
	public String delete() throws Exception
	{
		try
		{
			hscmjService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	public String getIds()
	{
		return ids;
	}

	public void setIds(String ids)
	{
		this.ids = ids;
	}

	public Pagination getPagination()
	{
		return pagination;
	}

	public void setPagination(Pagination pagination)
	{
		this.pagination = pagination;
	}

	public Hscmj getHscmj()
	{
		return this.hscmj;
	}

	public void setHscmj(Hscmj hscmj)
	{
		this.hscmj = hscmj;
	}

	public String getFlag()
	{
		return flag;
	}

	public void setFlag(String flag)
	{
		this.flag = flag;
	}

}
