package com.jshx.account.accountBank.service;

import java.util.Map;

import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.account.accountBank.entity.AccountBank;

public interface AccountBankService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public AccountBank getById(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(AccountBank model, String fileName, String originFileName);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(AccountBank model);
	
	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(AccountBank model, String fileName, String originFileName);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);
	
	/**
	 * 财务确认-待缴款
	 * @param orderId
	 * @param ids
	 * @param outcome
	 */
	public void accountConfirmPending(String orderId, String ids, String outcome, String userId, IdentityService identityService, RuntimeService runtimeService);

	/**
	 * 财务确认-缓缴款
	 * @param orderId
	 * @param ids
	 * @param outcome
	 */
	public void accountConfirmDelay(String orderId, String ids, String userId, IdentityService identityService, RuntimeService runtimeService);
}
