package com.jshx.module.infomation.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.module.infomation.entity.ContentInformations;
import com.jshx.module.infomation.dao.ContentInformationsDao;

@Component("contentInformationsDao")
public class ContentInformationsDaoImpl extends BaseDaoImpl implements ContentInformationsDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findContentInformationsByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findContentInformations(Map<String, Object> paraMap){
		return this.findListByHqlId("findContentInformationsByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ContentInformations getById(String id)
	{
		return (ContentInformations)this.getObjectById(ContentInformations.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(ContentInformations contentInformations)
	{
		contentInformations.setId(null);
		//此处处理Blob对象（Blob对象不能直接insert）
		this.saveOrUpdateObject(contentInformations);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(ContentInformations contentInformations)
	{
		this.saveOrUpdateObject(contentInformations);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(ContentInformations.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		ContentInformations contentInformations = (ContentInformations)this.getObjectById(ContentInformations.class, id);
		contentInformations.setDelFlag("1");
		this.saveObject(contentInformations);
	}
	/**
	 * 激活信息
	 */
	public void activeInfo(String id){
		ContentInformations contentInformations = (ContentInformations)this.getObjectById(ContentInformations.class, id);
		contentInformations.setDelFlag("0");
		this.saveObject(contentInformations);
	}
	
	/**
	 * 设置信息过期
	 */
	public void expireInfo(String id){
		ContentInformations contentInformations = (ContentInformations)this.getObjectById(ContentInformations.class, id);
		contentInformations.setExpireFlag("1");
		this.saveObject(contentInformations);
	}
	
	/**
	 * 设置信息使用
	 */
	public void inexpireInfo(String id){
		ContentInformations contentInformations = (ContentInformations)this.getObjectById(ContentInformations.class, id);
		contentInformations.setExpireFlag("0");
		this.saveObject(contentInformations);
	}
}
