package com.jshx.extend.dao.impl;

import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.extend.entity.UserExtend;
import com.jshx.module.admin.extend.IUserExtendInfo;
import com.jshx.module.admin.extend.IUserExtendInfoDao;

@Component("userExtendDao")
public class UserExtendDaoImpl extends BaseDaoImpl implements
		IUserExtendInfoDao {

	@Override
	public IUserExtendInfo getByUserId(String userId) {
		return (IUserExtendInfo)getObjectByProperty(UserExtend.class, "userId", userId);
	}

	@Override
	public IUserExtendInfo saveUserExtendInfo(IUserExtendInfo userExtendInfo) {
		saveOrUpdateObject(userExtendInfo);
		return userExtendInfo;
	}

	@Override
	public IUserExtendInfo updateIUserExtendInfo(IUserExtendInfo userExtendInfo) {
		updateObject(userExtendInfo);
		return userExtendInfo;
	}

}
