/**
 * 
 */
package com.jshx.activiti.delay;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.activiti.bpmn.model.DelayProperty;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author chensy
 * @version 2016年9月6日 下午4:08:47
 */
public class DelayInfo {
	
	private static final Logger delayInfoLogger = LoggerFactory.getLogger(DelayInfo.class);
	
	private String taskInstanceId;
	private String taskId;
	
	private String dTypeString = "";
	private String dTimeString = "";
	private String dCycleString = "";

	private String dType = "";
	private long dTime;
	private long dCycle = 0;
	private int dRound = 1;
	private String dImpClass = "";
	
	private boolean isCorrectInfo = false;
	
	DelayInfo(DelayProperty delayProperty){

		dTimeString = delayProperty.getDelayTime();
		dTypeString = delayProperty.getDelayType();	
		dCycleString = delayProperty.getDelayCycle();
		dImpClass = delayProperty.getDelayClass();
		
		isCorrectInfo = checkInfo();
		
	}
	
	private boolean checkInfo(){
		if( dImpClass == null ||dImpClass.isEmpty()){
			delayInfoLogger.warn("无法创建超时告警对象，原因: 实现类为空");
			return false;
		}
		
		if(!checkDType()){
			delayInfoLogger.warn("无法创建超时告警对象，原因: 告警类型相关错误");
			return false;
		}

		if( !checkDTime() ){
			delayInfoLogger.warn("无法为超时告警功能解析当前任务的告警时间属性");
			return false;
		}

		
		if( dCycleString!= null && !dCycleString.isEmpty() && !checkDCycle()){
			delayInfoLogger.warn("无法创建超时告警对象，原因: 错误的告警周期设置");
			return false;
		}

		return true;
	}
	
	private boolean checkDType(){
		if( dTypeString.equals("超时前告警")){//超时前告警需要提供dueDate属性
			dType = "超时前告警";
			return true;
		}else if( dTypeString.equals("超时后通知")){//超时后告警需要获取任务创建时间
			dType = "超时后通知";
			return true;
		}else{
			//dTypeString为空或者格式非法
			return false;
		}
	}
	
	private boolean checkDTime(){
		
		boolean isParesSuccess = false;

		Pattern pattern = Pattern.compile("^((\\d*)H(\\d*)M)");
		Pattern patternNoMinute = Pattern.compile("^((\\d*)H)");
		Pattern patternNoHour = Pattern.compile("^((\\d*)M)");

		Matcher matcher = pattern.matcher(dTimeString);
		Matcher matcherNoMinute = patternNoMinute.matcher(dTimeString);
		Matcher matcherNoHour = patternNoHour.matcher(dTimeString);
		if (matcher.find()) {
			String time = matcher.group();
			int hour = Integer.parseInt(time.substring(0, time.indexOf('H')));
			int min = Integer.parseInt(time.substring(time.indexOf('H') + 1, time.indexOf('M')));
			dTime = hour * 3600 * 1000L + min * 60 * 1000L;
			isParesSuccess = true;
		} else if (matcherNoHour.find()) {
			String time = matcherNoHour.group();
			int min = Integer.parseInt(time.substring(0, time.indexOf('M')));
			dTime = min * 60 * 1000L;
			isParesSuccess = true;
		}else if(matcherNoMinute.find()){
			String time = matcherNoMinute.group();
			int hour = Integer.parseInt(time.substring(0, time.indexOf('H')));
			dTime = hour * 3600 * 1000L;
			isParesSuccess = true;
		}
		return isParesSuccess;
		
	}
	
	private boolean checkDCycle(){
		
		
		boolean isParesSuccess = false;

		Pattern patternNoR = Pattern.compile("^((\\d*)H)");
		Pattern pattern = Pattern.compile("^(R(\\d*)/PT(\\d*)H)");

		Matcher matchNoR = patternNoR.matcher(dCycleString);
		Matcher match = pattern.matcher(dCycleString);

		if (match.find()) {
			dCycle = Integer.parseInt(dCycleString.substring(dCycleString.indexOf('T') + 1, dCycleString.indexOf('H'))) * 3600000L;
			dRound = Integer.parseInt(dCycleString.substring(1, dCycleString.indexOf('/')));
			isParesSuccess = true;
		} else if (matchNoR.find()) {
			int hour = Integer.parseInt(dCycleString.substring(0, dCycleString.indexOf('H')));
			dCycle = hour * 3600 * 1000L;
			isParesSuccess = true;
		}

		return isParesSuccess;
	}

	/**
	 * @return the dType
	 */
	public String getdType() {
		return dType;
	}

	/**
	 * @param dType the dType to set
	 */
	public void setdType(String dType) {
		this.dType = dType;
	}

	/**
	 * @return the dTime
	 */
	public long getdTime() {
		return dTime;
	}

	/**
	 * @param dTime the dTime to set
	 */
	public void setdTime(long dTime) {
		this.dTime = dTime;
	}

	/**
	 * @return the dCycle
	 */
	public long getdCycle() {
		return dCycle;
	}

	/**
	 * @param dCycle the dCycle to set
	 */
	public void setdCycle(long dCycle) {
		this.dCycle = dCycle;
	}

	/**
	 * @return the dRound
	 */
	public int getdRound() {
		return dRound;
	}

	/**
	 * @param dRound the dRound to set
	 */
	public void setdRound(int dRound) {
		this.dRound = dRound;
	}

	/**
	 * @return the dImpClass
	 */
	public String getdImpClass() {
		return dImpClass;
	}

	/**
	 * @param dImpClass the dImpClass to set
	 */
	public void setdImpClass(String dImpClass) {
		this.dImpClass = dImpClass;
	}

	/**
	 * @return the isCorrectInfo
	 */
	public boolean isCorrectInfo() {
		return isCorrectInfo;
	}

	/**
	 * @param isCorrectInfo the isCorrectInfo to set
	 */
	public void setCorrectInfo(boolean isCorrectInfo) {
		this.isCorrectInfo = isCorrectInfo;
	}
	
	/**
	 * @return the taskInstanceId
	 */
	public String getTaskInstanceId() {
		return taskInstanceId;
	}

	/**
	 * @param taskInstanceId the taskInstanceId to set
	 */
	public void setTaskInstanceId(String taskInstanceId) {
		this.taskInstanceId = taskInstanceId;
	}

	/**
	 * @return the taskId
	 */
	public String getTaskId() {
		return taskId;
	}

	/**
	 * @param taskId the taskId to set
	 */
	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}
	
}
