/**
 * Created by richie on 15/11/11.
 */
;(function($){
    FR.layoutFrozen = function ($container, pageTop) {
        var $center = $('.frozen-center', $container);
        var $corner = $('.frozen-corner', $container);
        var $north = $('.frozen-north', $container);
        var $west = $('.frozen-west', $container);

        if ($center.length > 0 || $corner.length > 0 || $north.length > 0 || $west.length > 0) {

            var cornerNorthHeight = 0;
            $('.rows-height-counter', $north).each(function () {
                cornerNorthHeight += $(this).height();
            });
            var calculateDivHeight = function () {
                //引用传递, 不要改变pageTop
                var top = pageTop;
                var buttonBarHeight = 0;

                var pageHeight = FR.windowHeight - cornerNorthHeight;

                var tabPane = contentPane.$contentPane.data('TabPane');
                if (tabPane) {
                    top += tabPane.options.tabHeight;
                }

                if (FR.hasBottomToolbar) {
                    top += FR.toolbarHeight;
                }

                if (FR.parameterContainerHeight > 0) {
                    var parameterPane = $('.parameter-container');
                    var visibility = parameterPane.isVisible();
                    var parameterHeight = FR.parameterContainerHeight;
                    if (visibility && top < parameterHeight) {
                        top += parameterHeight;
                    } else if (!visibility && top > parameterHeight) {
                        top -= parameterHeight;
                    }
                }

                pageHeight -= top;

                return pageHeight;
            };

            var setFrozenDiv = function () {
                var pageWidth;
                var pageHeight = calculateDivHeight();

                var $contentDIV = $(".pageContentDIV", this.$contentPane);
                var isPageCenter = $contentDIV.hasClass("contentDIV");
                var isFrozen = false;
                if ($('.frozen-table', $container).length > 0) {
                    isFrozen = true;
                }
                if (isPageCenter) {//分页居中的处理方式
                    var left = parseInt($(".report-background").css('left'));
                    if (FR.Browser.isIE8Before()){
                        left = parseInt($("#fr-page-content").css('left'));
                    }
                    // ie读出来的left可能是auto left就是NaN
                    left = isNaN(left) ? 0 : left;
                    var contentdivWidth = $contentDIV.width();
                    var frozenWidth = Math.min($('.content-container').width(), contentdivWidth) - left;
                    $(".frozen-page").css('width', frozenWidth);
                    pageWidth = frozenWidth;
                    if (pageWidth == contentdivWidth) {
                        //当页面设置超出一个屏幕时, 就不需要减了, 因为取得是frozenpage的
                        pageWidth -= left;//左右边距
                    }
                    var top = parseInt($(".report-background").css('top'));
                    if (FR.Browser.isIE8Before()){
                        top = parseInt($("#fr-page-content").css('top'));
                    }
                    top = isNaN(top) ? 0 : top;
                    pageHeight -= (top + 24);//上下边距
                    // north center 的宽度应该是frozen-page的宽度减去corner的宽度
                    pageWidth -= $corner.width();
                } else {
                    var westWidth = 0;
                    var xtable = $('table.x-table', $west);
                    if (xtable.length > 0) {
                        westWidth = parseInt(xtable[0].style.width || 0);
                        if (westWidth > 0) {
                            westWidth += 1;
                        }
                    }
                    if (!westWidth || westWidth === 0) {
                        westWidth = $west.width();
                    }
                    if (isFrozen) {//非分页居中的冻结:分页居左，填报居左，填报居中，数据分析居左
                        pageWidth = FR.windowWidth - parseInt($container[0].style['margin-left'] || 0) - westWidth;
                    } else {
                        pageWidth = FR.windowWidth - westWidth;
                    }

                    pageHeight -= $(".HF-footer").height();
                    pageHeight -= $(".HF-header").height();
                }

                //IE下为负值可能会报参数错误
                if (pageWidth < 0) {
                    pageWidth = 0;
                }
                if (pageHeight < 0) {
                    pageHeight = 0;
                }

                if ($center.length > 0) {
                    $center[0].style.width = pageWidth + 'px';
                    $center[0].style.height = pageHeight + 'px';
                }
                if ($north.length > 0) {
                    $north[0].style.width = pageWidth + 'px';
                }
                if ($west.length > 0) {
                    $west[0].style.height = pageHeight + 'px';
                }

                // 火狐浏览器 north高度比较小的时候 不设置高度的话外框会比内部高
//                if ($.browser.mozilla) {
//                    $north.height($north.children().height());
//                }

            };

            var checkViewMultiSheet = function () {
                if ($west.width() === 0 && cornerNorthHeight === 0) {
                    //view下切换多sheet时, 会造成container变化, 导致$west,$north需要重新获取成当前lgp的
                    $container = $('.sheet-container');
                    var len = $('.frozen-center', $container).length;
                    for (var i = 0; i < len; i++) {
                        var tempWest = $($('.frozen-west', $container)[i]);
                        var tempNorth = $($('.frozen-north', $container)[i]);
                        if (tempWest.width() !== 0 && tempNorth.height() !== 0) {
                            $west = tempWest;
                            $north = tempNorth;
                            $center = $($('.frozen-center', $container)[i]);
                            $corner = $($('.frozen-corner', $container)[i]);
                            break;
                        }
                    }
                }
            };

            setFrozenDiv();
            // alex:$center_block滚动的时,north & west也要跟着滚
            var lastLeft = 0;
            var lastTop = 0;
            //$center和$west的scroll会相互影响使滚动变卡,所以$center滚动时暂时禁用$west的scroll事件
            var westScroll = function () {
                $center.scrollTop($west.scrollTop());
            }.createDelegate(this);
            var scrollTimerId = null;
            $center.scroll(function () {
                var left = $center.scrollLeft();
                var top = $center.scrollTop();
                if (left != lastLeft) {
                    $north.scrollLeft(left);
                    lastLeft = left;
                }
                if (top != lastTop) {
                    $west.off('scroll', westScroll);
                    $west.scrollTop(top);
                    if (scrollTimerId) {
                        clearTimeout(scrollTimerId);
                    }
                    scrollTimerId = setTimeout(function () {
                        $west.on('scroll', westScroll);
                        scrollTimerId = null;
                    }, 100);
                    lastTop = top;
                }
            }.createDelegate(this));

            //zack:页面搜索的时候会使得左边滚起来的，这样的话中间也要跟着滚bug:70678
            $west.on('scroll', westScroll);

            //当ie下div的overflow-y为scroll时，无论overflow-x如何设置，下层的table或iframe过宽时，都能通过鼠标进行左右滚动，
            //只好在ie下添加上center随north滚动的事件了。
            if(FR.Browser.isIE()){
                $north.scroll(function () {
                    $center.scrollLeft($north.scrollLeft());
                }.createDelegate(this));
            }

            window.onresize = function () {
                if (self.resizeid != null) {
                    clearTimeout(self.resizeid);
                    self.resizeid = null;
                }
                self.resizeid = setTimeout(function () {
                    checkViewMultiSheet();
                    setFrozenDiv();
                }, 200);
            };
        }
    };
})(jQuery);
