/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.impl.ContainerUtil;
import org.directwebremoting.impl.StartupUtil;
import org.directwebremoting.servlet.UrlProcessor;
import org.directwebremoting.spring.SpringContainer;
import org.directwebremoting.util.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DwrSpringServlet
extends HttpServlet {
    private SpringContainer container;
    protected WebContextFactory.WebContextBuilder webContextBuilder;
    private boolean includeDefaultConfig = true;
    private List configurators = new ArrayList();
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$spring$DwrSpringServlet == null ? (class$org$directwebremoting$spring$DwrSpringServlet = DwrSpringServlet.class$("org.directwebremoting.spring.DwrSpringServlet")) : class$org$directwebremoting$spring$DwrSpringServlet);
    static /* synthetic */ Class class$org$directwebremoting$servlet$UrlProcessor;
    static /* synthetic */ Class class$org$directwebremoting$spring$DwrSpringServlet;

    public void setConfigurators(List configurators) {
        this.configurators = configurators;
    }

    public void setIncludeDefaultConfig(boolean includeDefaultConfig) {
        this.includeDefaultConfig = includeDefaultConfig;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServletContext servletContext = servletConfig.getServletContext();
        try {
            WebApplicationContext webappContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
            this.container = new SpringContainer();
            this.container.setBeanFactory((BeanFactory)webappContext);
            ContainerUtil.setupDefaults(this.container, servletConfig);
            ContainerUtil.setupFromServletConfig(this.container, servletConfig);
            this.container.setupFinished();
            this.webContextBuilder = StartupUtil.initWebContext(servletConfig, servletContext, this.container);
            StartupUtil.initServerContext(servletConfig, servletContext, this.container);
            ContainerUtil.prepareForWebContextFilter(servletContext, servletConfig, this.container, this.webContextBuilder, this);
            try {
                this.configurators.add(webappContext.getBean("__dwrConfiguration"));
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new ServletException("No DWR configuration was found in your application context, make sure to define one", (Throwable)ex);
            }
            if (this.includeDefaultConfig) {
                ContainerUtil.configureFromSystemDwrXml(this.container);
            }
            ContainerUtil.configureFromInitParams(this.container, servletConfig);
            ContainerUtil.configure(this.container, this.configurators);
            ContainerUtil.publishContainer(this.container, servletConfig);
        }
        catch (InstantiationException ex) {
            throw new BeanCreationException("Failed to instansiate", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanCreationException("Access error", (Throwable)ex);
        }
        catch (Exception ex) {
            log.fatal("init failed", ex);
            throw new ServletException((Throwable)ex);
        }
        finally {
            this.webContextBuilder.unset();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.webContextBuilder.set(request, response, this.getServletConfig(), this.getServletContext(), this.container);
            UrlProcessor processor = (UrlProcessor)this.container.getBean((class$org$directwebremoting$servlet$UrlProcessor == null ? (class$org$directwebremoting$servlet$UrlProcessor = DwrSpringServlet.class$("org.directwebremoting.servlet.UrlProcessor")) : class$org$directwebremoting$servlet$UrlProcessor).getName());
            processor.handle(request, response);
        }
        finally {
            this.webContextBuilder.unset();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

