/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.FRContext;
import com.fr.base.TemplateUtils;
import com.fr.general.Inter;
import com.fr.privilege.Authentication;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.authentication.AuthenticationFactory;
import com.fr.stable.CodeUtils;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginUIAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!PrivilegeManager.getProviderInstance().hasSetFSSystemPW()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("company", FRContext.getCompanyName() + Inter.getLocText((String)"FS-Frame-Simple_Platform"));
            hashMap.put("isSupportFS", "false");
            WebUtils.writeOutTemplate((String)"/com/fr/fs/web/system_manager_set.html", (HttpServletResponse)httpServletResponse, hashMap);
            return;
        }
        Authentication authentication = AuthenticationFactory.exAuth4CommonAccess((HttpServletRequest)httpServletRequest);
        if (authentication != null && authentication.isAuthenticated()) {
            String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"fr_from");
            if (StringUtils.isNotEmpty((String)string)) {
                httpServletResponse.sendRedirect(CodeUtils.cjkEncode((String)string));
            } else if (StringUtils.isNotEmpty((String)PrivilegeManager.getProviderInstance().getForwardUrl())) {
                httpServletResponse.sendRedirect(TemplateUtils.render((String)PrivilegeManager.getProviderInstance().getForwardUrl()));
            } else {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("fr_info", authentication.getPrincipal() + " has Logged!");
                WebUtils.writeOutTemplate((String)"/com/fr/fs/web/platform/html/info.html", (HttpServletResponse)httpServletResponse, hashMap);
            }
        }
    }

    public String getCMD() {
        return "ah_loginui";
    }
}

